/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.security.zip;

import com.semarchy.xdi.security.zip.ZipArchiveThresholdInputStream;
import java.io.File;
import java.io.IOException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ZipSecureFile
extends ZipFile {
    private static final Logger LOG = LogManager.getLogger(ZipSecureFile.class);
    static double minInflateRatio;
    static long maxEntrySize;
    static long maxFileCount;
    static long graceEntrySize;
    private static long maxTextSize;
    public static final String MAX_FILE_COUNT_MSG = "The file appears to be potentially malicious. This file embeds more internal file entries than expected.\nThis may indicates that the file could pose a security risk.\nYou can adjust this limit via ZipSecureFile.setMaxFileCount() if you need to work with files which are very large.\nLimits: MAX_FILE_COUNT: %d\n";
    private final String fileName;

    static {
        ZipSecureFile.setMinInflateRatio(Double.parseDouble(System.getProperty("xdi.zip.protect.minInflateRatio", "0.01")));
        ZipSecureFile.setMaxEntrySize(Long.getLong("xdi.zip.protect.maxEntrySize", 0xFFFFFFFFL));
        ZipSecureFile.setMaxFileCount(Long.getLong("xdi.zip.protect.maxFileCount", 1000L));
        ZipSecureFile.setGraceEntrySize(Long.getLong("xdi.zip.protect.graceEntrySize", 102400L));
        ZipSecureFile.setMaxTextSize(Long.getLong("xdi.zip.protect.maxTextSize", 0xA00000L));
    }

    public static void setMinInflateRatio(double ratio) {
        minInflateRatio = ratio;
    }

    public static double getMinInflateRatio() {
        return minInflateRatio;
    }

    public static long getMaxFileCount() {
        return maxFileCount;
    }

    public static void setMaxFileCount(long paramMaxFileCount) {
        maxFileCount = paramMaxFileCount;
    }

    public static void setMaxEntrySize(long paramMaxEntrySize) {
        if (maxEntrySize < 0L) {
            throw new IllegalArgumentException("Max entry size must be greater than or equal to zero");
        }
        if (maxEntrySize > 0xFFFFFFFFL) {
            LOG.atWarn().log("setting max entry size greater than 4Gb can be risky; set to " + maxEntrySize + " bytes");
        }
        maxEntrySize = paramMaxEntrySize;
    }

    public static long getMaxEntrySize() {
        return maxEntrySize;
    }

    public static void setGraceEntrySize(long paramGraceEntrySize) {
        if (graceEntrySize < 0L) {
            throw new IllegalArgumentException("Grace entry size must be greater than or equal to zero");
        }
        graceEntrySize = paramGraceEntrySize;
    }

    public static long getGraceEntrySize() {
        return graceEntrySize;
    }

    public static void setMaxTextSize(long paramMaxTextSize) {
        if (maxTextSize < 0L) {
            throw new IllegalArgumentException("Max text size must be greater than or equal to zero");
        }
        if (maxTextSize > 0xA00000L) {
            LOG.atWarn().log("setting max text size greater than 10485760 can be risky; set to " + maxTextSize + " chars");
        }
        maxTextSize = paramMaxTextSize;
    }

    public static long getMaxTextSize() {
        return maxTextSize;
    }

    public ZipSecureFile(File file) throws IOException {
        super(file);
        this.fileName = file.getAbsolutePath();
    }

    public ZipSecureFile(String name) throws IOException {
        super(name);
        this.fileName = new File(name).getAbsolutePath();
    }

    public ZipArchiveThresholdInputStream getInputStream(ZipArchiveEntry entry) throws IOException {
        ZipArchiveThresholdInputStream zatis = new ZipArchiveThresholdInputStream(super.getInputStream(entry));
        zatis.setEntry(entry);
        return zatis;
    }

    public String getName() {
        return this.fileName;
    }

    public File safeCreateOutputFile(File outDir, ZipArchiveEntry entry) throws IOException {
        File outFile = new File(outDir, entry.getName());
        if (Boolean.getBoolean("xdi.zip.protect.maxEntrySize.disablePathTraversalProtection")) {
            return outFile;
        }
        File canonicalOutFile = outFile.getCanonicalFile();
        String canonicalOutDir = outDir.getCanonicalPath();
        if (!canonicalOutFile.toPath().startsWith(canonicalOutDir)) {
            throw new IOException(String.format("Path traversal attack detected ! unzipped output path[%s] does not start with outDir[%s].", canonicalOutFile, canonicalOutDir));
        }
        return outFile;
    }
}

