/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.externalization;

import com.indy.gmf.proc.ActionProcess;
import com.indy.gmf.proc.Parameter;
import com.indy.gmf.proc.ProcPackage;
import com.semarchy.xdi.designer.core.services.IModelTranslationProvider;
import com.semarchy.xdi.designer.core.utils.MetaInfParserUtil;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProcMessageProvider {
    Properties externalizedProps;

    public ProcMessageProvider(URI uri) {
        Assert.isTrue((uri != null && "com.indy.environment".equals(uri.segment(1)) ? 1 : 0) != 0);
        this.loadProperties(uri);
    }

    private void loadProperties(URI uri) {
        BundleContext ctx = Platform.getBundle((String)"com.indy.gmf.process").getBundleContext();
        ServiceReference sr = ctx.getServiceReference(IModelTranslationProvider.class);
        IModelTranslationProvider provider = null;
        this.externalizedProps = new Properties();
        if (sr != null) {
            try {
                List u;
                provider = (IModelTranslationProvider)ctx.getService(sr);
                if (provider != null && (u = provider.getTranslationFileURI(uri)) != null) {
                    u.stream().forEach(p -> {
                        try {
                            Throwable throwable = null;
                            Object var3_5 = null;
                            try (InputStreamReader is = new InputStreamReader(p.toURL().openStream(), "UTF-8");){
                                this.externalizedProps.load(is);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    });
                }
            }
            finally {
                provider = null;
                ctx.ungetService(sr);
            }
        }
    }

    private void setFeature(EStructuralFeature f, EObject object, String value) {
        if (value != null) {
            try {
                object.eSet(f, (Object)value);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private List<String> getKeys(Parameter p, EStructuralFeature f) {
        ArrayList<String> keys = new ArrayList<String>();
        String path = p.getFullPath();
        path = path.substring(path.indexOf("/") + 1);
        switch (f.getFeatureID()) {
            case 0: {
                keys.add(path + ".description");
                break;
            }
            case 7: {
                keys.add(path + ".label");
                break;
            }
            case 2: {
                List vals = p.getPossibleValuesLabels();
                if (vals == null) break;
                for (String s : vals) {
                    try {
                        String val = p.getValueForLabel(s);
                        keys.add(path + ".enum." + val + ".label");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                break;
            }
        }
        return keys;
    }

    public void setMessages(Parameter p) {
        if (this.externalizedProps.size() == 0) {
            return;
        }
        this.getKeys(p, (EStructuralFeature)ProcPackage.eINSTANCE.getParameter_Label()).forEach(k -> this.setFeature((EStructuralFeature)ProcPackage.eINSTANCE.getParameter_Label(), p, this.externalizedProps.getProperty((String)k)));
        this.getKeys(p, (EStructuralFeature)ProcPackage.eINSTANCE.getCommon_Description()).forEach(k -> this.setFeature((EStructuralFeature)ProcPackage.eINSTANCE.getCommon_Description(), p, this.externalizedProps.getProperty((String)k)));
        String metaInf = p.getMetaInf();
        if (metaInf != null && !metaInf.isEmpty()) {
            List<String> keys = this.getKeys(p, (EStructuralFeature)ProcPackage.eINSTANCE.getCommon_MetaInf());
            NodeList nl = MetaInfParserUtil.parseMetaInf((String)metaInf);
            StringBuilder b = new StringBuilder();
            int i = 0;
            while (nl != null && i < nl.getLength()) {
                Node node = nl.item(i);
                b.append("<metaInf");
                AtomicReference<String> value = new AtomicReference<String>();
                String currentLabel = null;
                int j = 0;
                while (j < node.getAttributes().getLength()) {
                    String name = node.getAttributes().item(j).getNodeName();
                    if (name.equals("label")) {
                        currentLabel = node.getAttributes().item(j).getNodeValue();
                    } else {
                        if (name.equals("value")) {
                            value.set(node.getAttributes().item(j).getNodeValue());
                        }
                        b.append(" " + name + "=\"" + node.getAttributes().item(j).getNodeValue() + "\"");
                    }
                    ++j;
                }
                List l = keys.stream().filter(k -> k.endsWith(".enum." + (String)value.get() + ".label")).collect(Collectors.toList());
                String newLabel = null;
                if (!l.isEmpty()) {
                    newLabel = this.externalizedProps.getProperty((String)l.get(0));
                }
                if (newLabel == null) {
                    newLabel = currentLabel;
                }
                if (newLabel != null) {
                    b.append(" label=\"" + newLabel + "\"");
                }
                b.append("/>\n");
                ++i;
            }
            if (b.length() > 0) {
                b.append(MetaInfParserUtil.getNonMetaInf((String)metaInf));
                this.setFeature((EStructuralFeature)ProcPackage.eINSTANCE.getCommon_MetaInf(), p, b.toString());
            }
        }
    }

    public void setMessages(ActionProcess proc) {
        if (this.externalizedProps.size() == 0) {
            return;
        }
        String desc = this.externalizedProps.getProperty("description");
        this.setFeature((EStructuralFeature)ProcPackage.eINSTANCE.getCommon_Description(), proc, desc);
    }
}

