/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.api.internal;

import com.indy.map.api.IMetaDataInformationsProvider;
import com.indy.map.api.internal.Messages;
import com.indy.map.custom.commands.UpdateDatastoreCommand;
import com.stambia.md.Attribute;
import com.stambia.md.MdNode;
import com.stambia.tech.Level;
import com.stambia.tech.MappingInfo;
import com.stambia.tech.MappingType;
import com.stambia.tech.XpathExpression;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.osgi.framework.Bundle;

public class MdEvaluator {
    private Logger logger = LogManager.getLogger(MdEvaluator.class);
    private static final Set<MappingType> STAGE;
    private static final Set<MappingType> FIELD;
    private static final Set<MappingType> DATASTORE;
    private static final Set<MappingType> CONSTRAINT;
    private static final Set<MappingType> VARIABLE;
    private boolean enableCheckNodeType;

    static {
        HashSet<MappingType> s = new HashSet<MappingType>();
        s.add(MappingType.STAGING);
        STAGE = Collections.unmodifiableSet(s);
        s = new HashSet();
        s.add(MappingType.CONSTRAINT);
        CONSTRAINT = Collections.unmodifiableSet(s);
        s = new HashSet();
        s.add(MappingType.VARIABLE);
        VARIABLE = Collections.unmodifiableSet(s);
        s = new HashSet();
        s.add(MappingType.SOURCE);
        s.add(MappingType.TARGET);
        DATASTORE = Collections.unmodifiableSet(s);
        s = new HashSet();
        s.add(MappingType.MAPPING);
        s.add(MappingType.SOURCE_MAPPING);
        s.add(MappingType.TARGET_MAPPING);
        FIELD = Collections.unmodifiableSet(s);
    }

    public MdEvaluator(boolean enableCheckNodeType) {
        this.enableCheckNodeType = enableCheckNodeType;
    }

    public boolean checkNodeType(MdNode node, Type ... type) {
        if (!this.enableCheckNodeType) {
            return true;
        }
        if (node == null || node.eIsProxy()) {
            throw new RuntimeException("Null/proxy MdNode");
        }
        if (node.getLevel() == null) {
            return false;
        }
        Type[] typeArray = type;
        int n = type.length;
        int n2 = 0;
        while (n2 < n) {
            Type t = typeArray[n2];
            if (t.isValid(node)) {
                return true;
            }
            ++n2;
        }
        return type.length == 0;
    }

    private String evaluateMappingInfo(MdNode node, MappingInfo inf) {
        Attribute mandatoryAttr;
        block10: {
            XpathExpression expr;
            Level lvl;
            String xPathExpression = null;
            switch (inf) {
                case MANDATORY: {
                    xPathExpression = "INTERNAL_MAPPING_INFO_MANDATORY";
                    break;
                }
                case PRECISION: {
                    xPathExpression = "INTERNAL_MAPPING_INFO_PRECISION";
                    break;
                }
                case SIZE: {
                    xPathExpression = "INTERNAL_MAPPING_INFO_SIZE";
                    break;
                }
                case TYPE: {
                    xPathExpression = "INTERNAL_MAPPING_INFO_TYPE";
                }
            }
            if (xPathExpression != null && (lvl = node.getLevel()) != null && (expr = lvl.findXPathExpression(xPathExpression)) != null) {
                try {
                    String res = node.evaluateXpathExpressionCached(xPathExpression, null);
                    if (res != null) {
                        return res;
                    }
                }
                catch (XPathExpressionException ex) {
                    if (!this.logger.isDebugEnabled()) break block10;
                    this.logger.error("Failed to evaluate xPathExpression {} on {}", (Object)xPathExpression, (Object)EcoreUtil.getURI((EObject)node), (Object)ex);
                }
            }
        }
        return (mandatoryAttr = node.getAttributeByMapInfo(inf)) == null ? null : mandatoryAttr.getValueOrRefValue();
    }

    public String evaluateConstraintType(MdNode node) {
        Level l;
        if (this.checkNodeType(node, Type.CONSTRAINT) && (l = node.getLevel()) != null) {
            return l.getXmlName();
        }
        return null;
    }

    public String evaluateMandatory(MdNode node) {
        if (this.checkNodeType(node, Type.FIELD)) {
            String val = this.evaluateMappingInfo(node, MappingInfo.MANDATORY);
            return val;
        }
        return null;
    }

    public String evaluatePrecision(MdNode node) {
        if (this.checkNodeType(node, Type.FIELD)) {
            String val = this.evaluateMappingInfo(node, MappingInfo.PRECISION);
            return val;
        }
        return null;
    }

    public String evaluateSize(MdNode node) {
        if (this.checkNodeType(node, Type.FIELD)) {
            String val = this.evaluateMappingInfo(node, MappingInfo.SIZE);
            return val;
        }
        return null;
    }

    public String evaluateDataType(MdNode node) {
        if (this.checkNodeType(node, Type.FIELD)) {
            String val = this.evaluateMappingInfo(node, MappingInfo.TYPE);
            return val;
        }
        return null;
    }

    public EObject evaluateConnection(MdNode node) {
        MdNode res = null;
        if (this.checkNodeType(node, Type.DATASTORE, Type.STAGE)) {
            try {
                res = (MdNode)node.evaluateXpathExpressionMdNode("INTERNAL_MAPPING_CONNECTION_REF");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (res == null) {
                try {
                    res = (MdNode)node.evaluateMdNode(UpdateDatastoreCommand.XPATH_GET_CONNECTION_REF);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return res;
    }

    public String evaluateObjectDelimiterMask(MdNode node) {
        block3: {
            if (this.checkNodeType(node, Type.DATASTORE, Type.STAGE)) {
                try {
                    return node.evaluateXpathExpressionCached("INTERNAL_OBJECT_DELIMITER_MASK", null);
                }
                catch (XPathExpressionException e) {
                    if (!this.logger.isDebugEnabled()) break block3;
                    this.logger.error("Failed to evaluate xPathExpression {} on {}", (Object)"INTERNAL_OBJECT_DELIMITER_MASK", (Object)EcoreUtil.getURI((EObject)node), (Object)e);
                }
            }
        }
        return null;
    }

    public String evaluateObjectDelimiterRegexp(MdNode node) {
        block3: {
            if (this.checkNodeType(node, Type.DATASTORE, Type.STAGE)) {
                try {
                    return node.evaluateXpathExpressionCached("INTERNAL_OBJECT_DELIMITER_REGEXP", null);
                }
                catch (XPathExpressionException e) {
                    if (!this.logger.isDebugEnabled()) break block3;
                    this.logger.error("Failed to evaluate xPathExpression {} on {}", (Object)"INTERNAL_OBJECT_DELIMITER_REGEXP", (Object)EcoreUtil.getURI((EObject)node), (Object)e);
                }
            }
        }
        return null;
    }

    public String evaluateName(MdNode node) {
        if (this.checkNodeType(node, Type.FIELD)) {
            if (node.getName() != null) {
                return node.getName();
            }
            if (node.getLevel() != null) {
                return node.getLevel().getDisplayName();
            }
        }
        return null;
    }

    public boolean evaluateStageable(MdNode node) {
        block4: {
            if (this.checkNodeType(node, Type.FIELD)) {
                try {
                    Boolean b = node.evaluateXpathExpressionBooleanCached(new String[]{"HAS_NOT_STAGEABLE_CAPABILITY_GUI"});
                    if (b == Boolean.TRUE) {
                        return false;
                    }
                }
                catch (XPathExpressionException e) {
                    if (!this.logger.isDebugEnabled()) break block4;
                    this.logger.error("Failed to evaluate Stageable on {}", (Object)EcoreUtil.getURI((EObject)node), (Object)e);
                }
            }
        }
        return true;
    }

    public String evaluateProductCode(MdNode node) {
        if (this.checkNodeType(node, new Type[0])) {
            try {
                return node.evaluateXpathExpressionCached("INTERN_PRODUCT_CODE_GUI", null);
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean hasFilterCapability(MdNode node) {
        if (this.checkNodeType(node, Type.DATASTORE, Type.STAGE)) {
            try {
                return node.evaluateXpathExpressionBooleanCached(new String[]{"HAS_FILTER_CAPABILITY_GUI"});
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean hasWarningOnFilter(MdNode node) {
        if (this.checkNodeType(node, Type.DATASTORE, Type.STAGE)) {
            try {
                return node.evaluateXpathExpressionBooleanCached(new String[]{"ADD_WARNING_ON_FILTER_GUI"});
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean hasJoinCapability(MdNode node) {
        if (this.checkNodeType(node, Type.DATASTORE, Type.STAGE)) {
            try {
                return node.evaluateXpathExpressionBooleanCached(new String[]{"HAS_JOIN_CAPABILITY_GUI"});
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean hasWorkspaceCapability(MdNode node) {
        if (this.checkNodeType(node, Type.DATASTORE, Type.STAGE)) {
            try {
                return node.evaluateXpathExpressionBooleanCached(new String[]{"HAS_WORKSPACE_CAPABILITY_GUI"});
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
        }
        return false;
    }

    public String evaluateTechCode(MdNode node) {
        if (this.checkNodeType(node, Type.DATASTORE, Type.STAGE)) {
            try {
                return node.evaluateXpathExpressionCached("TECH_CODE", null);
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean hasTransformCapability(MdNode node) {
        if (this.checkNodeType(node, Type.DATASTORE, Type.STAGE)) {
            try {
                return node.evaluateXpathExpressionBooleanCached(new String[]{"HAS_TRANSFORM_CAPABILITY_GUI"});
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean hasWarningOnTransform(MdNode node) {
        if (this.checkNodeType(node, Type.DATASTORE, Type.STAGE)) {
            try {
                return node.evaluateXpathExpressionBooleanCached(new String[]{"ADD_WARNING_ON_TRANSFORM_GUI"});
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean supportContainerTargetMapping(MdNode node) {
        if (this.checkNodeType(node, Type.DATASTORE, Type.STAGE)) {
            return node.getMappingType().contains(MappingType.TARGET) || node.getMappingType().contains(MappingType.MAPPING);
        }
        return false;
    }

    public boolean supportContainerSourceMapping(MdNode node) {
        if (this.checkNodeType(node, Type.DATASTORE, Type.STAGE)) {
            return node.getMappingType().contains(MappingType.SOURCE) || node.getMappingType().contains(MappingType.MAPPING);
        }
        return false;
    }

    public boolean supportFieldTargetMapping(MdNode node) {
        if (this.checkNodeType(node, Type.FIELD)) {
            return node.getMappingType().contains(MappingType.TARGET_MAPPING) || node.getMappingType().contains(MappingType.MAPPING);
        }
        return false;
    }

    public String evaluateStageFieldType(MdNode node) {
        if (this.checkNodeType(node, new Type[0])) {
            try {
                return node.evaluateXpathExpressionCached("INTERNAL_STAGE_FIELD_TYPE", null);
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean evaluateIsStageFieldTypeValid(MdNode node) {
        if (this.checkNodeType(node, new Type[0])) {
            try {
                Boolean b = node.evaluateXpathExpressionBooleanCached(new String[]{"INTERNAL_STAGE_FIELD_VALID_TYPE"});
                return Boolean.TRUE.equals(b);
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
        }
        return false;
    }

    public MdNode toSubMdParent(MdNode md) {
        while (md.isSubMetaDataChildFile() && md.getRef() instanceof MdNode) {
            md = (MdNode)md.getRef();
        }
        return md;
    }

    public String evaluateFieldSeparator(MdNode node) {
        if (this.checkNodeType(node, Type.DATASTORE, Type.STAGE)) {
            try {
                return node.evaluateXpathExpressionCached("FIELD_SEPARATOR_GUI", ".");
            }
            catch (XPathExpressionException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.error("Failed to evaluate xPathExpression {} on {}", (Object)"FIELD_SEPARATOR_GUI", (Object)EcoreUtil.getURI((EObject)node), (Object)e);
                }
                return ".";
            }
        }
        return null;
    }

    public Collection<String> evaluateCriteriaCompatibleTechList(MdNode node) {
        if (this.checkNodeType(node, Type.DATASTORE, Type.STAGE)) {
            try {
                return (Collection)node.evaluateXpathExpressionCached("INTERNAL_CRITERIA_COMPATIBLE_TECH_LIST");
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
        }
        return null;
    }

    public String evaluateContainerFullPath(MdNode node) {
        if (this.checkNodeType(node, Type.DATASTORE, Type.STAGE)) {
            return node.getFullPath(true);
        }
        return null;
    }

    public boolean hasFilterOrWorkspaceCapability(MdNode node) {
        if (this.checkNodeType(node, Type.DATASTORE, Type.STAGE)) {
            try {
                return node.evaluateXpathExpressionBooleanCached(new String[]{"HAS_FILTER_CAPABILITY_GUI", "HAS_WORKSPACE_CAPABILITY_GUI"});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean hasJoinOrWorkspaceCapability(MdNode node) {
        if (this.checkNodeType(node, Type.DATASTORE, Type.STAGE)) {
            try {
                return node.evaluateXpathExpressionBooleanCached(new String[]{"HAS_JOIN_CAPABILITY_GUI", "HAS_WORKSPACE_CAPABILITY_GUI"});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean hasTransformOrWorkspaceCapability(MdNode node) {
        if (this.checkNodeType(node, Type.DATASTORE, Type.STAGE)) {
            try {
                return node.evaluateXpathExpressionBooleanCached(new String[]{"HAS_TRANSFORM_CAPABILITY_GUI", "HAS_WORKSPACE_CAPABILITY_GUI"});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean supportFieldSourceMapping(MdNode node) {
        if (this.checkNodeType(node, Type.FIELD)) {
            return node.getMappingType().contains(MappingType.SOURCE_MAPPING) || node.getMappingType().contains(MappingType.MAPPING);
        }
        return false;
    }

    public String evaluateObjectMask(MdNode node) {
        if (this.checkNodeType(node, Type.FIELD)) {
            try {
                return node.evaluateXpathExpressionCached("INTERNAL_OBJECT_MASK", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String getLevel(MdNode node) {
        Level l;
        if (this.checkNodeType(node, new Type[0]) && (l = node.getLevel()) != null) {
            return l.getCode();
        }
        return null;
    }

    public boolean evaluateDisjointedDataSetError(MdNode node) {
        if (this.checkNodeType(node, Type.DATASTORE, Type.STAGE)) {
            try {
                return node.evaluateXpathExpressionBooleanCached(new String[]{"IS_DISJOINTED_SRC_DATASET_ERROR"});
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean evaluateDisjointedDataSetWarning(MdNode node) {
        if (this.checkNodeType(node, Type.DATASTORE, Type.STAGE)) {
            try {
                return node.evaluateXpathExpressionBooleanCached(new String[]{"IS_DISJOINTED_SRC_DATASET_WARNING"});
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean evaluateErrorWhenDisjointedDataSetHaveCommonMappedAncestor(MdNode node) {
        if (this.checkNodeType(node, Type.DATASTORE, Type.STAGE)) {
            try {
                return node.evaluateXpathExpressionBooleanCached(new String[]{"INTERNAL_SHOW_ERROR_WHEN_DISJOINTED_SRC_HAVE_COMMON_MAPPED_ANCESTOR"});
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean evaluateErrorOnLoadSetWhenNoDirectPath(MdNode node) {
        if (this.checkNodeType(node, Type.DATASTORE, Type.STAGE)) {
            try {
                return node.evaluateXpathExpressionBooleanCached(new String[]{"INTERNAL_ERROR_LOADSET_NO_DIRECT_PATH"});
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
        }
        return false;
    }

    public String evaluateStageFieldContainerLevel(MdNode node) {
        if (this.checkNodeType(node, Type.STAGE)) {
            try {
                return node.evaluateXpathExpressionCached("BUILD_STAGE_FIELD_CONTAINER_LEVEL", null);
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
        }
        return null;
    }

    public String evaluateStageFieldLevel(MdNode node) {
        if (this.checkNodeType(node, Type.STAGE)) {
            try {
                return node.evaluateXpathExpressionCached("BUILD_STAGE_FIELD_LEVEL", null);
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean supportExtraStaticFieldUsageOnWrk(MdNode node) {
        if (this.checkNodeType(node, Type.DATASTORE)) {
            try {
                return node.evaluateXpathExpressionBooleanCached(new String[]{"INTERNAL_SUPPORT_EXTRA_FIELD_USAGE_ON_WORK"});
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
        }
        return false;
    }

    public Map<IMetaDataInformationsProvider.ICriteria, String> evaluateDynamicCriterias(MdNode node) {
        if (this.checkNodeType(node, Type.DATASTORE, Type.STAGE)) {
            Object val;
            HashMap<IMetaDataInformationsProvider.ICriteria, String> res = new HashMap<IMetaDataInformationsProvider.ICriteria, String>();
            List expressions = node.getLevel().getXPathExpression().stream().filter(x -> x.getCode().stream().anyMatch(c -> c.toString().startsWith("INTERNAL_CRITERIA_"))).collect(Collectors.toList());
            List listExpressions = expressions.stream().filter(x -> x.getCode().stream().anyMatch(c -> c.toString().endsWith("_LIST"))).collect(Collectors.toList());
            expressions.removeAll(listExpressions);
            MultiStatus ms = new MultiStatus(this.getClass(), 0, "");
            for (XpathExpression e : expressions) {
                try {
                    val = (String)node.evaluate(e.getExpression(), XPathConstants.STRING);
                    if (val == null) continue;
                    res.put(this.createCriteria(((QName)e.getCode().get(0)).toString()), (String)val);
                }
                catch (Exception e1) {
                    ms.add((IStatus)new Status(4, this.getClass(), String.format(Messages.MdEvaluator_DynamicCriteriaEvaluation, e.getCode().get(0)), (Throwable)e1));
                }
            }
            for (XpathExpression e : listExpressions) {
                try {
                    val = (Collection)node.evaluate(e.getExpression(), XPathConstants.NODESET);
                    if (val == null) continue;
                    res.put(this.createCriteria(((QName)e.getCode().get(0)).toString()), val.stream().map(s -> this.toString(s)).collect(Collectors.joining("|")));
                }
                catch (Exception e1) {
                    ms.add((IStatus)new Status(4, this.getClass(), String.format(Messages.MdEvaluator_DynamicCriteriaEvaluation, e.getCode().get(0)), (Throwable)e1));
                }
            }
            if (!ms.isOK()) {
                Platform.getLog((Bundle)Platform.getBundle((String)"com.indy.gmf.map")).log((IStatus)ms);
            }
            return res;
        }
        return Collections.EMPTY_MAP;
    }

    private String toString(Object object) throws RuntimeException {
        String res = null;
        if (object instanceof String) {
            res = (String)object;
        } else if (object instanceof Attribute) {
            res = ((Attribute)object).getValue();
            if (res == null) {
                res = ((Attribute)object).getValues().stream().collect(Collectors.joining(";"));
            }
        } else if (object instanceof org.jdom.Attribute) {
            res = ((org.jdom.Attribute)object).getValue();
        } else {
            throw new RuntimeException(String.format(Messages.MdEvaluator_AttributeConversionToString, object.getClass()));
        }
        return res;
    }

    private IMetaDataInformationsProvider.ICriteria createCriteria(String xPathExpressionName) {
        String name = xPathExpressionName.substring("INTERNAL_CRITERIA_".length());
        String[] parts = name.split("_");
        StringBuilder b = new StringBuilder();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if (p.length() > 0) {
                b.append(p.substring(0, 1).toUpperCase());
                if (p.length() > 1) {
                    b.append(p.substring(1).toLowerCase());
                }
            }
            ++n2;
        }
        return new Criteria(b.toString());
    }

    static class Criteria
    implements IMetaDataInformationsProvider.ICriteria {
        String label;

        Criteria(String label) {
            this.label = label;
        }

        @Override
        public String label(String prefix) {
            return prefix + this.label;
        }
    }

    static enum Type {
        FIELD(FIELD),
        DATASTORE(DATASTORE),
        STAGE(STAGE),
        CONSTRAINT(CONSTRAINT),
        VARIABLE(VARIABLE);

        Set<MappingType> validTypes;

        private Type(Set<MappingType> validTypes) {
            this.validTypes = validTypes;
        }

        boolean isValid(MdNode node) {
            return !Collections.disjoint(node.getMappingType(), this.validTypes);
        }
    }
}

