/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.compute.validator;

import com.indy.map.DataSet;
import com.indy.map.IContainer;
import com.indy.map.IReferencable;
import com.indy.map.Join;
import com.indy.map.Map;
import com.indy.map.compute.graph.GraphBuilderFactory;
import com.indy.map.compute.validator.AbstractGraphValidator;
import com.indy.map.compute.validator.ILinkValidator;
import com.indy.map.messages.Messages;
import com.indy.map.ref.RContainer;
import com.indy.map.ref.RLogicalField;
import com.indy.map.ref.RUsage;
import com.indy.map.util.InheritanceHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;

public class DataSetInheritanceValidator
extends AbstractGraphValidator
implements ILinkValidator {
    public static DataSetInheritanceValidator INSTANCE = new DataSetInheritanceValidator();

    private DataSetInheritanceValidator() {
    }

    public ILinkValidator.ValidationStatus canCreateLink(EObject source, EObject target, boolean altIsPressed) {
        Assert.isTrue((boolean)(source instanceof DataSet));
        Assert.isTrue((boolean)(target instanceof DataSet));
        try {
            if (source == target) {
                return ILinkValidator.ValidationStatus.createErrorStatus(Messages.DataSetInheritanceValidator_0);
            }
            if (this.isLoop((DataSet)source, (DataSet)target)) {
                return ILinkValidator.ValidationStatus.createErrorStatus(Messages.DataSetInheritanceValidator_1);
            }
            if (!altIsPressed && !this.hasInheritanceJoin((DataSet)source, (DataSet)target)) {
                return ILinkValidator.ValidationStatus.createErrorStatus(Messages.DataSetInheritanceValidator_2);
            }
            if (this.hasJoinLoop((DataSet)source, (DataSet)target)) {
                return ILinkValidator.ValidationStatus.createErrorStatus(Messages.DataSetInheritanceValidator_3);
            }
            if (!Collections.disjoint(((DataSet)source).getFilteredBy(), InheritanceHelper.getDataSetHierarchy((DataSet)target)) || !Collections.disjoint(((DataSet)target).getFilteredBy(), InheritanceHelper.getDataSetHierarchy((DataSet)source))) {
                return ILinkValidator.ValidationStatus.createErrorStatus(Messages.DataSetInheritanceValidator_4);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ILinkValidator.ValidationStatus.createErrorStatus(ex.getMessage());
        }
        return ILinkValidator.ValidationStatus.createOkStatus();
    }

    private List<Join> getJoins(DataSet dataset) {
        ArrayList<Join> datasetJoin = new ArrayList<Join>();
        for (IContainer c : dataset.getContainer()) {
            for (RLogicalField f : ((RContainer)((IReferencable)((Object)c)).getMapReference()).getFieldRef()) {
                for (RUsage u : f.getUsage()) {
                    if (!(u.getDataModel() instanceof Join)) continue;
                    datasetJoin.add((Join)u.getDataModel());
                }
            }
        }
        return datasetJoin;
    }

    private boolean hasInheritanceJoin(DataSet source, DataSet target) {
        List<Join> trgJoin = this.getJoins(target);
        for (Join j : this.getJoins(source)) {
            if (!trgJoin.contains(j)) continue;
            return true;
        }
        return false;
    }

    public boolean isLoop(DataSet source, DataSet target) throws Exception {
        Map mapModel = (Map)source.eContainer();
        return this.hasPath(source, target, mapModel, GraphBuilderFactory.GraphType.DATASET);
    }

    private boolean hasJoinLoop(DataSet source, DataSet target) throws Exception {
        Map mapModel = (Map)source.eContainer();
        return this.hasPath(source, target, mapModel, GraphBuilderFactory.GraphType.DATASET_JOIN);
    }

    public ILinkValidator.ValidationStatus canMerge(DataSet dataSet1, DataSet dataSet2) {
        return ILinkValidator.ValidationStatus.createOkStatus();
    }
}

