/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.custom.commands;

import com.indy.map.Datastore;
import com.indy.map.Field;
import com.indy.map.MapFactory;
import com.indy.map.custom.commands.FieldUpdaterUtils;
import com.indy.map.custom.commands.UpdateDatastoreCommand;
import com.stambia.md.Configuration;
import com.stambia.md.MdNode;
import com.stambia.tech.Level;
import com.stambia.tech.MappingType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class MdNodeSynchronizer {
    private Datastore datastore;
    HashMap<MdNode, Field> initialFields4Node = new HashMap();
    List<Field> initialProxyFields = new ArrayList<Field>();
    List<MdNode> mdNodes = new ArrayList<MdNode>();
    List<Field> _resTodelete = new ArrayList<Field>();
    List<Field> _resAllField = new ArrayList<Field>();
    HashMap<Field, BigInteger> fieldPositions = new HashMap();
    private static Collection<MappingType> fieldMappingTYpe = Arrays.asList(MappingType.MAPPING, MappingType.SOURCE_MAPPING, MappingType.TARGET_MAPPING);

    public MdNodeSynchronizer(Datastore datastore) {
        this.datastore = datastore;
    }

    private void orderNodes(MdNode currentNode, List<MdNode> orderedFieldsNodes, List<MdNode> allFieldsNodes) {
        if (!Collections.disjoint(fieldMappingTYpe, currentNode.getMappingType())) {
            orderedFieldsNodes.add(currentNode);
        }
        ArrayList<MdNode> currentChildren = new ArrayList<MdNode>();
        for (MdNode n : allFieldsNodes) {
            if (n.eContainer() != currentNode) continue;
            currentChildren.add(n);
        }
        Collections.sort(currentChildren, Configuration.comparator);
        for (MdNode n : currentChildren) {
            this.orderNodes(n, orderedFieldsNodes, allFieldsNodes);
        }
    }

    public List<Field> getFieldToDelete() {
        return this._resTodelete;
    }

    public List<Field> getAllDatastoreFields() {
        return this._resAllField;
    }

    public void synchronize() {
        ArrayList<Field> deleteCandidates = new ArrayList<Field>(this.initialProxyFields);
        HashSet<Object> invisbleMdNodes = new HashSet<Object>();
        for (Field f : this.datastore.getField()) {
            if (f.getRef() instanceof MdNode && !((MdNode)f.getRef()).eIsProxy()) {
                this.initialFields4Node.put((MdNode)f.getRef(), f);
                Object n = (MdNode)f.getRef();
                if (n != null && EcoreUtil.isAncestor(Collections.singleton(this.datastore.getRef()), (EObject)n)) {
                    if (Collections.disjoint(fieldMappingTYpe, n.getMappingType())) {
                        deleteCandidates.add(f);
                        invisbleMdNodes.add(n);
                    }
                    do {
                        if (!Collections.disjoint(fieldMappingTYpe, n.getMappingType())) {
                            if (this.mdNodes.contains(n)) continue;
                            this.mdNodes.add((MdNode)n);
                            continue;
                        }
                        invisbleMdNodes.add(n);
                    } while ((n = n.eContainer() instanceof MdNode ? (MdNode)n.eContainer() : null) != null);
                    continue;
                }
                this.initialProxyFields.add(f);
                continue;
            }
            this.initialProxyFields.add(f);
        }
        ArrayList<Object> newFields = new ArrayList<Object>();
        for (MdNode n : this.mdNodes) {
            if (this.initialFields4Node.get(n) != null) continue;
            Object f = MapFactory.eINSTANCE.createField();
            f.setRef((EObject)n);
            String newName = null;
            try {
                newName = n.evaluateXpathExpressionCached("INTERNAL_MAPPING_OBJECT_NAME", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (newName == null && (newName = n.getName()) == null) {
                newName = n.getLevel().getDisplayName();
            }
            if (n.getName() != null) {
                f.setName(newName);
            } else {
                f.setName(newName);
            }
            newFields.add(f);
        }
        ArrayList<Field> resolvedFields = new ArrayList<Field>();
        for (Field field : this.initialProxyFields) {
            Object n = this.findMatchingNode(field);
            if (n != null) {
                field.setRef((EObject)n);
                resolvedFields.add(field);
                do {
                    if (!Collections.disjoint(fieldMappingTYpe, n.getMappingType())) {
                        if (this.mdNodes.contains(n)) continue;
                        this.mdNodes.add((MdNode)n);
                        continue;
                    }
                    invisbleMdNodes.add(n);
                } while ((n = n.eContainer() instanceof MdNode ? (MdNode)n.eContainer() : null) != null);
                continue;
            }
            deleteCandidates.add(field);
        }
        deleteCandidates.removeAll(resolvedFields);
        HashMap<MdNode, Field> allFieldsMap = new HashMap<MdNode, Field>(this.initialFields4Node);
        for (Object f : resolvedFields) {
            allFieldsMap.put((MdNode)f.getRef(), (Field)f);
        }
        for (Object f : newFields) {
            allFieldsMap.put((MdNode)f.getRef(), (Field)f);
        }
        for (Object f : allFieldsMap.values()) {
            Object parent;
            if (deleteCandidates.contains(f) || (parent = this.findParent((Field)f, allFieldsMap)) == f.getParent()) continue;
            if (f.getParent() != null) {
                f.getParent().getChildren().remove(f);
            }
            f.setParent((Field)parent);
        }
        ArrayList<MdNode> allMdNodes = new ArrayList<MdNode>();
        for (Field f : this.datastore.getField()) {
            if (deleteCandidates.contains(f)) continue;
            allMdNodes.add((MdNode)f.getRef());
        }
        ArrayList<MdNode> orderedMdNodes = new ArrayList<MdNode>();
        allMdNodes.addAll(invisbleMdNodes);
        this.orderNodes((MdNode)this.datastore.getRef(), orderedMdNodes, allMdNodes);
        FieldUpdaterUtils.Position p = new FieldUpdaterUtils.Position();
        for (MdNode n : orderedMdNodes) {
            p.increment();
            Field f = allFieldsMap.get(n);
            if (f == null) continue;
            this.fieldPositions.put(f, BigInteger.valueOf(p.getValue()));
        }
        this._resTodelete = deleteCandidates;
        this._resAllField = new ArrayList<Field>((Collection<Field>)this.datastore.getField());
        this._resAllField.addAll(newFields);
        this._resAllField.removeAll(this._resTodelete);
    }

    private MdNode macth(MdNode node, Field f) {
        if (!Collections.disjoint(fieldMappingTYpe, node.getMappingType()) && this.checkNameEquality(node, f.getName()) && node.getLevel() != null && f.getRef() instanceof MdNode) {
            String defType = node.getLevel().getCode();
            Level l = ((MdNode)f.getRef()).getLevel();
            if (l == null || l.getCode().equals(defType)) {
                return node;
            }
        }
        return null;
    }

    private MdNode findMatchingNode(Field field) {
        EObject base = this.datastore.getRef();
        Stack<Field> hierarchy = new Stack<Field>();
        Field f = field;
        while (f != null) {
            hierarchy.push(f);
            f = f.getParent();
        }
        if (base instanceof MdNode) {
            MdNode node = (MdNode)base;
            while (node != null && !hierarchy.isEmpty()) {
                f = (Field)hierarchy.peek();
                MdNode current = this.macth(node, f);
                if (current != null) {
                    hierarchy.pop();
                    node = current;
                } else {
                    ArrayList<MdNode> l = new ArrayList<MdNode>();
                    UpdateDatastoreCommand.getMappingChildrenAndConstraints(true, node, l, null);
                    for (MdNode n : l) {
                        current = this.macth(n, f);
                        if (current == null) continue;
                        hierarchy.pop();
                        break;
                    }
                }
                node = current;
            }
            return node;
        }
        return null;
    }

    private boolean checkNameEquality(MdNode node, String name) {
        return node.getName() != null && name != null && node.getName().toUpperCase().equals(name.toUpperCase()) || node.getName() == null && node.getLevel() != null && node.getLevel().getDisplayName() != null && node.getLevel().getDisplayName().toUpperCase().equals(name.toUpperCase());
    }

    private Field findParent(Field child, HashMap<MdNode, Field> nodes2Fields) {
        MdNode n = (MdNode)child.getRef();
        MdNode matchingParentNode = null;
        while (matchingParentNode == null && n.eContainer() instanceof MdNode) {
            if (Collections.disjoint(fieldMappingTYpe, (n = (MdNode)n.eContainer()).getMappingType())) continue;
            matchingParentNode = n;
        }
        Field parent = null;
        if (matchingParentNode != null && (parent = nodes2Fields.get(matchingParentNode)) != null) {
            return parent;
        }
        for (Field f : nodes2Fields.values()) {
            if (f != child.getParent() && !FieldUpdaterUtils.compareName(child.getParent(), f) || (n.getName() == null || child.getName() == null || !n.getName().toUpperCase().equals(child.getName().toUpperCase()) && (child.getChildren().isEmpty() || child.getParent() != null)) && (n.getName() != null || n.getLevel() == null || n.getLevel().getDisplayName() == null || child.getName() == null || !n.getLevel().getDisplayName().toUpperCase().equals(child.getName().toUpperCase()))) continue;
            if (n.getLevel() != null && child.getRef() instanceof MdNode) {
                String defType = n.getLevel().getCode();
                Level l = ((MdNode)child.getRef()).getLevel();
                if (l != null && !l.getCode().equals(defType)) continue;
            }
            return parent;
        }
        return null;
    }

    public HashMap<Field, BigInteger> getFieldPositions() {
        return this.fieldPositions;
    }
}

