/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.custom.commands;

import com.indy.libraries.build.parser.sql.LightParser;
import com.indy.map.Clause;
import com.indy.map.ComputedField;
import com.indy.map.Expression;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.IReferencable;
import com.indy.map.MapModelItem;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RUsage;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class UpdateQueryFieldAliasCommand
extends RecordingCommand {
    private ILogicalField field;
    private QName oldAlias;

    public UpdateQueryFieldAliasCommand(TransactionalEditingDomain domain, ILogicalField field, QName oldAlias) {
        super(domain);
        this.field = field;
        this.oldAlias = oldAlias;
    }

    protected void doExecute() {
        if (this.oldAlias == null) {
            return;
        }
        String newAlias = this.field.getLabel();
        String oldAlias = this.oldAlias.toString();
        ArrayList<RUsage> usages = new ArrayList<RUsage>();
        usages.addAll((Collection<RUsage>)((RSourceItem)((IReferencable)((Object)this.field)).getMapReference()).getUsage());
        for (RUsage u : usages) {
            MapModelItem it = u.getDataModel();
            String expression = null;
            if (it instanceof Clause) {
                expression = ((Clause)it).getExpression();
            } else if (it instanceof Expression) {
                expression = ((Expression)it).getExpression();
            } else if (it instanceof ComputedField) {
                expression = ((ComputedField)it).getFormula();
            }
            LightParser lp = new LightParser(expression);
            lp.parse();
            Object ret = "";
            for (Object o : lp.iterate()) {
                ret = o instanceof String ? (String)ret + o.toString() : (((LightParser.Field)o).getTableName().equals(((IContainer)this.field.eContainer()).getAlias().toString()) && ((LightParser.Field)o).getFieldName().equals(oldAlias) || ((IContainer)this.field.eContainer()).getComputedAlias() != null && ((LightParser.Field)o).getTableName().equals(((IContainer)this.field.eContainer()).getComputedAlias().toString()) && ((LightParser.Field)o).getFieldName().equals(oldAlias) ? (String)ret + ((LightParser.Field)o).getTableName() + "." + newAlias : (String)ret + ((LightParser.Field)o).toString());
            }
            if (((String)ret).equals(expression)) continue;
            if (it instanceof Clause) {
                ((Clause)it).setExpression((String)ret);
                continue;
            }
            if (it instanceof Expression) {
                ((Expression)it).setExpression((String)ret);
                continue;
            }
            if (!(it instanceof ComputedField)) continue;
            ((ComputedField)it).setFormula((String)ret);
        }
    }
}

