/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.helpers;

import com.indy.map.AdditionalProperty;
import com.indy.map.MapModelItem;
import com.indy.map.helpers.IMapModelPropertyHandler;
import com.indy.map.helpers.internal.DiagramPropertyHandler;
import com.indy.map.helpers.internal.SemanticPropertyHandler;
import com.indy.map.helpers.internal.SemanticV1UpgradePropertyHandler;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class AdditionalPropertyHelperHandler {
    public static final String CATEGORY_DIAGRAM = "com.indy.map.helpers.diagram";
    public static final String CATEGORY_SEMANTIC = "com.indy.map.helpers.semantic";
    public static final String CATEGORY_SEMANTIC_FROM_V1 = "com.indy.map.helpers.semantic.v1";
    public static AdditionalPropertyHelperHandler INSTANCE = new AdditionalPropertyHelperHandler();
    private DiagramPropertyHandler diagramHandler = new DiagramPropertyHandler();
    private SemanticPropertyHandler semanticHandler = new SemanticPropertyHandler();
    private SemanticV1UpgradePropertyHandler semanticV1Handler = new SemanticV1UpgradePropertyHandler();

    private AdditionalPropertyHelperHandler() {
    }

    public void handleProperties(List<MapModelItem> modelItems, String propertiesCategories) throws Exception {
        CompoundCommand cc = new CompoundCommand();
        TransactionalEditingDomain domain = null;
        for (MapModelItem it : modelItems) {
            for (AdditionalProperty property : it.getAnnotation()) {
                Command cmd;
                if (!property.getCategory().equals(propertiesCategories)) continue;
                IMapModelPropertyHandler handler = null;
                if (CATEGORY_DIAGRAM.equals(property.getCategory())) {
                    handler = this.getDiagramHandler(property);
                } else if (CATEGORY_SEMANTIC.equals(property.getCategory())) {
                    handler = this.getSemanticHandler(property);
                } else if (CATEGORY_SEMANTIC_FROM_V1.equals(property.getCategory())) {
                    handler = this.getSemanticV1UpgradeHandler(property);
                }
                if (handler == null) continue;
                if (domain == null) {
                    domain = TransactionUtil.getEditingDomain((EObject)it);
                }
                if ((cmd = handler.getCommand(property)) != null) {
                    cc.append(cmd);
                }
                if ((cmd = handler.getCleaningCommand(property)) == null) continue;
                cc.append(cmd);
            }
        }
        if (!cc.isEmpty()) {
            domain.getCommandStack().execute((Command)cc);
        }
    }

    private IMapModelPropertyHandler getSemanticHandler(AdditionalProperty property) {
        return this.semanticHandler;
    }

    private IMapModelPropertyHandler getDiagramHandler(AdditionalProperty property) {
        return this.diagramHandler;
    }

    private IMapModelPropertyHandler getSemanticV1UpgradeHandler(AdditionalProperty property) {
        return this.semanticV1Handler;
    }
}

