/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.helpers.internal;

import com.indy.map.AdditionalProperty;
import com.indy.map.IContainer;
import com.indy.map.Map;
import com.indy.map.MapModelItem;
import com.indy.map.MapPackage;
import com.indy.map.helpers.IMapModelPropertyHandler;
import com.indy.map.helpers.internal.AbstractPropertyHandler;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class SemanticV1UpgradePropertyHandler
extends AbstractPropertyHandler
implements IMapModelPropertyHandler {
    public static final String SEMANTIC_NO_LOAD_CRITERIA = "template.load.disable";

    @Override
    public Command getCommand(AdditionalProperty prop) {
        if (SEMANTIC_NO_LOAD_CRITERIA.equals(prop.getName())) {
            return this.createNoLoadTemplateCommand(prop);
        }
        return null;
    }

    private Command createNoLoadTemplateCommand(AdditionalProperty prop) {
        TransactionalEditingDomain editDomain = this.getEditingDomain(prop);
        MapModelItem item = this.getMapModelItem(prop);
        Assert.isTrue((boolean)(item instanceof Map));
        Assert.isNotNull((Object)prop.getValue());
        String strVal = prop.getValue().trim();
        boolean propValue = Boolean.parseBoolean(strVal);
        Map source = (Map)item;
        CompoundCommand cc = new CompoundCommand();
        for (IContainer c : source.getContainer()) {
            if (c.getSetDescriptor().isEmpty()) continue;
            if (propValue) {
                cc.append((Command)new AddCommand((EditingDomain)editDomain, (EObject)c, (EStructuralFeature)MapPackage.eINSTANCE.getMapModelItem_Tag(), (Object)new QName("NO_LOAD")));
                continue;
            }
            for (QName q : c.getTag()) {
                if (!q.toString().equals("NO_LOAD")) continue;
                cc.append((Command)new RemoveCommand((EditingDomain)editDomain, (EObject)c, (EStructuralFeature)MapPackage.eINSTANCE.getMapModelItem_Tag(), (Object)q));
            }
        }
        if (!cc.isEmpty()) {
            return cc;
        }
        return null;
    }
}

