/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.ref.impl;

import com.indy.map.DataSet;
import com.indy.map.IContainer;
import com.indy.map.IReferencable;
import com.indy.map.Map;
import com.indy.map.ref.RAlim;
import com.indy.map.ref.RClause;
import com.indy.map.ref.RContainer;
import com.indy.map.ref.RDatastore;
import com.indy.map.ref.RExpression;
import com.indy.map.ref.RInstance;
import com.indy.map.ref.RItem;
import com.indy.map.ref.RLoadSet;
import com.indy.map.ref.RLogicalField;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RParameter;
import com.indy.map.ref.RProblem;
import com.indy.map.ref.RSourceSet;
import com.indy.map.ref.RTargetSet;
import com.indy.map.ref.RTemplate;
import com.indy.map.ref.RUDFRef;
import com.indy.map.ref.RVariable;
import com.indy.map.ref.RefPackage;
import com.indy.map.ref.impl.RItemImpl;
import com.indy.map.util.InheritanceHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class RMapImpl
extends RItemImpl
implements RMap {
    protected EList<RAlim> alim;
    protected EList<RInstance> instanceRef;
    protected EList<RContainer> containerRef;
    protected EList<RClause> clauseRef;
    protected EList<RVariable> variableRef;
    protected EList<RTargetSet> targetSetRef;
    protected EList<RSourceSet> sourceSetRef;
    protected EList<RTemplate> templateRef;
    protected EList<RLoadSet> loadSet;
    protected EList<RParameter> inputParameterRef;
    protected EList<RUDFRef> udfRef;
    private Set<RItem> problematicItems = Collections.synchronizedSet(new HashSet());
    public static final int NOTIFICATION_PROBLEM = -6666;

    protected RMapImpl() {
        EContentAdapter a = new EContentAdapter(){

            private void addProblem(RItem p) {
                if (!p.getProblem().isEmpty()) {
                    RMapImpl.this.problematicItems.add(p);
                }
            }

            private void removeProblem(RItem p) {
                RMapImpl.this.problematicItems.remove(p);
            }

            private List<RProblem> extractAllProblems(RItem item) {
                ArrayList<RProblem> l;
                block5: {
                    block4: {
                        l = new ArrayList<RProblem>();
                        l.addAll((Collection<RProblem>)item.getProblem());
                        if (!(item instanceof RLogicalField)) break block4;
                        for (RExpression expr : ((RLogicalField)item).getExpressionRef()) {
                            l.addAll(this.extractAllProblems(expr));
                        }
                        break block5;
                    }
                    if (!(item instanceof RContainer)) break block5;
                    for (RItem expr : ((RContainer)item).getFieldRef()) {
                        l.addAll(this.extractAllProblems(expr));
                    }
                    if (item instanceof RDatastore) {
                        for (RItem expr : ((RDatastore)item).getConstraintRef()) {
                            l.addAll(this.extractAllProblems(expr));
                        }
                    }
                }
                return l;
            }

            public void notifyChanged(Notification notification) {
                if (notification instanceof ProblemChangedNotification) {
                    RItem i = ((ProblemChangedNotification)notification).getRefItem();
                    if (i.getProblem().isEmpty()) {
                        this.removeProblem(i);
                    } else {
                        this.addProblem(i);
                    }
                } else if (notification.getFeature() instanceof EReference && ((EReference)notification.getFeature()).isContainment()) {
                    if (notification.getEventType() == 4 && notification.getOldValue() instanceof RItem) {
                        RMapImpl.this.problematicItems.removeAll(this.findAllProblems((RItem)notification.getOldValue()));
                    } else if (notification.getEventType() == 6) {
                        for (Object o : (Collection)notification.getOldValue()) {
                            if (!(o instanceof RItem)) continue;
                            RMapImpl.this.problematicItems.removeAll(this.findAllProblems((RItem)o));
                        }
                    }
                }
            }

            private Collection<?> findAllProblems(RItem oldValue) {
                ArrayList<RItem> l = new ArrayList<RItem>();
                l.add(oldValue);
                for (EObject o : oldValue.eContents()) {
                    if (!(o instanceof RItem)) continue;
                    l.add((RItem)o);
                }
                return l;
            }
        };
        this.eAdapters().add((Object)a);
    }

    @Override
    protected EClass eStaticClass() {
        return RefPackage.Literals.RMAP;
    }

    @Override
    public EList<RAlim> getAlim() {
        if (this.alim == null) {
            this.alim = new EObjectContainmentEList(RAlim.class, (InternalEObject)this, 3);
        }
        return this.alim;
    }

    @Override
    public EList<RInstance> getInstanceRef() {
        if (this.instanceRef == null) {
            this.instanceRef = new EObjectContainmentEList(RInstance.class, (InternalEObject)this, 4);
        }
        return this.instanceRef;
    }

    @Override
    public EList<RContainer> getContainerRef() {
        if (this.containerRef == null) {
            this.containerRef = new EObjectContainmentEList(RContainer.class, (InternalEObject)this, 5);
        }
        return this.containerRef;
    }

    @Override
    public EList<RClause> getClauseRef() {
        if (this.clauseRef == null) {
            this.clauseRef = new EObjectContainmentEList(RClause.class, (InternalEObject)this, 6);
        }
        return this.clauseRef;
    }

    @Override
    public EList<RVariable> getVariableRef() {
        if (this.variableRef == null) {
            this.variableRef = new EObjectContainmentEList(RVariable.class, (InternalEObject)this, 7);
        }
        return this.variableRef;
    }

    @Override
    public EList<RTargetSet> getTargetSetRef() {
        if (this.targetSetRef == null) {
            this.targetSetRef = new EObjectContainmentEList(RTargetSet.class, (InternalEObject)this, 8);
        }
        return this.targetSetRef;
    }

    @Override
    public EList<RSourceSet> getSourceSetRef() {
        if (this.sourceSetRef == null) {
            this.sourceSetRef = new EObjectContainmentEList(RSourceSet.class, (InternalEObject)this, 9);
        }
        return this.sourceSetRef;
    }

    @Override
    public EList<RTemplate> getTemplateRef() {
        if (this.templateRef == null) {
            this.templateRef = new EObjectContainmentEList(RTemplate.class, (InternalEObject)this, 10);
        }
        return this.templateRef;
    }

    @Override
    public EList<RLoadSet> getLoadSet() {
        if (this.loadSet == null) {
            this.loadSet = new EObjectContainmentEList(RLoadSet.class, (InternalEObject)this, 11);
        }
        return this.loadSet;
    }

    @Override
    public EList<RParameter> getInputParameterRef() {
        if (this.inputParameterRef == null) {
            this.inputParameterRef = new EObjectContainmentEList(RParameter.class, (InternalEObject)this, 12);
        }
        return this.inputParameterRef;
    }

    @Override
    public EList<RUDFRef> getUdfRef() {
        if (this.udfRef == null) {
            this.udfRef = new EObjectContainmentEList(RUDFRef.class, (InternalEObject)this, 13);
        }
        return this.udfRef;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return ((InternalEList)this.getAlim()).basicRemove((Object)otherEnd, msgs);
            }
            case 4: {
                return ((InternalEList)this.getInstanceRef()).basicRemove((Object)otherEnd, msgs);
            }
            case 5: {
                return ((InternalEList)this.getContainerRef()).basicRemove((Object)otherEnd, msgs);
            }
            case 6: {
                return ((InternalEList)this.getClauseRef()).basicRemove((Object)otherEnd, msgs);
            }
            case 7: {
                return ((InternalEList)this.getVariableRef()).basicRemove((Object)otherEnd, msgs);
            }
            case 8: {
                return ((InternalEList)this.getTargetSetRef()).basicRemove((Object)otherEnd, msgs);
            }
            case 9: {
                return ((InternalEList)this.getSourceSetRef()).basicRemove((Object)otherEnd, msgs);
            }
            case 10: {
                return ((InternalEList)this.getTemplateRef()).basicRemove((Object)otherEnd, msgs);
            }
            case 11: {
                return ((InternalEList)this.getLoadSet()).basicRemove((Object)otherEnd, msgs);
            }
            case 12: {
                return ((InternalEList)this.getInputParameterRef()).basicRemove((Object)otherEnd, msgs);
            }
            case 13: {
                return ((InternalEList)this.getUdfRef()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getAlim();
            }
            case 4: {
                return this.getInstanceRef();
            }
            case 5: {
                return this.getContainerRef();
            }
            case 6: {
                return this.getClauseRef();
            }
            case 7: {
                return this.getVariableRef();
            }
            case 8: {
                return this.getTargetSetRef();
            }
            case 9: {
                return this.getSourceSetRef();
            }
            case 10: {
                return this.getTemplateRef();
            }
            case 11: {
                return this.getLoadSet();
            }
            case 12: {
                return this.getInputParameterRef();
            }
            case 13: {
                return this.getUdfRef();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.getAlim().clear();
                this.getAlim().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getInstanceRef().clear();
                this.getInstanceRef().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getContainerRef().clear();
                this.getContainerRef().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.getClauseRef().clear();
                this.getClauseRef().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.getVariableRef().clear();
                this.getVariableRef().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.getTargetSetRef().clear();
                this.getTargetSetRef().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.getSourceSetRef().clear();
                this.getSourceSetRef().addAll((Collection)newValue);
                return;
            }
            case 10: {
                this.getTemplateRef().clear();
                this.getTemplateRef().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.getLoadSet().clear();
                this.getLoadSet().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.getInputParameterRef().clear();
                this.getInputParameterRef().addAll((Collection)newValue);
                return;
            }
            case 13: {
                this.getUdfRef().clear();
                this.getUdfRef().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.getAlim().clear();
                return;
            }
            case 4: {
                this.getInstanceRef().clear();
                return;
            }
            case 5: {
                this.getContainerRef().clear();
                return;
            }
            case 6: {
                this.getClauseRef().clear();
                return;
            }
            case 7: {
                this.getVariableRef().clear();
                return;
            }
            case 8: {
                this.getTargetSetRef().clear();
                return;
            }
            case 9: {
                this.getSourceSetRef().clear();
                return;
            }
            case 10: {
                this.getTemplateRef().clear();
                return;
            }
            case 11: {
                this.getLoadSet().clear();
                return;
            }
            case 12: {
                this.getInputParameterRef().clear();
                return;
            }
            case 13: {
                this.getUdfRef().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return this.alim != null && !this.alim.isEmpty();
            }
            case 4: {
                return this.instanceRef != null && !this.instanceRef.isEmpty();
            }
            case 5: {
                return this.containerRef != null && !this.containerRef.isEmpty();
            }
            case 6: {
                return this.clauseRef != null && !this.clauseRef.isEmpty();
            }
            case 7: {
                return this.variableRef != null && !this.variableRef.isEmpty();
            }
            case 8: {
                return this.targetSetRef != null && !this.targetSetRef.isEmpty();
            }
            case 9: {
                return this.sourceSetRef != null && !this.sourceSetRef.isEmpty();
            }
            case 10: {
                return this.templateRef != null && !this.templateRef.isEmpty();
            }
            case 11: {
                return this.loadSet != null && !this.loadSet.isEmpty();
            }
            case 12: {
                return this.inputParameterRef != null && !this.inputParameterRef.isEmpty();
            }
            case 13: {
                return this.udfRef != null && !this.udfRef.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public RTargetSet getTargetSetRef(IContainer container) {
        for (RTargetSet ts : this.getTargetSetRef()) {
            if (!ts.getContainer().contains(((IReferencable)((Object)container)).getMapReference())) continue;
            return ts;
        }
        return null;
    }

    @Override
    public List<RSourceSet> getSourceSetRef(DataSet d) {
        ArrayList<RSourceSet> l = new ArrayList<RSourceSet>();
        for (RSourceSet rs : this.getSourceSetRef()) {
            if (!rs.getDataSet().contains((Object)d)) continue;
            l.add(rs);
        }
        return l;
    }

    @Override
    public RSourceSet getInputSourceSet(IContainer container) {
        List<IContainer> l = container.getSrcContainers();
        ArrayList<DataSet> incomingDataSets = new ArrayList<DataSet>();
        for (IContainer c : l) {
            if (incomingDataSets.contains(c.getDataset())) continue;
            incomingDataSets.add(c.getDataset());
            for (DataSet dataSet : InheritanceHelper.getDataSetHierarchy(c.getDataset())) {
                if (incomingDataSets.contains(dataSet)) continue;
                incomingDataSets.add(dataSet);
            }
        }
        ArrayList<RSourceSet> candidates = new ArrayList<RSourceSet>();
        for (RSourceSet rs : this.getSourceSetRef()) {
            boolean candidate = false;
            for (IContainer c : l) {
                if (!rs.getDataSet().contains((Object)c.getDataset())) continue;
                candidate = true;
                break;
            }
            if (!candidate) continue;
            candidates.add(rs);
        }
        Iterator it = candidates.iterator();
        while (it.hasNext()) {
            RSourceSet rSourceSet = (RSourceSet)it.next();
            ArrayList<DataSet> t = new ArrayList<DataSet>((Collection<DataSet>)rSourceSet.getDataSet());
            if (!t.retainAll(incomingDataSets)) continue;
            it.remove();
        }
        if (candidates.isEmpty()) {
            return null;
        }
        candidates.size();
        return (RSourceSet)candidates.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RItem> getProblematicItems() {
        Set<RItem> set = this.problematicItems;
        synchronized (set) {
            return new ArrayList<RItem>(this.problematicItems);
        }
    }

    @Override
    public boolean hasErrors() {
        return ((Map)this.getDataModel()).getErrorCounter() > 0;
    }

    @Override
    public RLoadSet getLoadSet(IContainer container) {
        for (RLoadSet l : this.getLoadSet()) {
            if (!l.getContainer().contains((Object)container)) continue;
            return l;
        }
        return null;
    }

    public static class ProblemChangedNotification
    extends ENotificationImpl {
        RItem refItem;

        public ProblemChangedNotification(InternalEObject notifier, RItem refItem) {
            super(notifier, -6666, null, (Object)refItem, null);
            this.refItem = refItem;
        }

        public RItem getRefItem() {
            return this.refItem;
        }
    }
}

