/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.util;

import com.indy.map.Clause;
import com.indy.map.Filter;
import com.indy.map.IContainer;
import com.indy.map.Join;
import com.indy.map.MapModelItem;
import com.indy.map.Template;
import com.indy.map.UDFRef;
import com.indy.map.Variable;
import com.indy.map.api.IMetaDataInformationsProvider;
import com.indy.map.ref.RClause;
import com.indy.map.ref.RProblem;
import com.indy.map.ref.RSourceItem;
import com.indy.map.util.TemplateCapabilityHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;

public class ClauseHelper {
    private ClauseHelper() {
    }

    public static List<ProblemWrapper> supportQualify(Filter filter) {
        ArrayList<ProblemWrapper> result = new ArrayList<ProblemWrapper>();
        for (Template template : filter.getAPI().getTemplates(filter)) {
            if (!TemplateCapabilityHelper.supportCapability(template, "template-feature-support", "qualifyFilter", false)) continue;
            result.add(new ProblemWrapper(RProblem.ERROR_FILTER_QUALIFY_CAPABLITY, template));
        }
        return result;
    }

    public static boolean hasRefOnSameConnection(Clause clause) {
        HashSet<String> connectionIds = new HashSet<String>();
        if (clause == null || clause.getMapReference() == null) {
            return true;
        }
        EList<RSourceItem> refs = ((RClause)clause.getMapReference()).getSourceRef();
        for (RSourceItem srcIt : refs) {
            MapModelItem srcModel = srcIt.getDataModel();
            if (srcModel instanceof Variable || srcModel instanceof UDFRef) continue;
            String idConnection = srcModel.getAPI().getMdEvaluator().evaluateConnectionId((IContainer)srcModel.eContainer(), IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
            if (idConnection != null && !connectionIds.contains(idConnection)) {
                connectionIds.add(idConnection);
                if (connectionIds.size() <= 1) continue;
                return false;
            }
            if (idConnection != null) continue;
            return false;
        }
        if (clause instanceof Join && ((Join)clause).getLeft() != null && ((Join)clause).getRight() != null) {
            String idConnection = clause.getAPI().getMdEvaluator().evaluateConnectionId(((Join)clause).getLeft(), IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
            String id2Connection = clause.getAPI().getMdEvaluator().evaluateConnectionId(((Join)clause).getRight(), IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
            return idConnection.equals(id2Connection);
        }
        return true;
    }

    public static class ProblemWrapper {
        private QName problem;
        private Template template;

        public ProblemWrapper(QName problem, Template template) {
            this.problem = problem;
            this.template = template;
        }

        public QName getProblem() {
            return this.problem;
        }

        public Template getTemplate() {
            return this.template;
        }
    }
}

