/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.util.synchro.updaters.impl;

import com.indy.map.AdditionalProperty;
import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.Map;
import com.indy.map.MapModelItem;
import com.indy.map.MapPackage;
import com.indy.map.messages.Messages;
import com.indy.map.ref.RExpression;
import com.indy.map.ref.RField;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RUsage;
import com.indy.map.ref.RefPackage;
import com.indy.map.util.synchro.updaters.impl.UsageUpdater;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.example.map.custom.command.UpdateFieldRefCommand;
import org.osgi.service.log.LogService;

public class ExpressionUpdater
extends UsageUpdater {
    @Override
    public void updateAll(RUsage refItem) throws Exception {
        this.update(refItem, (EStructuralFeature)MapPackage.eINSTANCE.getExpression_Expression());
    }

    @Override
    public void update(RUsage refItem, EStructuralFeature feature) throws Exception {
        String expr = ((Expression)refItem.getDataModel()).getExpression();
        String iexpr = ((RExpression)refItem).getInternalExpression();
        if ((expr == null || expr.isEmpty()) && (iexpr == null || iexpr.isEmpty())) {
            return;
        }
        if (MapPackage.eINSTANCE.getExpression_Expression().equals(feature)) {
            this.updateInternalMapping((Expression)refItem.getDataModel(), UpdateFieldRefCommand.parseExpression(((Expression)refItem.getDataModel()).getExpression()), ((Expression)refItem.getDataModel()).getExpression(), null);
        }
    }

    @Override
    public Command updateAndDomainCommand(RUsage refItem, EStructuralFeature feature) {
        try {
            this.update(refItem, feature);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.gmf.map").error(Messages.ExpressionUpdater_2, (Object)ex);
        }
        if (feature == MapPackage.eINSTANCE.getExpression_Expression()) {
            MapModelItem it = refItem.getDataModel();
            ILogicalField field = (ILogicalField)it.eContainer();
            if (!(field instanceof Field)) {
                return null;
            }
            boolean hasExpression = false;
            for (Expression e : field.getExpression()) {
                if (e.getExpression() == null || e.getExpression().trim().isEmpty()) continue;
                hasExpression = true;
                break;
            }
            boolean defaultValue = this.defaultValue(field);
            CompoundCommand cc = new CompoundCommand();
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)field);
            if (!field.eIsSet((EStructuralFeature)MapPackage.eINSTANCE.getField_Enable()) && hasExpression) {
                cc.append((Command)new SetCommand((EditingDomain)domain, (EObject)field, (EStructuralFeature)MapPackage.eINSTANCE.getField_Enable(), (Object)true));
            }
            cc.append((Command)new UpdateFieldFilterCommand(domain, (Field)field));
            if (field.eIsSet((EStructuralFeature)MapPackage.eINSTANCE.getField_Update())) {
                if (!hasExpression) {
                    cc.append((Command)new SetCommand((EditingDomain)domain, (EObject)field, (EStructuralFeature)MapPackage.eINSTANCE.getField_Update(), SetCommand.UNSET_VALUE));
                }
            } else if (hasExpression) {
                cc.append((Command)new SetCommand((EditingDomain)domain, (EObject)field, (EStructuralFeature)MapPackage.eINSTANCE.getField_Update(), (Object)defaultValue));
            }
            if (field.eIsSet((EStructuralFeature)MapPackage.eINSTANCE.getField_Insert())) {
                if (!hasExpression) {
                    cc.append((Command)new SetCommand((EditingDomain)domain, (EObject)field, (EStructuralFeature)MapPackage.eINSTANCE.getField_Insert(), SetCommand.UNSET_VALUE));
                }
            } else if (hasExpression) {
                cc.append((Command)new SetCommand((EditingDomain)domain, (EObject)field, (EStructuralFeature)MapPackage.eINSTANCE.getField_Insert(), (Object)defaultValue));
            }
            if (!cc.isEmpty()) {
                return cc;
            }
        }
        return null;
    }

    private boolean defaultValue(ILogicalField field) {
        Map map = (Map)field.eContainer().eContainer();
        AdditionalProperty p = map.getAdditionalProperty("com.indy.map.helpers.semantic", "migration.tool");
        return p == null || p.getValue() == null || p.getValue().isEmpty();
    }

    @Deprecated
    private class RecomputeDetectorAdapter
    extends AdapterImpl {
        private boolean changed = false;

        private RecomputeDetectorAdapter() {
        }

        public void notifyChanged(Notification msg) {
            super.notifyChanged(msg);
            if (msg.getFeature() == RefPackage.eINSTANCE.getRUsage_InternalExpression() || msg.getFeature() == RefPackage.eINSTANCE.getRUsage_SourceRef()) {
                RUsage refUsage = (RUsage)msg.getNotifier();
                if (msg.getEventType() == 5) {
                    for (Object o : (Collection)msg.getNewValue()) {
                        MapModelItem i = ((RSourceItem)o).getDataModel();
                        this.checkNewContainer(refUsage, i);
                    }
                } else if (msg.getEventType() == 6) {
                    for (Object o : (Collection)msg.getOldValue()) {
                        MapModelItem i = ((RSourceItem)o).getDataModel();
                        this.checkRemovedContainer(refUsage, i);
                    }
                } else if (msg.getEventType() == 3) {
                    MapModelItem i = ((RSourceItem)msg.getNewValue()).getDataModel();
                    this.checkNewContainer(refUsage, i);
                } else if (msg.getEventType() == 4) {
                    MapModelItem i = ((RSourceItem)msg.getOldValue()).getDataModel();
                    this.checkRemovedContainer(refUsage, i);
                }
            }
        }

        private void checkNewContainer(RUsage refUsage, MapModelItem i) {
            if (i instanceof ILogicalField) {
                boolean isNew = true;
                for (RSourceItem s : refUsage.getSourceRef()) {
                    EObject container;
                    if (s.getDataModel() == i || !((container = s.getDataModel().eContainer()) instanceof IContainer) || container != i.eContainer()) continue;
                    isNew = false;
                    break;
                }
                if (isNew) {
                    this.changed = true;
                }
            }
        }

        private void checkRemovedContainer(RUsage refUsage, MapModelItem i) {
            if (i instanceof ILogicalField) {
                boolean isRemoved = true;
                for (RSourceItem s : refUsage.getSourceRef()) {
                    EObject container;
                    if (s == i || !((container = s.getDataModel().eContainer()) instanceof IContainer) || container != i.eContainer()) continue;
                    isRemoved = false;
                    break;
                }
                if (isRemoved) {
                    this.changed = true;
                }
            }
        }

        public boolean needRecompute() {
            return this.changed;
        }
    }

    private class UpdateFieldFilterCommand
    extends RecordingCommand {
        private Field field;

        public UpdateFieldFilterCommand(TransactionalEditingDomain domain, Field field) {
            super(domain, Messages.ExpressionUpdater_0, null);
            this.field = field;
        }

        public void dispose() {
            this.field = null;
            super.dispose();
        }

        protected void doExecute() {
            RField ref;
            if (!this.field.isInView() && ((ref = (RField)this.field.getMapReference()) != null && ref.getUsage().isEmpty() || this.field.isMapped())) {
                this.field.setInView(true);
                Field f = this.field.getParent();
                while (f != null) {
                    if (!f.isInView()) {
                        f.setInView(true);
                    }
                    if (!f.isExpand()) {
                        f.setExpand(true);
                    }
                    f = f.getParent();
                }
                this.field.eContainer().eNotify((Notification)new ENotificationImpl((InternalEObject)this.field.eContainer(), 9999, (EStructuralFeature)MapPackage.eINSTANCE.getField_InView(), null, (Object)this.field));
            }
            ref = (RField)this.field.getMapReference();
            for (RExpression exp : ref.getExpressionRef()) {
                for (RSourceItem it : exp.getSourceRef()) {
                    ILogicalField f;
                    if (!(it.getDataModel() instanceof ILogicalField) || !((f = (ILogicalField)((Object)it.getDataModel())) instanceof Field) || ((Field)f).isInView()) continue;
                    ((Field)f).setInView(true);
                    Field _f = ((Field)f).getParent();
                    while (_f != null) {
                        if (!_f.isInView()) {
                            _f.setInView(true);
                        }
                        if (!_f.isExpand()) {
                            _f.setExpand(true);
                        }
                        _f = _f.getParent();
                    }
                    f.eContainer().eNotify((Notification)new ENotificationImpl((InternalEObject)f.eContainer(), 9999, (EStructuralFeature)MapPackage.eINSTANCE.getField_InView(), null, (Object)f));
                }
            }
        }
    }
}

