/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.validation;

import com.indy.map.Filter;
import com.indy.map.ref.RProblem;
import com.indy.map.util.ClauseHelper;
import com.indy.map.validation.ProblemValidationStatus;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;

public class FilterConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        try {
            HashSet<ProblemValidationStatus.ProblemEntry> l = new HashSet<ProblemValidationStatus.ProblemEntry>();
            EObject eObj = ctx.getTarget();
            if (eObj instanceof Filter) {
                Filter filter = (Filter)eObj;
                if (!l.isEmpty()) {
                    return new ProblemValidationStatus(filter, null, l);
                }
                if (filter.isAggregate() && filter.isQualify()) {
                    l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_FILTER_QUALIFY_AND_AGGREGATE, null));
                }
                if (filter.isQualify()) {
                    l.addAll(ClauseHelper.supportQualify(filter).stream().map(w -> new ProblemValidationStatus.ProblemEntry(w.getProblem(), w.getTemplate().getName())).collect(Collectors.toList()));
                }
                if (!l.isEmpty()) {
                    return new ProblemValidationStatus((EObject)filter.getMapReference(), null, l);
                }
            }
            return ctx.createSuccessStatus();
        }
        catch (Throwable t) {
            return new Status(4, "com.indy.gmf.map", ((Object)((Object)this)).getClass().getName() + " Validation failed ", t);
        }
    }
}

