/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.build.internal;

import com.indy.ui.build.Messages;
import com.indy.ui.build.internal.BuildUtil;
import com.indy.ui.custom.out.Activator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class MessageConsoleRunnable
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger(MessageConsoleRunnable.class);
    private final MessageConsole exceptionConsole;

    public MessageConsoleRunnable(MessageConsole exceptionConsole) {
        this.exceptionConsole = exceptionConsole;
    }

    @Override
    public void run() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            LOGGER.debug("Interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try (MessageConsoleStream mcs = MessageConsoleRunnable.this.exceptionConsole.newMessageStream();){
                        mcs.setFontStyle(3);
                        mcs.setColor(Activator.getDefault().getColor(255, 0, 0));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException ex) {
                    LOGGER.warn("Exception while closing stream", (Throwable)ex);
                }
            }
        });
    }

    public static void logInConsole(Exception e) {
        MessageConsole exceptionConsole = BuildUtil.findConsole(Messages.ExecuteAnt_108);
        Thread thread = new Thread((Runnable)new MessageConsoleRunnable(exceptionConsole), Messages.ExecuteAnt_109);
        thread.start();
        exceptionConsole.clearConsole();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (MessageConsoleStream mcs = exceptionConsole.newMessageStream();){
                mcs.println(Messages.ExecuteAnt_110 + e.getMessage());
                e.printStackTrace(new PrintStream((OutputStream)exceptionConsole.newMessageStream()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Exception while closing stream", (Throwable)ex);
        }
    }
}

