/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ftp.commands;

import com.stambia.ftp.commands.FtpCommand;
import com.stambia.ftp.exceptions.FtpCommandException;
import com.stambia.ftp.utils.FtpCommandHandler;
import com.stambia.ftp.utils.FtpStatisticListener;
import com.stambia.ftp.utils.FtpUtils;
import java.io.IOException;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

public class FtpCommand_DELE
extends FtpCommand<FTPClient> {
    public FtpCommand_DELE(String command, String[] parameters) {
        super(command, parameters);
    }

    public FtpCommand_DELE(FtpCommand<FTPClient> ftpCmd) {
        super(ftpCmd);
    }

    @Override
    public void executeCommand(FTPClient ftpCli, String localPath, boolean verbose, FtpCommandHandler commandHandler, List<FtpStatisticListener> statisticsListeners) throws IOException, FtpCommandException {
        String remoteFilePath = FtpUtils.removeFirstAndLastQuotes(this.getParameters()[0]);
        FTPFile[] filesList = ftpCli.listFiles(remoteFilePath);
        if (filesList != null && filesList.length > 0) {
            FTPFile file = filesList[0];
            this.fireStatiscitEvent(statisticsListeners, FtpStatisticListener.Statistic.DELETED_FILES_SIZE, file.getSize());
        }
        ftpCli.sendCommand("DELE", remoteFilePath);
        this.defaultResponseManager(ftpCli, verbose, commandHandler);
    }
}

