/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.sftp.commands;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import com.stambia.ftp.commands.FtpCommand;
import com.stambia.ftp.exceptions.BadSyntaxException;
import com.stambia.ftp.exceptions.FileNotFoundException;
import com.stambia.ftp.exceptions.FtpCommandException;
import com.stambia.ftp.utils.FtpCommandHandler;
import com.stambia.ftp.utils.FtpCommandResponses;
import com.stambia.ftp.utils.FtpStatisticListener;
import com.stambia.ftp.utils.FtpUtils;
import com.stambia.sftp.commands.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class SFtpCommand_APPEND
extends FtpCommand<ChannelSftp> {
    public SFtpCommand_APPEND(String command, String[] parameters) {
        super(command, parameters);
    }

    public SFtpCommand_APPEND(FtpCommand<ChannelSftp> ftpCmd) {
        super(ftpCmd);
    }

    @Override
    public void executeCommand(ChannelSftp ftpCli, String localPath, boolean verbose, FtpCommandHandler commandHandler, List<FtpStatisticListener> statisticsListeners) throws IOException, FtpCommandException {
        String replyString = Messages.getString("SFtpCommand_APPEND.0");
        String localSource = FtpUtils.removeFirstAndLastQuotes(this.getParameters()[0]);
        String remoteDest = FtpUtils.removeFirstAndLastQuotes(this.getParameters()[1]);
        if (localSource != null) {
            File localFile = new File(localSource);
            this.fireStatiscitEvent(statisticsListeners, FtpStatisticListener.Statistic.APPEND_ADDED_FILE_SIZE, localFile.length());
            if (localFile.isFile() || new File(ftpCli.lpwd() + "/" + localSource).isFile() || localSource.contains("*")) {
                try {
                    if (remoteDest != null && !remoteDest.isEmpty()) {
                        ftpCli.put(localSource, remoteDest, 2);
                    } else {
                        Throwable throwable = null;
                        Object var11_15 = null;
                        try (FileInputStream fileInputStream = new FileInputStream(localFile);){
                            ftpCli.put((InputStream)fileInputStream, localFile.getName(), 2);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    if (verbose) {
                        commandHandler.handleResponse(replyString);
                    }
                }
                catch (SftpException e) {
                    FtpCommandException ftpCommandException = new FtpCommandException(e.getMessage());
                    commandHandler.handleError("", ftpCommandException);
                }
            } else {
                FileNotFoundException ftpCommandException = new FileNotFoundException(Messages.getString("SFtpCommand_APPEND.1"));
                commandHandler.handleError("", ftpCommandException);
            }
        } else {
            BadSyntaxException exception = new BadSyntaxException(FtpCommandResponses.MISSING_PARAMETER);
            commandHandler.handleError("", exception);
        }
    }
}

