/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.sftp.commands;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import com.stambia.ftp.commands.FtpCommand;
import com.stambia.ftp.exceptions.BadSyntaxException;
import com.stambia.ftp.exceptions.FtpCommandException;
import com.stambia.ftp.utils.FtpCommandHandler;
import com.stambia.ftp.utils.FtpCommandResponses;
import com.stambia.ftp.utils.FtpStatisticListener;
import com.stambia.ftp.utils.FtpUtils;
import com.stambia.sftp.commands.Messages;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

public class SFtpCommand_GET
extends FtpCommand<ChannelSftp> {
    public SFtpCommand_GET(String command, String[] parameters) {
        super(command, parameters);
    }

    public SFtpCommand_GET(FtpCommand<ChannelSftp> ftpCmd) {
        super(ftpCmd);
    }

    @Override
    public void executeCommand(ChannelSftp ftpCli, String localPath, boolean verbose, FtpCommandHandler commandHandler, List<FtpStatisticListener> statisticsListeners) throws IOException, FtpCommandException {
        String replyString = Messages.getString("SFtpCommand_GET.0");
        String remoteSource = FtpUtils.removeFirstAndLastQuotes(this.getParameters()[0]);
        String localDest = FtpUtils.removeFirstAndLastQuotes(this.getParameters()[1]);
        int mode = -1;
        if (this.getParameters()[2] != null) {
            mode = Integer.valueOf(this.getParameters()[2]);
        }
        if (remoteSource != null) {
            if (localDest == null) {
                localDest = ftpCli.lpwd();
                mode = -1;
            }
            try {
                if (mode != 2 && mode != 0 && mode != 1) {
                    mode = 0;
                    if (remoteSource.contains("*") || remoteSource.endsWith("/") || remoteSource.endsWith("\\") || remoteSource.equals("./")) {
                        String filePath = FtpUtils.retrievePath(remoteSource, "./");
                        Vector fileList = ftpCli.ls(filePath);
                        this.fireStatiscitEvent(statisticsListeners, FtpStatisticListener.Statistic.RETRIEVED_FILES_NUMBER, fileList.size());
                        if (remoteSource.endsWith("*") || remoteSource.endsWith("/") || remoteSource.endsWith("\\")) {
                            for (ChannelSftp.LsEntry file : fileList) {
                                String fileName = file.getFilename();
                                this.fireStatiscitEvent(statisticsListeners, FtpStatisticListener.Statistic.RETRIEVED_FILES_SIZE, file.getAttrs().getSize());
                                if (file.getAttrs().isDir()) continue;
                                ftpCli.get(filePath + "/" + fileName, localDest, null, mode);
                                if (!verbose) continue;
                                commandHandler.handleResponse(replyString);
                            }
                        } else if (remoteSource.contains("*")) {
                            String extension = remoteSource.substring(remoteSource.indexOf("*") + 1);
                            for (ChannelSftp.LsEntry file : fileList) {
                                String fileName = file.getFilename();
                                this.fireStatiscitEvent(statisticsListeners, FtpStatisticListener.Statistic.RETRIEVED_FILES_SIZE, file.getAttrs().getSize());
                                if (!fileName.endsWith(extension)) continue;
                                ftpCli.get(filePath + "/" + fileName, localDest, null, mode);
                                if (!verbose) continue;
                                commandHandler.handleResponse(replyString);
                            }
                        } else {
                            BadSyntaxException e = new BadSyntaxException(remoteSource);
                            commandHandler.handleError(remoteSource, e);
                        }
                    } else {
                        this.fireStatiscitEvent(statisticsListeners, FtpStatisticListener.Statistic.RETRIEVED_FILES_SIZE, new File(ftpCli.lpwd() + "/" + remoteSource).length());
                        ftpCli.get(remoteSource, localDest, null, mode);
                    }
                }
                if (verbose) {
                    commandHandler.handleResponse(replyString);
                }
            }
            catch (SftpException e) {
                FtpCommandException ftpCommandException = new FtpCommandException(e.getMessage());
                commandHandler.handleError("", ftpCommandException);
            }
        } else {
            BadSyntaxException exception = new BadSyntaxException(FtpCommandResponses.MISSING_PARAMETER);
            commandHandler.handleError("", exception);
        }
    }
}

