/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.sftp.commands;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import com.stambia.ftp.commands.FtpCommand;
import com.stambia.ftp.exceptions.BadSyntaxException;
import com.stambia.ftp.exceptions.FtpCommandException;
import com.stambia.ftp.utils.FtpCommandHandler;
import com.stambia.ftp.utils.FtpCommandResponses;
import com.stambia.ftp.utils.FtpStatisticListener;
import com.stambia.ftp.utils.FtpUtils;
import com.stambia.sftp.commands.Messages;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

public class SFtpCommand_RM
extends FtpCommand<ChannelSftp> {
    public SFtpCommand_RM(String command, String[] parameters) {
        super(command, parameters);
    }

    public SFtpCommand_RM(FtpCommand<ChannelSftp> ftpCmd) {
        super(ftpCmd);
    }

    @Override
    public void executeCommand(ChannelSftp ftpCli, String localPath, boolean verbose, FtpCommandHandler commandHandler, List<FtpStatisticListener> statisticsListeners) throws IOException, FtpCommandException {
        String replyString = Messages.getString("SFtpCommand_RM.0");
        String toRemove = FtpUtils.removeFirstAndLastQuotes(this.getParameters()[0]);
        if (toRemove != null) {
            try {
                Vector fileList = ftpCli.ls(localPath);
                int i = 0;
                while (i < fileList.size()) {
                    if (((ChannelSftp.LsEntry)fileList.elementAt(i)).getFilename().equals(toRemove)) {
                        this.fireStatiscitEvent(statisticsListeners, FtpStatisticListener.Statistic.DELETED_FILES_SIZE, ((ChannelSftp.LsEntry)fileList.elementAt(i)).getAttrs().getSize());
                    }
                    ++i;
                }
                ftpCli.rm(toRemove);
                if (verbose) {
                    commandHandler.handleResponse(replyString);
                }
            }
            catch (SftpException e) {
                FtpCommandException ftpCommandException = new FtpCommandException(e.getMessage());
                commandHandler.handleError("", ftpCommandException);
            }
        } else {
            BadSyntaxException exception = new BadSyntaxException(FtpCommandResponses.MISSING_PARAMETER);
            commandHandler.handleError("", exception);
        }
    }
}

