/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.sftp.commands;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import com.stambia.ftp.commands.FtpCommand;
import com.stambia.ftp.exceptions.FtpCommandException;
import com.stambia.ftp.utils.FtpCommandHandler;
import com.stambia.ftp.utils.FtpStatisticListener;
import com.stambia.ftp.utils.FtpUtils;
import com.stambia.sftp.commands.Messages;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SFtpCommand_RMDIR
extends FtpCommand<ChannelSftp> {
    private final Logger logger = LogManager.getLogger(SFtpCommand_RMDIR.class);

    public SFtpCommand_RMDIR(String command, String[] parameters) {
        super(command, parameters);
    }

    public SFtpCommand_RMDIR(FtpCommand<ChannelSftp> ftpCmd) {
        super(ftpCmd);
    }

    private void recursiveFolderDelete(String path, ChannelSftp ftpCli) {
        try {
            Vector fileList = ftpCli.ls(path);
            for (ChannelSftp.LsEntry file : fileList) {
                if (!file.getAttrs().isDir()) {
                    ftpCli.rm(path + "/" + file.getFilename());
                    continue;
                }
                if (".".equals(file.getFilename()) || "..".equals(file.getFilename())) continue;
                try {
                    ftpCli.rmdir(path + "/" + file.getFilename());
                }
                catch (Exception e) {
                    this.recursiveFolderDelete(path + "/" + file.getFilename(), ftpCli);
                }
            }
            ftpCli.rmdir(path);
        }
        catch (SftpException e) {
            this.logger.warn("Error while removing directory  ", (Throwable)e);
        }
    }

    @Override
    public void executeCommand(ChannelSftp ftpCli, String localPath, boolean verbose, FtpCommandHandler commandHandler, List<FtpStatisticListener> statisticsListeners) throws IOException, FtpCommandException {
        String remoteSource = FtpUtils.removeFirstAndLastQuotes(this.getParameters()[0]);
        String replyString = Messages.getString("SFtpCommand_RMDIR.0");
        String filePath = remoteSource;
        try {
            Vector fileList = ftpCli.ls(filePath);
            for (ChannelSftp.LsEntry file : fileList) {
                if (!file.getAttrs().isDir()) {
                    ftpCli.rm(filePath + "/" + file.getFilename());
                    continue;
                }
                if (".".equals(file.getFilename()) || "..".equals(file.getFilename())) continue;
                try {
                    ftpCli.rmdir(filePath + "/" + file.getFilename());
                }
                catch (Exception e) {
                    this.recursiveFolderDelete(filePath + "/" + file.getFilename(), ftpCli);
                }
            }
            ftpCli.rmdir(remoteSource);
            if (verbose) {
                commandHandler.handleResponse(replyString);
            }
        }
        catch (SftpException e) {
            FtpCommandException ftpCommandException = new FtpCommandException(e.getMessage());
            commandHandler.handleError("", ftpCommandException);
        }
    }
}

