/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.core.models;

import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class EmbeddedDiagramUpdater {
    private EmbeddedDiagramUpdater() {
    }

    public static String getRawDiagram(String rawDiagram, Map<String, String> idMap) throws Exception {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.supportDTD", false);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(rawDiagram.length());
        XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(bos, StandardCharsets.UTF_8.name());
        XMLEventReader reader = factory.createXMLEventReader(new ByteArrayInputStream(rawDiagram.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8.name());
        HashMap<String, String> replacedIds = new HashMap<String, String>();
        block6: while (reader.hasNext()) {
            XMLEvent ev = reader.nextEvent();
            switch (ev.getEventType()) {
                case 7: {
                    writer.writeStartDocument();
                    break;
                }
                case 8: {
                    writer.writeEndDocument();
                    break;
                }
                case 1: {
                    StartElement se = ev.asStartElement();
                    writer.writeStartElement(se.getName().getPrefix(), se.getName().getLocalPart(), se.getName().getNamespaceURI());
                    Iterator<Namespace> it = se.getNamespaces();
                    while (it.hasNext()) {
                        Namespace nm = it.next();
                        writer.writeNamespace(nm.getPrefix(), nm.getNamespaceURI());
                    }
                    boolean needUpdate = se.getName().getLocalPart().equals("element");
                    boolean isEdge = se.getName().getLocalPart().equals("edges");
                    Iterator<Attribute> it2 = se.getAttributes();
                    while (it2.hasNext()) {
                        Attribute a = it2.next();
                        if (a.getName().getLocalPart().equals("id") && a.getName().getPrefix().equals("xmi")) {
                            String newElementId = null;
                            newElementId = UUID.randomUUID().toString();
                            writer.writeAttribute(a.getName().getPrefix(), a.getName().getNamespaceURI(), a.getName().getLocalPart(), newElementId);
                            replacedIds.put(a.getValue(), newElementId);
                            continue;
                        }
                        if (needUpdate && a.getName().getLocalPart().equals("href")) {
                            String fragment = a.getValue().substring(a.getValue().indexOf("#") + 1);
                            String fileID = CacheHelper.extractFileID(fragment);
                            String eltID = CacheHelper.extractEltID(fragment);
                            String newFileId = idMap.get(fileID);
                            String newEltId = idMap.get(eltID);
                            String value = "resource#" + newEltId + "?fileId=" + newFileId + "?";
                            writer.writeAttribute(a.getName().getPrefix(), a.getName().getNamespaceURI(), a.getName().getLocalPart(), value);
                            continue;
                        }
                        if (isEdge && (a.getName().getLocalPart().equals("source") || a.getName().getLocalPart().equals("target"))) {
                            writer.writeAttribute(a.getName().getPrefix(), a.getName().getNamespaceURI(), a.getName().getLocalPart(), (String)replacedIds.get(a.getValue()));
                            continue;
                        }
                        writer.writeAttribute(a.getName().getPrefix(), a.getName().getNamespaceURI(), a.getName().getLocalPart(), a.getValue());
                    }
                    continue block6;
                }
                case 2: {
                    writer.writeEndElement();
                }
            }
        }
        return new String(bos.toByteArray(), StandardCharsets.UTF_8);
    }
}

