/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.core.models;

import com.semarchy.xdi.designer.core.indexation.IndexationRegisterExtension;
import com.semarchy.xdi.designer.core.models.IndyResourceUtil;
import com.semarchy.xdi.designer.core.models.Messages;
import com.semarchy.xdi.designer.core.models.ModelWithDuplicateIdException;
import com.semarchy.xdi.designer.core.utils.EMFResourceUtil;
import com.semarchy.xdi.designer.core.utils.IntrospectionUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.BasicResourceHandler;
import org.eclipse.emf.ecore.xmi.impl.SAXXMLHandler;
import org.eclipse.emf.ecore.xmi.impl.XMLMapImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;

public class IndyXMLResource
extends XMLResourceImpl
implements IndyResourceUtil.IndyResource {
    public static final String MODEL_ENCODING = "UTF-8";
    String id;
    private IndyResourceUtil.IndyURIHandler uriHandler = new IndyResourceUtil.IndyURIHandler();

    public Map<String, String> reinitAllId(String rootMainId, Map<String, String> oldIdtoNewId) {
        HashMap<String, String> _return = new HashMap<String, String>();
        ArrayList<EObject> list = new ArrayList<EObject>();
        TreeIterator it = this.getAllContents();
        while (it.hasNext()) {
            list.add((EObject)it.next());
        }
        for (EObject obj : list) {
            boolean deliver;
            Object oldId;
            if (this.useUUIDs()) {
                oldId = this.getID(obj);
                Object newId = EcoreUtil.generateUUID();
                if (rootMainId != null && obj == ((EObject)this.getContents().get(0)).eContents().get(0)) {
                    String uriS = this.getURI().toPlatformString(true);
                    if (uriS.endsWith(".proc")) {
                        newId = rootMainId + "-proc";
                    } else if (uriS.endsWith(".md")) {
                        newId = rootMainId + "-flow";
                    }
                }
                deliver = obj.eDeliver();
                try {
                    obj.eSetDeliver(false);
                    this.setID(obj, (String)newId, oldIdtoNewId);
                }
                finally {
                    obj.eSetDeliver(deliver);
                }
                _return.put((String)oldId, (String)newId);
                continue;
            }
            oldId = IntrospectionUtils.getMethod(obj, "getId");
            if (oldId == null) continue;
            Object s = null;
            if (rootMainId != null && obj == ((EObject)this.getContents().get(0)).eContents().get(0)) {
                String uriS = this.getURI().toPlatformString(true);
                if (uriS.endsWith(".proc")) {
                    s = rootMainId + "-proc";
                } else if (uriS.endsWith(".md")) {
                    if (this.getURI().lastSegment().contains("-ref-") && ((String)oldId).contains("-Stage-")) {
                        String suffix = ((String)oldId).substring(((String)oldId).indexOf("-Stage-"));
                        s = rootMainId + suffix;
                    } else {
                        s = rootMainId + "-flow";
                    }
                }
            }
            if (s == null) {
                s = EcoreUtil.generateUUID();
            }
            deliver = obj.eDeliver();
            try {
                obj.eSetDeliver(false);
                IntrospectionUtils.setMethod(obj, "setId", s);
                Object newId = IntrospectionUtils.getMethod(obj, "getId");
                _return.put((String)oldId, (String)newId);
            }
            finally {
                obj.eSetDeliver(deliver);
            }
        }
        return _return;
    }

    protected void setID(EObject obj, String newId, Map<String, String> oldIdToNewId) {
        this.setID(obj, newId);
    }

    public IndyXMLResource(URI uri) {
        super(uri);
        this.setIntrinsicIDToEObjectMap(new TreeMap());
        this.getDefaultLoadOptions().put("URI_HANDLER", this.uriHandler);
        this.getDefaultSaveOptions().put("URI_HANDLER", this.uriHandler);
        final IndyXMLResource res = this;
        this.getDefaultLoadOptions().put("RESOURCE_HANDLER", new BasicResourceHandler(){

            public void postLoad(XMLResource resource, InputStream inputStream, Map<?, ?> options) {
                IndyXMLResource.this.id = EMFResourceUtil.getFirstId(res);
            }
        });
        if (this.useUUIDs()) {
            XMLMapImpl map = new XMLMapImpl();
            map.setIDAttributeName("id");
            this.getDefaultLoadOptions().put("XML_MAP", map);
        }
    }

    public Map<EObject, String> getEObjectToIDMap() {
        return super.getEObjectToIDMap();
    }

    public String getURIFragment(EObject eObject) {
        String fragment = super.getURIFragment(eObject);
        if (IndexationRegisterExtension.EXTENSION_MANAGER.isAvailableSource(this, eObject)) {
            fragment = IndyResourceUtil.generateFragment(DETACHED_EOBJECT_TO_ID_MAP, this, fragment, eObject);
        }
        return fragment;
    }

    public EObject getEObject(String uriFragment) {
        EObject obj = super.getEObject(uriFragment);
        return obj;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    protected URIConverter getURIConverter() {
        this.getURI().isPlatformPlugin();
        return super.getURIConverter();
    }

    protected void doUnload() {
        super.doUnload();
        if (this.getIntrinsicIDToEObjectMap() != null) {
            this.getIntrinsicIDToEObjectMap().clear();
        }
    }

    public String getExternalURIFragment(EObject eObject) {
        String fragment = super.getURIFragment(eObject);
        fragment = IndyResourceUtil.generateFragment(DETACHED_EOBJECT_TO_ID_MAP, this, fragment, eObject);
        return fragment;
    }

    public static class IndyXMLHandler
    extends SAXXMLHandler {
        boolean checkDuplicateIds = false;
        Set<String> ids = new HashSet<String>();

        public IndyXMLHandler(XMLResource xmiResource, XMLHelper helper, Map<?, ?> options) {
            super(xmiResource, helper, options);
            if (options.get("com.indy.emf.uri.resource.load.detectDuplicateId") == Boolean.TRUE) {
                this.checkDuplicateIds = true;
            }
        }

        protected void setFeatureValue(EObject object, EStructuralFeature feature, Object value, int position) {
            if (this.checkDuplicateIds && value instanceof String && object.eClass().getEIDAttribute() == feature && !this.ids.add((String)value)) {
                this.error(new ModelWithDuplicateIdException(String.format(Messages.IndyXMLResource_duplicateIdErrorMessage, value), this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
            }
            super.setFeatureValue(object, feature, value, position);
        }
    }
}

