/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.core.services;

import java.lang.reflect.ParameterizedType;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;

public interface IRegistryService {
    public static String extractRegistryIdFromContribution(String contributedRegistry) {
        int i = contributedRegistry.indexOf("[");
        if (i == -1) {
            return contributedRegistry;
        }
        return contributedRegistry.substring(0, i);
    }

    public <T> IRegistry<T> getRegistry(Class<T> var1);

    public void updateObjectsFrom(IRegistrationContribution var1) throws Exception;

    public void clear();

    public void unregisterObjectsFrom(String var1);

    public void persist();

    public static interface IRegistrationContribution
    extends Resource {
        public List<Class> getContributedRegistries();

        public List<Object> createRegistryItemsFor(Class var1) throws Exception;
    }

    public static interface IRegistry<E> {
        default public Class<E> getType() {
            return (Class)((ParameterizedType)this.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
        }

        public boolean registerFrom(String var1, IRegistrationContribution var2) throws Exception;

        public boolean unregisterFrom(String var1);

        public E find(IRegistryKey var1);

        public List<E> find(IRegistryMatcher var1);

        public List<E> getAll();

        public void clear();

        public void addRegistryItemEventListener(IRegistryItemEventListener var1);

        public void removeRegistryItemEventListener(IRegistryItemEventListener var1);

        public void addRegistryBatchEventListener(IRegistryBatchEventListener var1);

        public void removeRegistryBatchEventListener(IRegistryBatchEventListener var1);
    }

    public static interface IRegistryBatchEventListener {
        public void handleBatchedEvent();
    }

    public static interface IRegistryItemEventListener {
        public void handleItemAdded(IRegistryKey var1, Object var2);

        public void handleItemRemoved(IRegistryKey var1, Object var2);

        public void handleItemUpdated(IRegistryKey var1, Object var2);
    }

    public static interface IRegistryKey
    extends IRegistryMatcher {
        public String getProviderFileID();
    }

    public static interface IRegistryMatcher {
        public boolean match(Object var1);
    }

    public static interface RegistryItem {
        public IRegistryKey getRegistrationKey();
    }
}

