/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.core.services.cache;

import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import org.eclipse.emf.common.util.URI;

public class CacheEventResource {
    public static final int ADDED = 1;
    public static final int REMOVED = 2;
    private int type;
    private EventType eventType;
    private URI resourceURI;
    private String sourceID;
    private boolean resolvedSourceID = false;

    public CacheEventResource(int type, EventType eventType, URI resourceURI, String sourceID) {
        this.type = type;
        this.eventType = eventType;
        this.resourceURI = resourceURI;
        this.sourceID = sourceID;
    }

    public String getSourceID() {
        if (this.sourceID == null && !this.resolvedSourceID) {
            try {
                this.sourceID = E4InjectorHelper.getService(ICacheService.class).getSourceId(this.resourceURI);
            }
            finally {
                this.resolvedSourceID = true;
            }
        }
        return this.sourceID;
    }

    public int getType() {
        return this.type;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public URI getResourceInfo() {
        return this.resourceURI;
    }

    public static enum EventType {
        UNBUILT,
        ERROR;

    }
}

