/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.core.services.registry;

import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.io.Serializable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;

public class ReferencableObject
implements IRegistryService.RegistryItem,
Serializable {
    private static final long serialVersionUID = 6876207985872635124L;
    private ReferencableObjectKey key;
    private String defType;
    private transient URI modelURINode;

    public ReferencableObject(URI modelObjectURI, String defType) {
        Assert.isNotNull((Object)modelObjectURI);
        Assert.isTrue((!modelObjectURI.fragment().isEmpty() ? 1 : 0) != 0);
        this.key = new ReferencableObjectKey(modelObjectURI);
        this.defType = defType;
    }

    @Override
    public IRegistryService.IRegistryKey getRegistrationKey() {
        return this.key;
    }

    public URI getModelObjectURI() {
        if (this.modelURINode == null) {
            ICacheService s = E4InjectorHelper.getService(ICacheService.class);
            URI sourceURI = s.findResourceURIByFileId(this.key.fileID);
            this.modelURINode = sourceURI.appendFragment(this.key.eltID + "?fileId=" + this.key.eltID + "?");
        }
        return this.modelURINode;
    }

    public static class DefTypeMatcher
    implements IRegistryService.IRegistryMatcher {
        private String defType;

        public DefTypeMatcher(String defType) {
            this.defType = defType;
        }

        @Override
        public boolean match(Object o) {
            if (o instanceof ReferencableObject) {
                return this.defType.equals(((ReferencableObject)o).defType);
            }
            return false;
        }
    }

    public class ReferencableObjectKey
    implements IRegistryService.IRegistryKey,
    Serializable {
        private static final long serialVersionUID = 3910045308589567302L;
        private String fileID;
        private String eltID;

        ReferencableObjectKey(URI modelURI) {
            this.fileID = CacheHelper.extractFileID(modelURI.fragment());
            this.eltID = CacheHelper.extractEltID(modelURI.fragment());
            Assert.isNotNull((Object)this.fileID);
            Assert.isNotNull((Object)this.eltID);
        }

        @Override
        public boolean match(Object o) {
            if (o instanceof ReferencableObjectKey) {
                return this.fileID.equals(((ReferencableObjectKey)o).fileID) && this.eltID.equals(((ReferencableObjectKey)o).eltID);
            }
            return false;
        }

        @Override
        public String getProviderFileID() {
            return this.fileID;
        }
    }
}

