/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.core.services.registry;

import com.semarchy.xdi.designer.core.services.IRegistryService;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class RegistrationDescriptor
implements IRegistryService.RegistryItem,
Serializable {
    private static final long serialVersionUID = -3385051174783346232L;
    private Set<Class> itemClassName = new HashSet<Class>();
    private RegistrationDescriptorKey key;

    public RegistrationDescriptor(String fileID) {
        this.key = new RegistrationDescriptorKey(fileID);
    }

    public void addItemClassName(String className) throws ClassNotFoundException {
        Class<?> c = Class.forName(className, true, RegistrationDescriptor.class.getClassLoader());
        if (c != null) {
            this.itemClassName.add(c);
        }
    }

    public Collection<Class> getRegistryItemsClass() {
        return new HashSet<Class>(this.itemClassName);
    }

    @Override
    public IRegistryService.IRegistryKey getRegistrationKey() {
        return this.key;
    }

    public static class RegistrationDescriptorKey
    implements IRegistryService.IRegistryKey,
    Serializable {
        private static final long serialVersionUID = -1828502815070263473L;
        private String fileID;

        public RegistrationDescriptorKey(String fileID) {
            this.fileID = fileID;
        }

        @Override
        public boolean match(Object o) {
            if (o instanceof RegistrationDescriptorKey) {
                return this.fileID.equals(((RegistrationDescriptorKey)o).fileID);
            }
            return false;
        }

        public int hashCode() {
            return this.fileID.hashCode();
        }

        public boolean equals(Object obj) {
            return this.match(obj);
        }

        @Override
        public String getProviderFileID() {
            return this.fileID;
        }
    }
}

