/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.core.utils;

import com.semarchy.xdi.designer.core.utils.Messages;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;

public class EnvironmentVariableHelper {
    public static String resolveEnvironmentVariables(String text, Mode mode) throws MissingEnvironmentVariableException {
        if (text != null) {
            HashSet<String> missingEnvironmentVariables = new HashSet<String>();
            Matcher m = mode.pattern.matcher(text);
            int current = 0;
            StringBuffer buf = new StringBuffer();
            while (m.find(current)) {
                buf.append(text.substring(current, m.start()));
                String varName = m.group(2);
                try {
                    buf.append(VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution("${" + varName + "}"));
                }
                catch (CoreException e) {
                    missingEnvironmentVariables.add(varName);
                }
                current = m.end();
            }
            if (!missingEnvironmentVariables.isEmpty()) {
                throw new MissingEnvironmentVariableException(missingEnvironmentVariables);
            }
            if (current < text.length()) {
                buf.append(text.substring(current));
            }
            return buf.toString();
        }
        return text;
    }

    public static class MissingEnvironmentVariableException
    extends Exception {
        Collection<String> varName;

        public MissingEnvironmentVariableException(Collection<String> missingVariableNames) {
            super(String.format(Messages.EnvironmentVariableHelper_0, missingVariableNames.stream().collect(Collectors.joining(", "))));
            this.varName = missingVariableNames;
        }

        public Collection<String> getMissingVariableName() {
            return this.varName;
        }
    }

    public static enum Mode {
        MdModel(Pattern.compile("%(\\{env:([^\\{\\}%]+)\\})%")),
        ProcModel(Pattern.compile("(\\$\\{([0-9a-zA-Z_\\-]+)\\})"));

        Pattern pattern;

        private Mode(Pattern p) {
            this.pattern = p;
        }
    }
}

