/*
 * Decompiled with CFR 0.152.
 */
package com.indy.libraries.management.ui.wizard;

import com.indy.engine.core.module.IModuleService;
import com.indy.libraries.management.ui.Activator;
import com.indy.libraries.management.ui.wizard.Messages;
import com.semarchy.xdi.designer.core.services.IBaseModuleProvider;
import com.semarchy.xdi.designer.core.services.IModuleClassLoaderProvider;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;

public class ModuleControler {
    public static Image warningIcon = Activator.imageDescriptorFromPlugin((String)"org.eclipse.jface", (String)"/org/eclipse/jface/dialogs/images/message_warning.png").createImage();
    public static Image errorIcon = Activator.imageDescriptorFromPlugin((String)"org.eclipse.jface", (String)"/org/eclipse/jface/dialogs/images/message_error.png").createImage();
    static Image infoIcon = Activator.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"icons/full/obj16/info_tsk.png").createImage();
    private IBaseModuleProvider provider;
    private IModuleService.IBaseModule selectedBaseModule;
    private IModuleService.IModuleDescriptor selectedModule;
    private IModuleService moduleService;
    private IModuleClassLoaderProvider classLoaderProvider;
    private String name;
    private ModuleState moduleState = ModuleState.FULL;
    DummyModule dummy = null;
    ModuleContent content = new ModuleContent();
    private IModuleService.IBaseModuleExtension extension;
    private Listener validationListener;
    private ModuleStateListener moduleStateListener;
    private HashMap<String, List<IModuleService.IBaseModuleExtension>> extensions = new HashMap();
    private boolean createMode = false;
    private boolean editOrCreate = false;

    public ModuleControler(boolean onlyEdit, boolean createMode, IModuleService.IModuleDescriptor initialSelection) {
        this.provider = (IBaseModuleProvider)PlatformUI.getWorkbench().getService(IBaseModuleProvider.class);
        this.moduleService = (IModuleService)PlatformUI.getWorkbench().getService(IModuleService.class);
        this.classLoaderProvider = (IModuleClassLoaderProvider)PlatformUI.getWorkbench().getService(IModuleClassLoaderProvider.class);
        if (!onlyEdit) {
            this.dummy = new DummyModule();
        }
        if (initialSelection != null) {
            this.setSelectedModule(initialSelection);
        }
        this.createMode = createMode;
        this.editOrCreate = this.createMode || onlyEdit;
    }

    public boolean isEditOrCreate() {
        return this.editOrCreate;
    }

    public void setListener(Listener v) {
        this.validationListener = v;
    }

    public void setModuleStateListener(ModuleStateListener v) {
        this.moduleStateListener = v;
    }

    public void setModuleName(String name) {
        this.name = name;
        this.validate();
    }

    private void validate() {
        if (this.validationListener != null) {
            String errorMessage = null;
            if (this.getSelectedModule() instanceof DummyModule) {
                IModuleService.IModule m;
                if (!this.name.matches("[a-zA-Z0-9]{1}?[a-zA-Z0-9_\\-\\s\\.]*") || this.name.startsWith("internal") || this.name.equals("default")) {
                    errorMessage = Messages.ModuleControler_8;
                } else if (this.selectedModule == this.dummy && (m = this.moduleService.getModule(this.name)) != null) {
                    errorMessage = Messages.ModuleControler_9;
                }
                if (this.name.equals("core")) {
                    errorMessage = Messages.ModuleControler_11;
                }
            }
            this.validationListener.handleError(errorMessage);
        }
    }

    public List<IModuleService.IBaseModule> getBaseModules() {
        ArrayList<IModuleService.IBaseModule> l = new ArrayList<IModuleService.IBaseModule>(this.provider.getBaseModules());
        Collections.sort(l, new Comparator<IModuleService.IBaseModule>(){

            @Override
            public int compare(IModuleService.IBaseModule a, IModuleService.IBaseModule b) {
                return a.getLabel().compareTo(b.getLabel());
            }
        });
        return l;
    }

    public List<IModuleService.IBaseModuleExtension> getAvailableExtensions(IModuleService.IBaseModule module) {
        if (module == null) {
            return Collections.EMPTY_LIST;
        }
        List<IModuleService.IBaseModuleExtension> l = this.extensions.get(module.getInfo().getId());
        if (l == null) {
            l = new ArrayList<IModuleService.IBaseModuleExtension>(this.provider.getAvailableExtensions(module.getInfo().getId()));
            this.extensions.put(module.getInfo().getId(), l);
            Collections.sort(l, new Comparator<IModuleService.IBaseModuleExtension>(){

                @Override
                public int compare(IModuleService.IBaseModuleExtension a, IModuleService.IBaseModuleExtension b) {
                    return a.getLabel().compareTo(b.getLabel());
                }
            });
        }
        return l;
    }

    public List<IModuleService.IModuleDescriptor> getModules4Selection() {
        ArrayList<IModuleService.IModuleDescriptor> l = new ArrayList<IModuleService.IModuleDescriptor>();
        if (this.selectedBaseModule != null) {
            for (IModuleService.IModule m : this.moduleService.getModules()) {
                if (!m.getDescriptor().getBaseModuleInfo().getId().equals(this.selectedBaseModule.getInfo().getId())) continue;
                l.add(m.getDescriptor());
            }
        }
        Collections.sort(l, new Comparator<IModuleService.IModuleDescriptor>(){

            @Override
            public int compare(IModuleService.IModuleDescriptor a, IModuleService.IModuleDescriptor b) {
                return a.getModuleName().compareTo(b.getModuleName());
            }
        });
        if (!(this.dummy == null || this.selectedBaseModule != null && this.selectedBaseModule.getInfo().getId().equals("com.indy.baseModule.default"))) {
            l.add(0, this.dummy);
        }
        return l;
    }

    public void setSelectedExtension(IModuleService.IBaseModuleExtension extension) {
        this.extension = extension;
        this.updateContent();
        this.updateState();
    }

    public void updateContent() {
        if (this.dummy != null) {
            this.dummy.gatheredFiles = null;
        }
        if (this.getSelectedModule() != null) {
            this.content.initFrom(this.getSelectedModule());
        } else {
            this.content.initFrom((IModuleService.IModule)null);
        }
    }

    public void updateState() {
        ModuleState oldModuleState = this.moduleState;
        this.moduleState = this.computeModuleState(this.getSelectedModule(), this.content);
        if (!oldModuleState.equals((Object)this.moduleState) && this.moduleStateListener != null) {
            this.moduleStateListener.handleModuleState();
        }
    }

    public void setSelectedBaseModule(IModuleService.IBaseModule selection) {
        this.selectedBaseModule = selection;
        if (selection != null) {
            this.name = selection.getLabel();
            if (this.dummy != null) {
                this.dummy.name = "<new " + selection.getLabel() + " Module>";
            }
        } else {
            this.name = "<new Module>";
            if (this.dummy != null) {
                this.dummy.name = this.name;
            }
        }
        this.updateContent();
    }

    public ModuleContent getContent() {
        return this.content;
    }

    public ModuleState computeModuleState(IModuleService.IModuleDescriptor desc, ModuleContent c) {
        if (desc != this.dummy && desc.getModuleName().equals("internal")) {
            return ModuleState.FULL;
        }
        IModuleService.IBaseModule base = null;
        IModuleService.IBaseModuleExtension ext = null;
        if (this.selectedBaseModule != null) {
            block0: for (IModuleService.IBaseModule b : this.getBaseModules()) {
                if (!b.getInfo().getId().equals(desc.getBaseModuleInfo().getId())) continue;
                base = b;
                if (desc.getBaseModuleExtensionInfo() == null) break;
                for (IModuleService.IBaseModuleExtension e : this.getAvailableExtensions(base)) {
                    if (!e.getInfo().getId().endsWith(desc.getBaseModuleExtensionInfo().getId())) continue;
                    ext = e;
                    break block0;
                }
            }
        }
        ModuleState state = null;
        state = base != null && base.expectAdditionalFiles() ? (ext == null ? (c.userFiles.isEmpty() && c.toInstall.isEmpty() ? ModuleState.LIBS_REQUIRED : ModuleState.LIBS_ADDED) : (ext.expectAdditionalFiles() ? (c.userFiles.isEmpty() && c.toInstall.isEmpty() ? ModuleState.LIBS_REQUIRED : ModuleState.LIBS_ADDED) : ModuleState.FULL)) : (base == null ? ModuleState.UNKNOWN : ModuleState.FULL);
        return state;
    }

    public void setSelectedModule(IModuleService.IModuleDescriptor selection) {
        this.selectedModule = selection;
        if (selection != null) {
            this.content.initFrom(this.moduleService.getModule(selection.getModuleName()));
        } else {
            this.content.initFrom(selection);
        }
        this.validate();
        if (selection != null) {
            this.updateState();
        }
    }

    public ModuleState getModuleState() {
        return this.moduleState;
    }

    public IModuleService.IModuleDescriptor getSelectedModule() {
        return this.selectedModule;
    }

    public IModuleService.IBaseModule getSelectedBaseModule() {
        return this.selectedBaseModule;
    }

    public int getModuleCount(IModuleService.IBaseModule baseModules) {
        int count = 0;
        for (IModuleService.IModule m : this.moduleService.getModules()) {
            if (!m.getDescriptor().getBaseModuleInfo().getId().equals(baseModules.getInfo().getId())) continue;
            ++count;
        }
        return count;
    }

    public IModuleService.IModule createOrUpdate() throws Exception {
        if (this.dummy != this.selectedModule) {
            if (!this.getContent().toDelete.isEmpty() || !this.getContent().toInstall.isEmpty()) {
                HashSet<String> toDelete = new HashSet<String>();
                for (String s : this.getContent().toDelete) {
                    toDelete.add(s);
                }
                HashSet<URL> toInstall = new HashSet<URL>();
                for (String s : this.getContent().toInstall.keySet()) {
                    toInstall.add(this.getContent().toInstall.get(s).toURI().toURL());
                }
                this.classLoaderProvider.closeClassLoader(this.selectedModule.getModuleName());
                this.moduleService.updateUserFiles(toInstall, toDelete, this.selectedModule.getModuleName(), true);
            }
            return this.moduleService.getModule(this.selectedModule.getModuleName());
        }
        this.dummy.name = this.name;
        HashSet<URL> toInstall = new HashSet<URL>();
        for (File f : this.getContent().toInstall.values()) {
            toInstall.add(f.toURI().toURL());
        }
        IModuleService.IModuleInstallationInfo moduleInstaller = this.provider.createIntaller(this.getSelectedBaseModule(), this.extension, toInstall);
        IModuleService.IModule l = this.moduleService.createModule(this.getSelectedModule().getModuleName(), moduleInstaller);
        return l;
    }

    public String getModuleName() {
        if (this.getSelectedModule() instanceof DummyModule) {
            return this.name;
        }
        if (this.getSelectedModule() == null) {
            return this.getSelectedBaseModule().getLabel();
        }
        return this.getSelectedModule().getModuleName();
    }

    public boolean isCreating() {
        return this.createMode;
    }

    public boolean isLibRequiredState() {
        return this.moduleState == ModuleState.LIBS_REQUIRED;
    }

    public IModuleService getModuleService() {
        return this.moduleService;
    }

    public class DummyModule
    implements IModuleService.IModuleDescriptor {
        String name = "<newModule>";
        List<String> gatheredFiles = null;

        public IModuleService.IBaseModuleInfo getBaseModuleInfo() {
            return ModuleControler.this.selectedBaseModule.getInfo();
        }

        public Properties getModuleProperties() {
            return new Properties();
        }

        public String getModuleName() {
            return this.name;
        }

        public List<String> getFileNames() {
            if (this.gatheredFiles == null) {
                this.gatheredFiles = new ArrayList<String>();
                try {
                    this.gatheredFiles.addAll(ModuleControler.this.provider.getProvidedFiles(ModuleControler.this.selectedBaseModule, ModuleControler.this.extension));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return this.gatheredFiles;
        }

        public IModuleService.IBaseModuleInfo getBaseModuleExtensionInfo() {
            return ModuleControler.this.extension == null ? null : ModuleControler.this.extension.getInfo();
        }
    }

    static enum FileState {
        NEW,
        UPDATE,
        DELETE;

    }

    static interface Listener {
        public void handleError(String var1);
    }

    class ModuleContent {
        Set<String> internalFiles = new HashSet<String>();
        Set<String> userFiles = new HashSet<String>();
        HashMap<String, File> toInstall = new HashMap();
        HashSet<String> toDelete = new HashSet();

        ModuleContent() {
        }

        public void initFrom(IModuleService.IModuleDescriptor d) {
            this.internalFiles = new HashSet<String>();
            this.userFiles = new HashSet<String>();
            this.toInstall = new HashMap();
            this.toDelete = new HashSet();
            if (d == null) {
                return;
            }
            this.internalFiles.addAll(d.getFileNames());
        }

        public void initFrom(IModuleService.IModule m) {
            if (m == null) {
                this.internalFiles = new HashSet<String>();
                this.userFiles = new HashSet<String>();
                this.toInstall = new HashMap();
                this.toDelete = new HashSet();
                return;
            }
            this.initFrom(m.getDescriptor());
            try {
                for (URL u : m.getURLs()) {
                    String s = u.toString().substring(u.toString().lastIndexOf("/") + 1);
                    if (this.internalFiles.contains(s)) continue;
                    this.userFiles.add(s);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void addFile(File f) {
            if (this.internalFiles.contains(f.getName())) {
                return;
            }
            this.toInstall.put(f.getName(), f);
        }

        public void addDeletion(String s) {
            if (this.toInstall.remove(s) == null) {
                this.toDelete.add(s);
            }
        }

        public Collection<String> getInternalFiles() {
            return this.internalFiles;
        }

        public Collection<String> getUserFiles() {
            HashSet<String> l = new HashSet<String>();
            l.addAll(this.toInstall.keySet());
            l.addAll(this.userFiles);
            return l;
        }

        public FileState getState(String file) {
            if (this.toInstall.get(file) != null) {
                if (this.userFiles.contains(file)) {
                    return FileState.UPDATE;
                }
                return FileState.NEW;
            }
            if (this.toDelete.contains(file)) {
                return FileState.DELETE;
            }
            return null;
        }
    }

    static enum ModuleState {
        FULL(Messages.ModuleControler_0, new RGB(219, 243, 215), null),
        LIBS_REQUIRED(Messages.ModuleControler_1, new RGB(247, 246, 211), warningIcon),
        LIBS_ADDED(Messages.ModuleControler_2, new RGB(212, 233, 246), infoIcon),
        UNKNOWN(Messages.ModuleControler_3, new RGB(252, 171, 169), errorIcon);

        String message;
        RGB rgb;
        Color col;
        Image icon;

        private ModuleState(String message, RGB color, Image icon) {
            this.message = message;
            this.rgb = color;
            this.icon = icon;
        }

        Color getColor() {
            if (this.col == null) {
                this.col = new Color(null, this.rgb.red, this.rgb.green, this.rgb.blue);
                return this.col;
            }
            return this.col;
        }

        public Image getIcon() {
            return this.icon;
        }
    }

    static interface ModuleStateListener {
        public void handleModuleState();
    }
}

