/*
 * Decompiled with CFR 0.152.
 */
package com.indy.libraries.management.ui.wizard;

import com.indy.engine.core.module.IModuleService;
import com.indy.libraries.management.ui.wizard.Messages;
import com.indy.libraries.management.ui.wizard.ModuleControler;
import com.indy.ui.custom.out.common.properties.AbstractUnboundedControl;
import java.io.File;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ModuleDetailsUI {
    private static final String nodeInnerLibs = Messages.ModuleDetailsUI_0;
    private static final String nodeUserLibs = Messages.ModuleDetailsUI_1;
    private static final String NO_EXTENSION = "--- None ---";
    private Label stateLabel;
    private Text name;
    private ComboViewer extensions;
    private TreeViewer filesViewer;
    private Composite control;
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private ModuleControler controler;

    public ModuleDetailsUI(TabbedPropertySheetWidgetFactory widgetFactory, ModuleControler controler) {
        this.controler = controler;
        this.widgetFactory = widgetFactory;
    }

    protected IModuleService.IModuleDescriptor getData() {
        return this.controler.getSelectedModule();
    }

    public void fillData() {
        this.name.setText(this.controler.getModuleName());
        ArrayList<IModuleService.IBaseModuleExtension> l = new ArrayList<IModuleService.IBaseModuleExtension>(this.controler.getAvailableExtensions(this.controler.getSelectedBaseModule()));
        l.add(0, (IModuleService.IBaseModuleExtension)NO_EXTENSION);
        this.extensions.setInput(l);
        if (this.controler.getSelectedModule() == null || this.controler.getSelectedModule().getBaseModuleExtensionInfo() == null) {
            this.extensions.setSelection((ISelection)new StructuredSelection((Object)NO_EXTENSION));
        } else {
            this.extensions.setSelection((ISelection)new StructuredSelection((Object)NO_EXTENSION));
            if (this.controler.getSelectedModule() != null && this.controler.getSelectedModule().getBaseModuleExtensionInfo() != null) {
                for (Object e : l) {
                    if (!(e instanceof IModuleService.IBaseModuleExtension) || !((IModuleService.IBaseModuleExtension)e).getInfo().getId().equals(this.controler.getSelectedModule().getBaseModuleExtensionInfo().getId())) continue;
                    this.extensions.setSelection((ISelection)new StructuredSelection(e));
                    break;
                }
            }
        }
        this.filesViewer.setInput((Object)new String[]{nodeInnerLibs, nodeUserLibs});
        this.filesViewer.setComparator(new ViewerComparator());
        boolean bl = this.controler.getSelectedModule() instanceof ModuleControler.DummyModule;
        this.name.setEnabled(bl);
        this.extensions.getControl().setEnabled(bl && l.size() > 1);
        this.updateStateLabel();
    }

    private void updateStateLabel() {
        ModuleControler.ModuleState state = this.controler.getModuleState();
        this.stateLabel.setText(state.message);
        this.stateLabel.setBackground(state.getColor());
        this.control.layout(true, true);
    }

    public Control createControl(Composite parent) {
        final Composite main = this.widgetFactory.createComposite(parent, 2048);
        main.setLayout((Layout)new GridLayout());
        Composite details = this.widgetFactory.createComposite(main);
        details.setLayoutData((Object)new GridData(4, 4, true, false));
        details.setLayout((Layout)new GridLayout(2, false));
        Label l = this.widgetFactory.createLabel(details, Messages.ModuleDetailsUI_3);
        l.setLayoutData((Object)new GridData(1, 1, false, false));
        this.name = this.widgetFactory.createText(details, "", 2048);
        this.name.setLayoutData((Object)new GridData(4, 1, true, false));
        l = this.widgetFactory.createLabel(details, Messages.ModuleDetailsUI_5);
        l.setLayoutData((Object)new GridData());
        this.extensions = new ComboViewer(this.widgetFactory.createCCombo(details, 8));
        this.extensions.getControl().setLayoutData((Object)new GridData(4, 4, false, false));
        this.extensions.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.extensions.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IModuleService.IBaseModuleExtension) {
                    return ((IModuleService.IBaseModuleExtension)element).getLabel();
                }
                return super.getText(element);
            }
        });
        Composite files = this.widgetFactory.createComposite(main);
        this.stateLabel = new Label(files, 64);
        this.stateLabel.setLayoutData((Object)new GridData(770));
        files.setLayoutData((Object)new GridData(4, 4, true, true));
        files.setLayout((Layout)new GridLayout());
        ToolBar tb = new ToolBar(files, 0x800100);
        tb.setLayoutData((Object)new GridData(4, 1, true, false));
        this.widgetFactory.adapt((Composite)tb);
        this.filesViewer = new TreeViewer(this.widgetFactory.createTree(files, 68352));
        this.filesViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.filesViewer.setAutoExpandLevel(-1);
        this.filesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String s = super.getText(element);
                try {
                    s = URLDecoder.decode(s, "UTF-8");
                }
                catch (Exception exception) {}
                return s;
            }

            public Image getImage(Object element) {
                if (element == nodeInnerLibs || element == nodeUserLibs) {
                    return null;
                }
                ModuleControler.FileState st = ModuleDetailsUI.this.controler.getContent().getState((String)element);
                if (st != null) {
                    switch (st) {
                        case DELETE: {
                            return AbstractUnboundedControl.delIcon;
                        }
                        case NEW: {
                            return AbstractUnboundedControl.addIcon;
                        }
                        case UPDATE: {
                            return AbstractUnboundedControl.refreshIcon;
                        }
                    }
                }
                return null;
            }
        });
        this.filesViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public boolean hasChildren(Object element) {
                if (element == nodeInnerLibs) {
                    return !ModuleDetailsUI.this.controler.getContent().getInternalFiles().isEmpty();
                }
                if (element == nodeUserLibs) {
                    return !ModuleDetailsUI.this.controler.getContent().getUserFiles().isEmpty();
                }
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return new String[]{nodeInnerLibs, nodeUserLibs};
            }

            public Object[] getChildren(Object parentElement) {
                Collection<String> c = null;
                if (parentElement == nodeInnerLibs) {
                    c = ModuleDetailsUI.this.controler.getContent().getInternalFiles();
                } else if (parentElement == nodeUserLibs) {
                    c = ModuleDetailsUI.this.controler.getContent().getUserFiles();
                }
                if (c != null) {
                    return c.toArray(new Object[c.size()]);
                }
                return null;
            }
        });
        this.control = main;
        ToolItem add = new ToolItem(tb, 8);
        add.setToolTipText(Messages.ModuleDetailsUI_7);
        add.setImage(AbstractUnboundedControl.addIcon);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(main.getShell(), 2);
                fd.setFilterExtensions(new String[]{"*.jar", "*.*"});
                if (fd.open() != null) {
                    String[] stringArray = fd.getFileNames();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String f = stringArray[n2];
                        ModuleDetailsUI.this.controler.getContent().addFile(new File(fd.getFilterPath() + File.separator + f));
                        ++n2;
                    }
                    ModuleDetailsUI.this.filesViewer.refresh(true);
                    ModuleDetailsUI.this.filesViewer.expandAll();
                    ModuleDetailsUI.this.controler.updateState();
                    ModuleDetailsUI.this.updateStateLabel();
                }
            }
        });
        final ToolItem del = new ToolItem(tb, 8);
        del.setToolTipText(Messages.ModuleDetailsUI_10);
        del.setImage(AbstractUnboundedControl.delIcon);
        del.setEnabled(false);
        del.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Object o : ModuleDetailsUI.this.filesViewer.getStructuredSelection().toList()) {
                    ModuleDetailsUI.this.controler.getContent().addDeletion((String)o);
                }
                ModuleDetailsUI.this.filesViewer.refresh(true);
                ModuleDetailsUI.this.filesViewer.expandAll();
                ModuleDetailsUI.this.controler.updateState();
                ModuleDetailsUI.this.updateStateLabel();
            }
        });
        this.filesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean canDelete = !ModuleDetailsUI.this.filesViewer.getSelection().isEmpty();
                for (Object o : ModuleDetailsUI.this.filesViewer.getStructuredSelection().toList()) {
                    if (ModuleDetailsUI.this.controler.getContent().getUserFiles().contains(o)) continue;
                    canDelete = false;
                    break;
                }
                del.setEnabled(canDelete);
            }
        });
        this.hookListeners();
        return this.getControl();
    }

    private void hookListeners() {
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ModuleDetailsUI.this.controler.getSelectedModule() instanceof ModuleControler.DummyModule) {
                    ModuleDetailsUI.this.controler.setModuleName(ModuleDetailsUI.this.name.getText());
                }
            }
        });
        this.extensions.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (ModuleDetailsUI.this.controler.getSelectedModule() instanceof ModuleControler.DummyModule) {
                    if (event.getSelection().isEmpty()) {
                        ModuleDetailsUI.this.controler.setSelectedExtension(null);
                    } else {
                        Object o = event.getStructuredSelection().getFirstElement();
                        if (o == ModuleDetailsUI.NO_EXTENSION) {
                            ModuleDetailsUI.this.controler.setSelectedExtension(null);
                        } else {
                            ModuleDetailsUI.this.controler.setSelectedExtension((IModuleService.IBaseModuleExtension)o);
                        }
                    }
                    ModuleDetailsUI.this.filesViewer.refresh();
                    ModuleDetailsUI.this.filesViewer.expandAll(true);
                    ModuleDetailsUI.this.updateStateLabel();
                }
            }
        });
    }

    public Composite getControl() {
        return this.control;
    }
}

