/*
 * Decompiled with CFR 0.152.
 */
package com.indy.libraries.management.ui.wizard;

import com.indy.engine.core.module.IModuleService;
import com.indy.libraries.management.ui.wizard.Messages;
import com.indy.libraries.management.ui.wizard.ModuleControler;
import com.indy.libraries.management.ui.wizard.ModuleDetailsUI;
import com.indy.libraries.management.ui.wizard.NiceList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ModuleEditionPage
extends WizardPage {
    NiceList moduleBaseList;
    NiceList moduleList;
    ModuleControler controler;

    public ModuleEditionPage(ModuleControler controler, String pageName) {
        super(pageName);
        this.setTitle(Messages.ModuleEditionPage_0);
        this.setDescription(Messages.ModuleEditionPage_1);
        this.controler = controler;
        this.controler.setListener(new ModuleControler.Listener(){

            @Override
            public void handleError(String error) {
                ModuleEditionPage.this.setErrorMessage(error);
                ModuleEditionPage.this.getContainer().updateButtons();
            }
        });
        this.controler.setModuleStateListener(new ModuleControler.ModuleStateListener(){

            @Override
            public void handleModuleState() {
                ModuleEditionPage.this.getContainer().updateButtons();
            }
        });
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.refreshContent();
            Point pt = this.getShell().computeSize(-1, -1);
            if (pt.x > this.getShell().getSize().x) {
                this.getShell().setSize(new Point(pt.x, this.getShell().getSize().y));
            }
        }
    }

    public boolean isPageComplete() {
        return this.getErrorMessage() == null && !this.moduleList.getSelection().isEmpty();
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayoutData((Object)new GridData(1808));
        main.setLayout((Layout)new GridLayout(3, false));
        Label l = new Label(main, 0);
        l.setText(Messages.ModuleEditionPage_2);
        l.setLayoutData((Object)new GridData());
        l = new Label(main, 0);
        l.setText(Messages.ModuleEditionPage_3);
        l.setLayoutData((Object)new GridData());
        l = new Label(main, 0);
        l.setText(Messages.ModuleEditionPage_4);
        l.setLayoutData((Object)new GridData());
        this.moduleBaseList = new NiceList(new NiceList.TextProvider(){

            @Override
            public String getSecondaryText(Object element) {
                return ((IModuleService.IBaseModule)element).getDescription();
            }

            @Override
            public String getMainText(Object element) {
                return ((IModuleService.IBaseModule)element).getLabel() + this.getDecoration(element);
            }

            @Override
            public Color getColor(Object element) {
                return ModuleEditionPage.this.getContainer().getShell().getDisplay().getSystemColor(2);
            }

            private String getDecoration(Object element) {
                int count = ModuleEditionPage.this.controler.getModuleCount((IModuleService.IBaseModule)element);
                return " [" + count + "]";
            }

            @Override
            public Image getIcon(Object element) {
                return null;
            }

            @Override
            public String getTooltip(Object element) {
                return null;
            }
        });
        Control c = this.moduleBaseList.createControl(main, 68096);
        c.setLayoutData((Object)new GridData(4, 4, false, true));
        ((GridData)c.getLayoutData()).minimumWidth = 150;
        ((GridData)c.getLayoutData()).widthHint = 300;
        this.moduleList = new NiceList(new NiceList.TextProvider(){
            HashMap<String, String> cachedExtensionLabels = new HashMap();

            @Override
            public Image getIcon(Object element) {
                if (element instanceof IModuleService.IModuleDescriptor) {
                    ModuleControler.ModuleState s = null;
                    if (ModuleEditionPage.this.moduleList.getSelection().getFirstElement() == element) {
                        s = ModuleEditionPage.this.controler.computeModuleState((IModuleService.IModuleDescriptor)element, ModuleEditionPage.this.controler.content);
                    } else {
                        ModuleControler.ModuleContent c = new ModuleControler.ModuleContent(ModuleEditionPage.this.controler);
                        c.initFrom(ModuleEditionPage.this.controler.getModuleService().getModule(((IModuleService.IModuleDescriptor)element).getModuleName()));
                        s = ModuleEditionPage.this.controler.computeModuleState((IModuleService.IModuleDescriptor)element, c);
                    }
                    if (s != null) {
                        return s.getIcon();
                    }
                }
                return null;
            }

            @Override
            public String getSecondaryText(Object element) {
                StringBuffer b = new StringBuffer();
                IModuleService.IBaseModule base = (IModuleService.IBaseModule)ModuleEditionPage.this.moduleBaseList.getSelection().getFirstElement();
                if (base != null && ((IModuleService.IModuleDescriptor)element).getBaseModuleExtensionInfo() != null) {
                    boolean needLibs = base.expectAdditionalFiles();
                    try {
                        String s = this.cachedExtensionLabels.get(((IModuleService.IModuleDescriptor)element).getBaseModuleExtensionInfo().getId());
                        if (s == null) {
                            for (IModuleService.IBaseModuleExtension e : ModuleEditionPage.this.controler.getAvailableExtensions(base)) {
                                if (!e.getInfo().getId().equals(((IModuleService.IModuleDescriptor)element).getBaseModuleExtensionInfo().getId())) continue;
                                s = e.getLabel();
                                needLibs = needLibs && base.expectAdditionalFiles();
                                break;
                            }
                            this.cachedExtensionLabels.put(((IModuleService.IModuleDescriptor)element).getBaseModuleExtensionInfo().getId(), s);
                        }
                        b.append(s);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                return b.toString();
            }

            @Override
            public String getMainText(Object element) {
                return ((IModuleService.IModuleDescriptor)element).getModuleName();
            }

            @Override
            public Color getColor(Object element) {
                return ModuleEditionPage.this.getContainer().getShell().getDisplay().getSystemColor(2);
            }

            @Override
            public String getTooltip(Object element) {
                if (this.getIcon(element) != null) {
                    return Messages.ModuleEditionPage_7;
                }
                return null;
            }
        });
        c = this.moduleList.createControl(main, 68096);
        c.setLayoutData((Object)new GridData(4, 4, false, true));
        ((GridData)c.getLayoutData()).minimumWidth = 150;
        ((GridData)c.getLayoutData()).widthHint = 200;
        final ModuleDetailsUI details = new ModuleDetailsUI(new TabbedPropertySheetWidgetFactory(), this.controler);
        Control mm = details.createControl(main);
        mm.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)mm.getLayoutData()).minimumWidth = 250;
        ((GridData)mm.getLayoutData()).widthHint = 300;
        this.setControl((Control)main);
        this.moduleBaseList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ModuleEditionPage.this.controler.setSelectedBaseModule((IModuleService.IBaseModule)event.getStructuredSelection().getFirstElement());
                List<IModuleService.IModuleDescriptor> l = ModuleEditionPage.this.controler.getModules4Selection();
                ModuleEditionPage.this.moduleList.setInput(l);
                if (l.size() > 1) {
                    if (ModuleEditionPage.this.controler.isCreating()) {
                        if (l.get(0) instanceof ModuleControler.DummyModule) {
                            ModuleEditionPage.this.moduleList.setSelection(l.get(0));
                        }
                    } else if (l.get(0) instanceof ModuleControler.DummyModule) {
                        ModuleEditionPage.this.moduleList.setSelection(l.get(1));
                    }
                }
                if (ModuleEditionPage.this.controler.getSelectedBaseModule() != null) {
                    ModuleEditionPage.this.controler.setModuleName(ModuleEditionPage.this.controler.getSelectedBaseModule().getLabel());
                }
                ModuleEditionPage.this.moduleList.getViewer().refresh((Object)ModuleEditionPage.this.controler.dummy);
                details.fillData();
                ModuleEditionPage.this.getContainer().updateButtons();
            }
        });
        this.moduleList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    ModuleEditionPage.this.controler.setSelectedModule((IModuleService.IModuleDescriptor)event.getStructuredSelection().getFirstElement());
                    details.fillData();
                }
                ModuleEditionPage.this.getContainer().updateButtons();
            }
        });
    }

    public void refreshContent() {
        this.moduleBaseList.setInput(this.controler.getBaseModules());
        IModuleService.IModuleDescriptor initalSelection = this.controler.getSelectedModule();
        this.controler.getSelectedBaseModule();
        if (!(initalSelection == null || initalSelection instanceof ModuleControler.DummyModule || initalSelection.getBaseModuleInfo().getId().equals("com.indy.baseModule.default") || initalSelection.getBaseModuleInfo().getId().equals("com.indy.baseModule.generic"))) {
            for (IModuleService.IBaseModule m : this.controler.getBaseModules()) {
                if (!m.getInfo().getId().equals(initalSelection.getBaseModuleInfo().getId())) continue;
                this.moduleBaseList.setSelection(m);
                this.moduleList.setSelection(initalSelection);
                return;
            }
            this.moduleList.setInput(Collections.singletonList(initalSelection));
            this.moduleList.setSelection(initalSelection);
        } else if (!this.controler.isEditOrCreate()) {
            for (IModuleService.IBaseModule m : this.controler.getBaseModules()) {
                if (m.getInfo().getId().equals("com.indy.baseModule.default") || m.getInfo().getId().equals("com.indy.baseModule.generic")) continue;
                this.moduleBaseList.setSelection(m);
                break;
            }
        }
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelpResource("com.indy.ui.help.redirects/designer/modules");
    }
}

