/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.custom;

import com.semarchy.xdi.designer.core.capabilities.Capability;
import com.semarchy.xdi.designer.core.capabilities.CreatePropertiesCapability;
import com.semarchy.xdi.designer.core.capabilities.ICapability;
import com.semarchy.xdi.designer.core.capabilities.IMapModelExtension;
import com.semarchy.xdi.designer.core.capabilities.IPropertyExtensionConstants;
import com.semarchy.xdi.designer.core.capabilities.MapModelExtension;
import com.semarchy.xdi.designer.core.utils.MetaInfParserUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetaInfCapabilityParser {
    public static final String ELEMENT_TEMPLATE_FEATURE_SUPPORT = "template-feature-support";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_ENABLE_EXPRESSION = "enable";
    public static final String ATTRIBUTE_EVALUATION = "evaluation";
    public static final String ATTRIBUTE_TARGET_OBJECT = "modifiedObject";
    public static final String ATTRIBUTE_TAG_NAMES = "tagNames";
    public static final String ATTRIBUTE_LEVELS = "levels";
    public static final String ATTRIBUTE_CONDITION = "condition";
    public static final String ATTRIBUTE_TARGETFILTER = "filter";
    public static final String ELEMENT_PROP_DESC = "propertyDescriptor";
    public static final String ATTRIBUTE_PROP_DESC_NAME = "name";
    public static final String ATTRIBUTE_PROP_DESC_VALUE = "value";

    private void removeNodeAndTrailingWhitespace(Node node, Collection<Node> exiles) {
        if (node.getNodeType() == 8 || node.getNodeType() == 3 && node.getTextContent().matches("\\s*")) {
            exiles.add(node);
        } else {
            int i = 0;
            while (i < node.getChildNodes().getLength()) {
                Node n = node.getChildNodes().item(i);
                if (n.getNodeType() == 8 || n.getNodeType() == 3 && n.getTextContent().matches("\\s*")) {
                    exiles.add(n);
                } else {
                    this.removeNodeAndTrailingWhitespace(n, exiles);
                }
                ++i;
            }
        }
    }

    private List<ICapability> parseTemplateFeatureSupport(String metaInf) throws Exception {
        ArrayList<ICapability> capabilities = new ArrayList<ICapability>();
        NodeList nodeList = MetaInfParserUtil.parseMetaInf((String)metaInf, (String)ELEMENT_TEMPLATE_FEATURE_SUPPORT);
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                boolean featureHandled;
                String featureName = ((Element)node).getAttribute("name");
                boolean bl = featureHandled = "load".equals(featureName) || "reject".equals(featureName) || "stagingArea".equals(featureName) || "targetFilter".equals(featureName) || "qualifyFilter".equals(featureName) || "targetColumnsInMappingExpression".equals(featureName);
                if (featureHandled) {
                    String val = ((Element)node).getAttribute(ATTRIBUTE_ENABLE_EXPRESSION);
                    String evaluationMode = ((Element)node).getAttribute(ATTRIBUTE_EVALUATION);
                    ICapability.EvaluationMode mode = ICapability.EvaluationMode.NATIVE;
                    if (evaluationMode != null && !evaluationMode.isEmpty()) {
                        try {
                            mode = ICapability.EvaluationMode.valueOf((String)evaluationMode);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    capabilities.add((ICapability)new Capability(featureName, ELEMENT_TEMPLATE_FEATURE_SUPPORT, val, mode));
                }
            }
            ++i;
        }
        return capabilities;
    }

    private List<ICapability> parsetTemplateModelExtensionSupport(String metaInf) throws Exception {
        ArrayList<ICapability> capabilities = new ArrayList<ICapability>();
        NodeList nodeList = MetaInfParserUtil.parseMetaInf((String)metaInf, (String)"template-mapping-extension");
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                ArrayList<MapModelExtension> createPropertyExtensions = new ArrayList<MapModelExtension>();
                if ("createProperty".equals(((Element)node).getAttribute("name"))) {
                    HashMap propDesc = new HashMap();
                    NodeList propertyNodeList = node.getChildNodes();
                    int j = 0;
                    while (j < propertyNodeList.getLength()) {
                        Node node2 = propertyNodeList.item(j);
                        if (node2 instanceof Element && node2.getNodeName().equals(ELEMENT_PROP_DESC)) {
                            String targetObject = null;
                            String levels = null;
                            String targetFilter = null;
                            String type = null;
                            String unbounded = null;
                            String defaultValue = null;
                            String uiDisplayLabel = null;
                            String uiMultiline = null;
                            String uiTooltipValue = null;
                            String createPropertyNamed = null;
                            createPropertyNamed = ((Element)node2).getAttribute("propertyCode");
                            if (createPropertyNamed != null) {
                                type = ((Element)node2).getAttribute("type");
                                unbounded = ((Element)node2).getAttribute("unbounded");
                                defaultValue = ((Element)node2).getAttribute("defaultValue");
                                NodeList l = node2.getChildNodes();
                                HashMap<Object, String> additionalProperties = new HashMap<Object, String>();
                                StringBuffer comboHelper = new StringBuffer();
                                int k = 0;
                                while (k < l.getLength()) {
                                    Node _p = l.item(k);
                                    if (_p instanceof Element && _p.getNodeName().equals("comboHelper")) {
                                        String propertyName = ((Element)_p).getAttribute("label");
                                        String propertyValue = ((Element)_p).getAttribute(ATTRIBUTE_PROP_DESC_VALUE);
                                        if (propertyValue != null) {
                                            if (comboHelper.length() > 0) {
                                                comboHelper.append(";");
                                            }
                                            if (propertyName != null) {
                                                comboHelper.append(propertyName);
                                                comboHelper.append(":");
                                            }
                                            comboHelper.append(propertyValue);
                                        }
                                    } else if (_p instanceof Element && _p.getNodeName().equals("ui")) {
                                        uiDisplayLabel = ((Element)_p).getAttribute("displaylabel");
                                        uiMultiline = ((Element)_p).getAttribute("multiline");
                                        uiTooltipValue = ((Element)_p).getAttribute("tooltipValue");
                                    } else if (_p instanceof Element && _p.getNodeName().equals(ATTRIBUTE_TARGETFILTER)) {
                                        targetObject = ((Element)_p).getAttribute(ATTRIBUTE_TARGET_OBJECT);
                                        levels = ((Element)_p).getAttribute(ATTRIBUTE_LEVELS);
                                        targetFilter = ((Element)_p).getAttribute(ATTRIBUTE_TARGETFILTER);
                                    }
                                    ++k;
                                }
                                if (comboHelper.length() > 0) {
                                    additionalProperties.put(IPropertyExtensionConstants.LIST_VALUES, comboHelper.toString());
                                }
                                additionalProperties.put("capability.propertyInjection.propertyCode", createPropertyNamed);
                                propDesc.put(createPropertyNamed, additionalProperties);
                                boolean supportSrc = true;
                                boolean supportTrg = true;
                                if (targetFilter != null) {
                                    if (targetFilter.equalsIgnoreCase("TRG")) {
                                        supportSrc = false;
                                    } else if (targetFilter.equalsIgnoreCase("SRC")) {
                                        supportTrg = false;
                                    }
                                }
                                additionalProperties.put("capability.propertyInjection.defaultValue", defaultValue);
                                additionalProperties.put("capability.propertyInjection.displayLabel", uiDisplayLabel);
                                additionalProperties.put("capability.propertyInjection.uiMultiline", uiMultiline);
                                additionalProperties.put("capability.propertyInjection.tooltip", uiTooltipValue);
                                additionalProperties.put("capability.propertyInjection.unbounded", unbounded);
                                additionalProperties.put("capability.propertyInjection.type", type);
                                createPropertyExtensions.add(new MapModelExtension(createPropertyNamed, IMapModelExtension.TargetObjectType.valueOf((String)targetObject.toUpperCase()), levels != null && !levels.trim().isEmpty() ? levels.split(";") : new String[]{}, supportSrc, supportTrg, additionalProperties));
                            }
                        }
                        ++j;
                    }
                    CreatePropertiesCapability delegate = new CreatePropertiesCapability("createProperty", "template-mapping-extension", null);
                    for (IMapModelExtension iMapModelExtension : createPropertyExtensions) {
                        delegate.addDelegate(iMapModelExtension);
                    }
                    capabilities.add((ICapability)delegate);
                }
            }
            ++i;
        }
        return capabilities;
    }

    public List<ICapability> parseMetaInf(String metaInf) throws Exception {
        ArrayList<ICapability> capabilities = new ArrayList<ICapability>();
        if (metaInf.contains("<template-feature-support")) {
            capabilities.addAll(this.parseTemplateFeatureSupport(metaInf));
        }
        if (metaInf.contains("<template-mapping-extension")) {
            capabilities.addAll(this.parsetTemplateModelExtensionSupport(metaInf));
        }
        return capabilities;
    }
}

