/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.impl.custom;

import com.indy.gmf.proc.ActionProcess;
import com.indy.gmf.proc.custom.MetaInfCapabilityParser;
import com.semarchy.xdi.designer.core.capabilities.ICapability;
import com.semarchy.xdi.designer.core.capabilities.ICapabilityProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CapabillityProviderHelper
implements ICapabilityProvider {
    private List<ICapability> capabilities = null;
    private ActionProcess actionProcess;

    CapabillityProviderHelper(ActionProcess actionProcess) {
        this.actionProcess = actionProcess;
    }

    public ICapability getCapability(String category, String name) {
        if (this.capabilities == null) {
            this.loadCapabilities();
        }
        for (ICapability c : this.capabilities) {
            if (!c.getCategory().equals(category) || !c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    private void loadCapabilities() {
        this.capabilities = new ArrayList<ICapability>();
        String metaInf = this.actionProcess.getMetaInf();
        if (metaInf == null || metaInf.trim().equals("")) {
            return;
        }
        MetaInfCapabilityParser parser = new MetaInfCapabilityParser();
        try {
            this.capabilities.addAll(parser.parseMetaInf(metaInf));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Collection<ICapability> getCapabilities(String category) {
        if (this.capabilities == null) {
            this.loadCapabilities();
        }
        ArrayList<ICapability> l = new ArrayList<ICapability>();
        for (ICapability c : this.capabilities) {
            if (!c.getCategory().equals(category)) continue;
            l.add(c);
        }
        return l;
    }

    public void clear() {
        this.capabilities = null;
    }
}

