/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.utils;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IMessage;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.IMessagePrefixProvider;

public class FormMessageWrapper
implements IMessageManager {
    private IMessageManager mmng;
    private Map<String, Map<String, String>> messages;
    private String currentMessageProvider;

    public boolean containsKey(String key) {
        Map<String, String> message;
        return this.messages.containsKey(this.currentMessageProvider) && (message = this.messages.get(this.currentMessageProvider)).containsKey(key);
    }

    public FormMessageWrapper(IMessageManager mmng) {
        this.mmng = mmng;
        this.messages = new HashMap<String, Map<String, String>>();
        this.currentMessageProvider = "";
    }

    public void setCurrentMessageProvider(String providerName) {
        this.currentMessageProvider = providerName;
        this.mmng.removeAllMessages();
        Map<String, String> currentMessages = this.messages.get(this.currentMessageProvider);
        if (currentMessages != null) {
            for (String key : currentMessages.keySet()) {
                this.mmng.addMessage((Object)key, currentMessages.get(key), null, 3);
            }
        }
    }

    public void addMessage(Object key, String messageText, Object data, int type) {
        HashMap<String, String> message = new HashMap<String, String>();
        message.put((String)key, messageText);
        this.messages.put(this.currentMessageProvider, message);
        this.mmng.addMessage(key, messageText, data, type);
    }

    public void addMessage(Object key, String messageText, Object data, int type, Control control) {
        HashMap<String, String> message = new HashMap<String, String>();
        message.put((String)key, messageText);
        this.messages.put(this.currentMessageProvider, message);
        this.mmng.addMessage(key, messageText, data, type, control);
    }

    public void removeMessage(Object key) {
        Map<String, String> message;
        if (this.messages.containsKey(this.currentMessageProvider) && (message = this.messages.get(this.currentMessageProvider)).containsKey(key)) {
            message.remove(key);
        }
        this.mmng.removeMessage(key);
    }

    public void removeMessages() {
        this.mmng.removeAllMessages();
    }

    public void removeMessage(Object key, Control control) {
        this.mmng.removeMessage(key, control);
    }

    public void removeMessages(Control control) {
        this.mmng.removeMessage((Object)control);
    }

    public void removeAllMessages() {
        this.mmng.removeAllMessages();
        this.messages.clear();
    }

    public void update() {
        this.mmng.update();
    }

    public void setAutoUpdate(boolean enabled) {
        this.mmng.setAutoUpdate(enabled);
    }

    public boolean isAutoUpdate() {
        return this.mmng.isAutoUpdate();
    }

    public void setMessagePrefixProvider(IMessagePrefixProvider provider) {
        this.mmng.setMessagePrefixProvider(provider);
    }

    public IMessagePrefixProvider getMessagePrefixProvider() {
        return this.mmng.getMessagePrefixProvider();
    }

    public void setDecorationPosition(int position) {
        this.mmng.setDecorationPosition(position);
    }

    public int getDecorationPosition() {
        return this.mmng.getDecorationPosition();
    }

    public String createSummary(IMessage[] messages) {
        return this.mmng.createSummary(messages);
    }
}

