/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.tools.binding;

import com.ibm.icu.text.NumberFormat;
import com.stambia.ui.tools.binding.BindingValue;
import java.text.Format;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.conversion.text.NumberToStringConverter;
import org.eclipse.core.databinding.conversion.text.StringToNumberConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class BindingText
extends BindingValue {
    private Text text;

    public BindingText(DataBindingContext ctx, Text text, EObject eObject, EStructuralFeature features, EditingDomain domain) {
        super(ctx, features, domain, eObject);
        this.text = text;
        this.init();
        this.addIntegerConverter();
        this.bind(this.eObject);
    }

    public BindingText(DataBindingContext ctx, Text text, EObject eObject, EStructuralFeature features, EditingDomain domain, EMFUpdateValueStrategy targetUpdate, EMFUpdateValueStrategy modelUpdate) {
        super(ctx, features, domain, eObject, targetUpdate, modelUpdate);
        this.text = text;
        this.init();
        this.addIntegerConverter();
        this.bind(this.eObject);
    }

    public BindingText(DataBindingContext ctx, Text text, EObject eObject, EStructuralFeature features, EditingDomain domain, IConverter targetConverter, IConverter modelConverter) {
        super(ctx, features, domain, eObject);
        this.text = text;
        this.init();
        this.setTargetConverter(targetConverter);
        this.setModelConverter(modelConverter);
        this.bind(this.eObject);
    }

    private void addIntegerConverter() {
        if (this.features.getEType().getInstanceTypeName().equals(Integer.TYPE.toString())) {
            NumberFormat nf = NumberFormat.getIntegerInstance();
            nf.setGroupingUsed(false);
            NumberToStringConverter.fromInteger((Format)nf, (boolean)true);
            this.setTargetConverter((IConverter)StringToNumberConverter.toInteger((boolean)true));
            this.setModelConverter((IConverter)NumberToStringConverter.fromInteger((Format)nf, (boolean)true));
        }
    }

    private void init() {
        IWidgetValueProperty prop = WidgetProperties.text((int)24);
        this.setTarget((IObservableValue)prop.observeDelayed(300, (Widget)this.text));
        this.setModel(EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)this.features).observe((Object)this.eObject));
    }

    @Override
    protected void updateModel() {
        this.setModel(EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)this.features).observe((Object)this.eObject));
    }
}

