/*
 * Decompiled with CFR 0.152.
 */
package com.indy.osgihook;

import com.indy.osgihook.FilteredBundleCopier;
import com.indy.osgihook.utils.JavaProps;
import com.indy.osgihook.utils.StambiaEnvironmentPropertyReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.eclipse.osgi.storage.bundlefile.DirBundleFile;

public class ExternalJarHook {
    public static final String KEY = ExternalJarHook.class.getName();
    public static final int HASHCODE = KEY.hashCode();
    static String stambiaRuntimeDir;
    static String stambiaModuleFolder;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private EquinoxConfiguration configuration;
    public static List protectionRules;
    static FileWriter fw;

    static {
        protectionRules = new ArrayList();
        fw = null;
    }

    private String getStambiaRuntimeHome() {
        String stambiaRuntimeHome = StambiaEnvironmentPropertyReader.readProperty(JavaProps.RUNTIME_HOME, (EnvironmentInfo)this.configuration);
        this.logger.info("runtime.home=" + stambiaRuntimeHome);
        if (new File(stambiaRuntimeHome).isAbsolute()) {
            this.logger.info("RuntimeHome is absolute");
            return stambiaRuntimeHome;
        }
        this.logger.info("RuntimeHome is relative");
        File file = null;
        String eclipseLauncher = this.configuration.getProperty("eclipse.launcher");
        this.logger.info("eclipse.launcher=" + eclipseLauncher);
        if (eclipseLauncher == null) {
            try {
                URL url = new URL(this.configuration.getProperty("osgi.framework").replace(" ", "%20").replace("&", "%26"));
                file = new File(url.toURI());
                this.logger.info("initialized RuntimeHome from osgi.framework property");
                this.logger.info("osgi.framework=" + String.valueOf(url.toURI()));
                file = file.getParentFile();
            }
            catch (Throwable ex) {
                Logger.getLogger(ExternalJarHook.class.getName()).log(Level.WARNING, "Unexpected", ex);
            }
        } else {
            this.logger.info("initialized RuntimeHome from eclipse.launcher property");
            this.logger.info("eclipse.launcher=" + eclipseLauncher);
            file = new File(eclipseLauncher);
        }
        return file.getParentFile().getAbsolutePath() + File.separator + stambiaRuntimeHome + File.separator;
    }

    public ExternalJarHook(EquinoxConfiguration configuration) {
        this.configuration = configuration;
        this.logger.info("Hook creating");
        String stambiaInitRuntime = configuration.getProperty("stambia.init.runtime");
        stambiaRuntimeDir = this.getStambiaRuntimeHome();
        stambiaModuleFolder = this.initModuleFolder();
        this.logger.info("RuntimeDir=" + stambiaRuntimeDir);
        this.logger.info("ModuleDir=" + stambiaModuleFolder);
        Object runtimeModulePath = StambiaEnvironmentPropertyReader.readProperty(JavaProps.MODULES_FOLDER, (EnvironmentInfo)configuration);
        if (runtimeModulePath == null || ((String)runtimeModulePath).trim().isEmpty()) {
            stambiaModuleFolder = runtimeModulePath = stambiaRuntimeDir + File.separator + "modules";
            System.setProperty(JavaProps.MODULES_FOLDER.label(), (String)runtimeModulePath);
        }
        this.logger.info("module.path=" + (String)runtimeModulePath);
        File fToDir = new File(stambiaRuntimeDir);
        if (!fToDir.exists()) {
            if (fToDir.mkdir()) {
                this.logger.info("created Folder " + String.valueOf(fToDir));
            } else {
                this.logger.info("WARNING --> NOT created Folder " + String.valueOf(fToDir));
            }
        } else {
            this.logger.info("RuntimeDir=" + stambiaRuntimeDir + " already exists");
        }
        File protectionRulesFile = new File(stambiaRuntimeDir + "/properties/protection.rules");
        ExternalJarHook.logln("Start");
        this.logger.info("Start should be logged by hook logger");
        this.logger.info("Is 'stambia.init.runtime' property setted ? " + stambiaInitRuntime);
        this.logger.info("Is the protection.rules file exists ? " + protectionRulesFile.exists());
        if (stambiaInitRuntime == null && protectionRulesFile.exists()) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (BufferedReader in = new BufferedReader(new FileReader(protectionRulesFile));){
                    String line = "";
                    while (line != null) {
                        line = in.readLine();
                        if (line == null || line.equals("") || line.trim().startsWith("#")) continue;
                        ExternalJarHook.logln("Add protection rule: " + line);
                        protectionRules.add(line);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error during reading the protection.rules file: " + String.valueOf(protectionRulesFile), e);
            }
        }
        this.logger.info("Hook created");
    }

    private String initModuleFolder() {
        String modulePath = StambiaEnvironmentPropertyReader.readProperty(JavaProps.MODULES_FOLDER, (EnvironmentInfo)this.configuration);
        if (modulePath == null) {
            modulePath = "modules";
        }
        File f = new File(modulePath);
        return f.getAbsolutePath();
    }

    public static void logln(String str) {
        ExternalJarHook.log(str + "\n");
    }

    public static void log(String str) {
        Date maintenant = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String dateDuJour = formatter.format(maintenant);
        if (fw == null && stambiaRuntimeDir != null) {
            try {
                File logDir = new File(stambiaRuntimeDir + "/log");
                if (!logDir.exists()) {
                    logDir.mkdir();
                }
                fw = new FileWriter(stambiaRuntimeDir + "/log/com.indy.osgihook.log");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            fw.write(dateDuJour + " " + str);
            fw.flush();
        }
        catch (IOException e) {
            Logger.getLogger(ExternalJarHook.class.getName()).log(Level.WARNING, "Unexpected", e);
        }
    }

    public static boolean comparePattern(String file, String pattern) {
        String _file;
        String string = _file = file != null ? file.trim() : file;
        if (_file != null && pattern != null && !pattern.equals("")) {
            _file = _file.replace(" ", "%20").replace("&", "%26");
            String regexpPattern = pattern.replaceAll("\\?", ".").replaceAll("\\*", ".*");
            if (!regexpPattern.startsWith("/")) {
                if (_file.matches(regexpPattern)) {
                    return true;
                }
            } else {
                try {
                    Object normalize = new URI(_file).normalize().getPath();
                    if (!((String)normalize).startsWith("/")) {
                        normalize = "/" + (String)normalize;
                    }
                    String fileName = ((String)normalize).substring(((String)normalize).lastIndexOf("/") + 1);
                    String parentPath = ((String)normalize).substring(0, ((String)normalize).lastIndexOf("/"));
                    String parentExcludePath = regexpPattern.substring(0, regexpPattern.lastIndexOf("/"));
                    String regexpPattern2 = regexpPattern.substring(regexpPattern.lastIndexOf("/") + 1);
                    if (parentExcludePath.equals(parentPath) && fileName.matches(regexpPattern2)) {
                        return true;
                    }
                }
                catch (URISyntaxException e) {
                    Logger.getLogger(ExternalJarHook.class.getName()).log(Level.WARNING, "Unexpected", e);
                }
            }
        }
        return false;
    }

    public static boolean isProtected(String file) {
        int i = 0;
        while (i < protectionRules.size()) {
            String protectionPattern = protectionRules.get(i).toString();
            if (ExternalJarHook.comparePattern(file, protectionPattern)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static URI extractBundle(String jarFileName, BundleFile bundleFile, String params, boolean useProtectionRules) throws Exception {
        ParamsParser paramsParser = new ParamsParser(params);
        paramsParser.parse();
        String destinationFolder = paramsParser.get("todir");
        Object fName = paramsParser.get("name");
        boolean toModuleFolder = paramsParser.contains("toModuleCoreFolder");
        if (fName == null) {
            fName = jarFileName;
        }
        if (!((String)fName).endsWith(".jar")) {
            fName = (String)fName + ".jar";
        }
        Object is = null;
        Object os = null;
        File runtimeFolder = new File(stambiaRuntimeDir);
        File _destFolder = null;
        if (toModuleFolder) {
            _destFolder = new File(stambiaModuleFolder + "/core");
            _destFolder.mkdirs();
        } else {
            _destFolder = new File(destinationFolder);
        }
        File outF = null;
        outF = !_destFolder.isAbsolute() ? new File(stambiaRuntimeDir + File.separator + destinationFolder + File.separator + (String)fName) : new File(_destFolder, (String)fName);
        if (useProtectionRules && outF.exists()) {
            try {
                Path pathRelativeToFuntime = runtimeFolder.toPath().relativize(outF.toPath());
                if (ExternalJarHook.isProtected("/" + pathRelativeToFuntime.toString().replace("\\", "/"))) {
                    return outF.toURI();
                }
            }
            catch (IllegalArgumentException ex) {
                StringWriter w = new StringWriter();
                ex.printStackTrace(new PrintWriter(w));
                ExternalJarHook.logln(w.toString());
            }
        }
        Path bundlePath = null;
        bundlePath = bundleFile instanceof DirBundleFile ? Paths.get(bundleFile.getBaseFile().toPath().toString(), "bin") : bundleFile.getBaseFile().toPath();
        FilteredBundleCopier copier = new FilteredBundleCopier(bundlePath, outF.toPath());
        try {
            outF.getParentFile().mkdirs();
            copier.copy();
            return outF.toURI();
        }
        catch (Exception ex) {
            throw new Exception(String.format("Failed to extract bundlefile %s into %s", bundleFile.getBaseFile(), outF), ex);
        }
    }

    public static boolean deleteFile(File path) {
        if (path.exists()) {
            if (path.isDirectory()) {
                File[] files = path.listFiles();
                int i = 0;
                while (i < files.length) {
                    ExternalJarHook.deleteFile(files[i]);
                    ++i;
                }
            }
            return path.delete();
        }
        return false;
    }

    public static File getDirectory(File parent, String path) {
        if (path != null) {
            final String tmp = path.contains("/") ? path.substring(0, path.indexOf("/") - 1) : path;
            String tmp2 = path.contains("/") ? path.substring(path.indexOf("/") + 1) : null;
            File[] files = parent.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && pathname.getName().equals(tmp);
                }
            });
            if (files.length == 1) {
                if (tmp2 != null) {
                    return ExternalJarHook.getDirectory(files[0], path);
                }
                return files[0];
            }
            return null;
        }
        return parent;
    }

    public static void copy(InputStream src, OutputStream dst) throws IOException {
        int len;
        InputStream in = src;
        OutputStream out = dst;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.close();
    }

    public static void copyWithoutCarriageReturn(InputStream src, OutputStream dst) throws IOException {
        InputStream in = src;
        OutputStream out = dst;
        int current = -1;
        while ((current = in.read()) > 0) {
            if (current == 13) continue;
            out.write(current);
        }
        in.close();
        out.close();
    }

    public static void copyAddCarriageReturn(InputStream src, OutputStream dst) throws IOException {
        InputStream in = src;
        OutputStream out = dst;
        int current = -1;
        int previous = -1;
        while ((current = in.read()) > 0) {
            if (current == 10 && previous != 13) {
                out.write(13);
            }
            out.write(current);
            previous = current;
        }
        in.close();
        out.close();
    }

    private static class ParamsParser {
        private static final String DASH = "-";
        private static final String SPACE = " ";
        private static final String QUOTE = "\"";
        private String params;
        Map<String, String> parsedParams = new HashMap<String, String>();

        ParamsParser(String params) {
            this.params = params;
        }

        private void parse() {
            this.parse(new StringBuffer(this.params));
        }

        private void parse(StringBuffer params) {
            int index = params.indexOf(DASH);
            if (index > -1) {
                params.delete(0, index + 1);
                index = params.indexOf(SPACE);
                String paramName = params.substring(0, index);
                this.parsedParams.putIfAbsent(paramName, null);
                params.delete(0, index + 1);
                if (params.indexOf(DASH) != 0) {
                    String indexDelim = SPACE;
                    if (params.indexOf(QUOTE) == 0) {
                        indexDelim = QUOTE;
                        params.delete(0, 1);
                    }
                    if ((index = params.indexOf(indexDelim)) == -1) {
                        index = params.length();
                    }
                    String paramValue = params.substring(0, index);
                    this.parsedParams.replace(paramName, paramValue);
                    params.delete(0, index + 1);
                }
                this.parse(params);
            }
        }

        private boolean contains(String paramName) {
            return this.parsedParams.containsKey(paramName);
        }

        private String get(String paramName) {
            return this.parsedParams.getOrDefault(paramName, null);
        }
    }
}

