/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.util;

import com.semarchy.xdi.designer.core.models.EMFResourceOptions;
import com.semarchy.xdi.designer.core.models.IndyXMLResource;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.registry.TechExtension;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.md.custom.Util;
import com.stambia.md.util.EObjectMerger;
import com.stambia.md.util.MergeRulesImpl;
import com.stambia.md.util.Messages;
import com.stambia.md.util.TechMessageProvider;
import com.stambia.tech.Level;
import com.stambia.tech.Tech;
import com.stambia.tech.TechPackage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class TechMerger {
    private static List<EStructuralFeature> externalizedFeatures = Arrays.asList(TechPackage.eINSTANCE.getAction_DisplayName(), TechPackage.eINSTANCE.getLevel_DisplayName(), TechPackage.eINSTANCE.getMessageEntry_Value(), TechPackage.eINSTANCE.getProperty_Category(), TechPackage.eINSTANCE.getProperty_DisplayName(), TechPackage.eINSTANCE.getProperty_ToolTip(), TechPackage.eINSTANCE.getPropertyPage_PageName(), TechPackage.eINSTANCE.getTech_Description(), TechPackage.eINSTANCE.getTech_Name(), TechPackage.eINSTANCE.getValue_Name());
    private Map<String, Set<String>> childParent;
    private TreeMap<String, Set<String>> parentChildren;
    private Tech tech;
    private IndyXMLResource resource;
    private IRegistryService registryService;
    private ICacheService cacheService;
    private Set<String> listenedResourcesId = new HashSet<String>();
    private Logger logger = LogManager.getLogger(TechMerger.class);

    public TechMerger(IndyXMLResource resource) {
        Assert.isNotNull((Object)resource);
        if (!"md".equals(resource.getURI().fileExtension()) && !"tech".equals(resource.getURI().fileExtension())) {
            throw new IllegalArgumentException(Messages.TechMerger_1);
        }
        this.resource = resource;
        this.registryService = (IRegistryService)E4InjectorHelper.getService(IRegistryService.class);
        this.cacheService = (ICacheService)E4InjectorHelper.getService(ICacheService.class);
    }

    protected ResourceSet getResourceSet() {
        return this.resource.getResourceSet();
    }

    public Map<String, Set<String>> getChildParent() {
        return this.childParent;
    }

    public TreeMap<String, Set<String>> getParentChildren() {
        return this.parentChildren;
    }

    public Tech getTech() {
        return this.tech;
    }

    public void clear() {
        this.tech = null;
        if (this.childParent != null) {
            this.childParent.clear();
        }
        if (this.parentChildren != null) {
            this.parentChildren.clear();
        }
    }

    public void refreshTech() {
        if (this.tech == null || this.tech.eIsProxy()) {
            block25: {
                this.tech = null;
                this.listenedResourcesId.clear();
                this.childParent = new TreeMap<String, Set<String>>();
                this.parentChildren = new TreeMap();
                if (this.getResourceSet() == null) {
                    return;
                }
                List<URI> techURIs = Util.getAllTechBasedFile((Resource)this.resource);
                HashMap appendedTechExtensions = new HashMap();
                for (URI uri : techURIs) {
                    appendedTechExtensions.put(uri, new ArrayList());
                    this.listenedResourcesId.add(this.cacheService.getSourceId(uri));
                    Resource r = this.getResourceSet().getResource(uri, true);
                    EcoreUtil.resolveAll((Resource)r);
                    Tech currentTech = (Tech)((EObject)r.getContents().get(0)).eContents().get(0);
                    this.appendExtensions(currentTech, (List)appendedTechExtensions.get(uri));
                    for (Level child : currentTech.getLevel()) {
                        Set<String> parents = this.childParent.get(child.getCode());
                        if (parents == null) {
                            parents = new TreeSet<String>();
                            this.childParent.put(child.getCode(), parents);
                        }
                        for (String parent : child.getParent()) {
                            Set<String> children = this.parentChildren.get(parent);
                            if (children == null) {
                                children = new TreeSet<String>();
                                this.parentChildren.put(parent, children);
                            }
                            children.add(child.getCode());
                        }
                    }
                    if (this.tech == null) {
                        this.tech = (Tech)EcoreUtil.copy((EObject)currentTech);
                        this.tech.getAppendedExtensions().addAll(currentTech.getAppendedExtensions());
                        continue;
                    }
                    this.tech = (Tech)EObjectMerger.merge((EObject)this.tech, (EObject)currentTech, MergeRulesImpl.INSTANCE);
                    this.tech.getAppendedExtensions().addAll(currentTech.getAppendedExtensions());
                }
                try {
                    if (this.getResourceSet().getLoadOptions().get(EMFResourceOptions.LOAD_OPTION_NO_EXTERNAIZATION_LOADING) == Boolean.TRUE) break block25;
                    Collections.reverse(techURIs);
                    try {
                        ArrayList<URI> curr = new ArrayList<URI>(techURIs);
                        curr.stream().filter(u -> !((List)appendedTechExtensions.get(u)).isEmpty()).forEach(techURI -> {
                            List l = (List)appendedTechExtensions.get(techURI);
                            techURIs.addAll(techURIs.indexOf(techURI) + 1, l);
                        });
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    TechMessageProvider messageProvider = new TechMessageProvider(techURIs);
                    TreeIterator it = this.tech.eAllContents();
                    while (it.hasNext()) {
                        EObject o = (EObject)it.next();
                        o.eSetDeliver(false);
                        try {
                            for (EAttribute a : o.eClass().getEAllAttributes()) {
                                if (!externalizedFeatures.contains(a)) continue;
                                try {
                                    String v = messageProvider.getMessage(o, (EStructuralFeature)a);
                                    if (v != null) {
                                        if (v.isEmpty()) continue;
                                        o.eSet((EStructuralFeature)a, (Object)v);
                                        continue;
                                    }
                                    if (!this.logger.isDebugEnabled()) continue;
                                    this.logger.warn("Missing externalization key {} for tech {}", (Object)messageProvider.getMessageKey(o, (EStructuralFeature)a), (Object)this.tech.getId());
                                }
                                catch (Exception v) {
                                    // empty catch block
                                }
                            }
                        }
                        finally {
                            o.eSetDeliver(true);
                        }
                    }
                }
                catch (Exception messageProvider) {
                    // empty catch block
                }
            }
            if (this.tech != null) {
                for (Level l : this.tech.getLevel()) {
                    if (l.getSuperLevel() == null || l.getSuperLevel().isEmpty()) continue;
                    Level superLvl = this.tech.getLevel(l.getSuperLevel());
                    Level newLvl = (Level)EObjectMerger.merge((EObject)l, (EObject)superLvl, MergeRulesImpl.INSTANCE);
                    Set<String> parents = this.childParent.get(newLvl.getCode());
                    if (parents == null) {
                        parents = new TreeSet<String>();
                        this.childParent.put(newLvl.getCode(), parents);
                    }
                    for (String parent : newLvl.getParent()) {
                        Set<String> children = this.parentChildren.get(parent);
                        if (children == null) {
                            children = new TreeSet<String>();
                            this.parentChildren.put(parent, children);
                        }
                        children.add(newLvl.getCode());
                    }
                }
            }
        }
    }

    private boolean appendExtensions(Tech tech, List<URI> appendedTechExtURI) {
        if (this.registryService == null) {
            return false;
        }
        IRegistryService.IRegistry reg = this.registryService.getRegistry(TechExtension.class);
        List exts = reg.find((IRegistryService.IRegistryMatcher)new TechExtension.TechExtensionMatcher(tech.getId()));
        Collections.sort(exts, (o1, o2) -> Integer.compare(o1.getPriority(), o2.getPriority()));
        boolean appended = false;
        if (exts != null) {
            for (TechExtension ext : exts) {
                URI uri = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(ext.getRegistrationKey().getProviderFileID());
                if (uri != null) {
                    appendedTechExtURI.add(uri);
                    Resource r = this.getResourceSet().getResource(uri, true);
                    EcoreUtil.resolveAll((Resource)r);
                    Tech extensionTech = (Tech)((EObject)r.getContents().get(0)).eContents().get(0);
                    if (this.appendExtensions(extensionTech, appendedTechExtURI)) {
                        tech.getAppendedExtensions().addAll(extensionTech.getAppendedExtensions());
                    }
                    tech = (Tech)EObjectMerger.merge((EObject)tech, (EObject)extensionTech, MergeRulesImpl.INSTANCE);
                    tech.getAppendedExtensions().add(ext.getRegistrationKey().getProviderFileID());
                    appended = true;
                    continue;
                }
                this.logger.debug(Messages.TechMerger_2);
            }
        }
        return appended;
    }

    public boolean tracks(Collection<String> changedResourceIds) {
        return changedResourceIds != null && !Collections.disjoint(this.listenedResourcesId, changedResourceIds);
    }
}

