/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.cfc.internal;

import com.semarchy.xdi.designer.core.services.IEvaluationConfigurationService;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={IEvaluationConfigurationService.class})
public class EvaluationConfigurationService
implements IEvaluationConfigurationService {
    private static final String BUILD_BUNDLE_ID = "com.indy.ui.build";
    private static final String PREF_CONF_NAME = "confPreference";
    private Set<IEvaluationConfigurationService.IConfigurationChangeListener> listeners = Collections.synchronizedSet(new LinkedHashSet());
    private String currentConfName;
    private IEclipsePreferences buildPreferences;

    @Activate
    public void activate() {
        this.buildPreferences = InstanceScope.INSTANCE.getNode(BUILD_BUNDLE_ID);
        this.currentConfName = this.buildPreferences.get(PREF_CONF_NAME, "Default value");
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    public void addListener(IEvaluationConfigurationService.IConfigurationChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IEvaluationConfigurationService.IConfigurationChangeListener listener) {
        this.listeners.remove(listener);
    }

    public String getCurrentConfigurationName() {
        return this.currentConfName;
    }

    public void setCurrentConfigurationName(String configuration, boolean notify) {
        String old = this.currentConfName;
        this.currentConfName = configuration;
        if (configuration == null) {
            this.buildPreferences.remove(PREF_CONF_NAME);
        } else {
            this.buildPreferences.put(PREF_CONF_NAME, this.currentConfName);
        }
        if (notify) {
            this.notifyListeners(old, configuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(String oldName, String newName) {
        LinkedHashSet<IEvaluationConfigurationService.IConfigurationChangeListener> listeners = null;
        Set<IEvaluationConfigurationService.IConfigurationChangeListener> set = this.listeners;
        synchronized (set) {
            listeners = new LinkedHashSet<IEvaluationConfigurationService.IConfigurationChangeListener>(this.listeners);
        }
        listeners.forEach(l -> SafeRunner.run(() -> l.configurationChanged(oldName, newName)));
    }
}

