/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.commands.semantic;

import com.indy.gmf.map.diagram.custom.edit.parts.ContainerEditPart;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.Map;
import com.indy.map.Template;
import com.indy.map.diagram.edit.parts.DatastoreAliasEditPart;
import com.indy.map.diagram.edit.parts.DatastoreEditPart;
import com.indy.map.diagram.edit.parts.QueryAliasEditPart;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RTargetSet;
import com.indy.map.util.TemplateCapabilityHelper;
import java.util.HashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IServiceLocator;

public class StambiaSourceProvider
extends AbstractSourceProvider
implements ISelectionListener,
IWindowListener {
    public static final String REJECT_SUPPORT = "com.indy.gmf.map.diagram.custom.commands.semantic.datastore.supportReject";
    public static final String DATASTORE_MAPPED = "com.indy.gmf.map.diagram.custom.commands.semantic.datastore.mapped";
    private boolean lastRejectValue = false;
    private boolean isMapped = false;

    public void initialize(IServiceLocator locator) {
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        super.initialize(locator);
    }

    public void dispose() {
        PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
    }

    public java.util.Map getCurrentState() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put(REJECT_SUPPORT, this.lastRejectValue);
        map.put(DATASTORE_MAPPED, this.isMapped);
        return map;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{REJECT_SUPPORT, DATASTORE_MAPPED};
    }

    private boolean isDatastoreTarget(ISelection selection) {
        IStructuredSelection ss = (IStructuredSelection)selection;
        if (ss.isEmpty()) {
            return false;
        }
        if (!(ss.getFirstElement() instanceof IGraphicalEditPart)) {
            return false;
        }
        IGraphicalEditPart gep = (IGraphicalEditPart)ss.getFirstElement();
        if (!(gep instanceof ContainerEditPart || gep instanceof DatastoreAliasEditPart || gep instanceof QueryAliasEditPart)) {
            return false;
        }
        EObject obj = gep.resolveSemanticElement();
        if (!(obj instanceof IContainer)) {
            if (obj instanceof ILogicalField) {
                obj = obj.eContainer();
            } else {
                return false;
            }
        }
        for (RTargetSet ts : ((RMap)((Map)obj.eContainer()).getMapReference()).getTargetSetRef()) {
            if (!ts.getContainerModel().contains(obj)) continue;
            return true;
        }
        return false;
    }

    private boolean supportReject(ISelection selection) {
        IStructuredSelection ss = (IStructuredSelection)selection;
        if (ss.isEmpty()) {
            return false;
        }
        if (!(ss.getFirstElement() instanceof DatastoreEditPart) && !(ss.getFirstElement() instanceof DatastoreAliasEditPart)) {
            return false;
        }
        EObject obj = ((IGraphicalEditPart)ss.getFirstElement()).resolveSemanticElement();
        if (obj == null || obj.eResource() == null) {
            return false;
        }
        if (!(obj.eContainer() instanceof Map)) {
            return false;
        }
        RTargetSet ts = ((RMap)((Map)obj.eContainer()).getMapReference()).getTargetSetRef((IContainer)obj);
        if (ts != null && !ts.getContainerModel().isEmpty()) {
            Template t = ((Map)obj.eContainer()).getIntegrationTemplate((IContainer)ts.getContainerModel().get(0));
            return TemplateCapabilityHelper.supportCapability((Template)t, (String)"template-feature-support", (String)"reject", (boolean)false);
        }
        return false;
    }

    private void recompute(ISelection selection) {
        boolean reject = this.supportReject(selection);
        if (reject != this.lastRejectValue) {
            this.lastRejectValue = reject;
        }
        this.fireSourceChanged(0, REJECT_SUPPORT, reject);
        boolean mapped = this.isDatastoreTarget(selection);
        if (mapped != this.isMapped) {
            this.isMapped = mapped;
        }
        this.fireSourceChanged(0, DATASTORE_MAPPED, mapped);
    }

    public void windowActivated(IWorkbenchWindow window) {
        window.getSelectionService().addSelectionListener((ISelectionListener)this);
    }

    public void windowDeactivated(IWorkbenchWindow window) {
        window.getSelectionService().removeSelectionListener((ISelectionListener)this);
    }

    public void windowClosed(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part != null && part.getSite() != null && "com.indy.map.diagram.part.MapDiagramEditorID".equals(part.getSite().getId())) {
            this.recompute(selection);
        }
    }
}

