/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.parts;

import com.indy.gmf.map.diagram.custom.edit.parts.JoinLeftDecoration;
import com.indy.gmf.map.diagram.custom.edit.parts.TargetFilterEditPart;
import com.indy.gmf.map.diagram.custom.edit.policies.MappingHighlightingEditPolicy;
import com.indy.gmf.map.diagram.custom.edit.policies.SetEditPolicy;
import com.indy.gmf.map.diagram.custom.figures.BlendableLinkFigure;
import com.indy.gmf.map.diagram.custom.preferences.MapPreferenceConstants;
import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.DataSet;
import com.indy.map.IContainer;
import com.indy.map.IReferencable;
import com.indy.map.Join;
import com.indy.map.JoinLocation;
import com.indy.map.JoinType;
import com.indy.map.SetDescriptor;
import com.indy.map.TargetFilter;
import com.indy.map.api.IMetaDataInformationsProvider;
import com.indy.map.diagram.edit.parts.MapEditPart;
import com.indy.map.diagram.notation.mappingNotation.NodeView;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import com.indy.map.ref.RItem;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RProblem;
import com.indy.map.ref.RTargetSet;
import com.indy.map.util.InheritanceHelper;
import com.indy.ui.custom.out.Activator;
import com.stambia.md.MdNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITreeBranchEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.DiagramColorConstants;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class LinkEditPart
extends ConnectionNodeEditPart
implements ITreeBranchEditPart,
TargetFilterEditPart.AnchorSupport {
    public static final String HINT_JOIN_LINK = "joinLink";
    public static final String HINT_JOIN_DEDUCTED_LINK = "joinDeductedLink";
    public static final String HINT_TARGET_LINK = "targetLink";
    public static final String HINT_TARGET_SET_LINK = "targetSetLink";
    public static final String HINT_TARGET_DATASET_LINK = "targetDataSetLink";
    public static final String HINT_OPERATOR_LINK = "operatorLink";
    private IPropertyChangeListener preferenceListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("targetFilterLocation".equals(event.getProperty())) {
                for (TargetFilterFigureListener l : LinkEditPart.this.targetFiltersListeners) {
                    l.figureMoved(LinkEditPart.this.getFigure());
                }
            }
        }
    };
    private List<TargetFilterFigureListener> targetFiltersListeners = new ArrayList<TargetFilterFigureListener>();

    public LinkEditPart(View view) {
        super(view);
    }

    protected Connection createConnectionFigure() {
        return new LinkFigure();
    }

    public LinkFigure getPrimaryShape() {
        return (LinkFigure)this.getFigure();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.getPrimaryShape().refreshTargetDecoration();
        ((LinkFigure)this.getFigure()).refreshDataSetLinkColoring();
    }

    public void activate() {
        EObject o;
        super.activate();
        MapDiagramEditorPlugin.getInstance().getPreferenceStore().addPropertyChangeListener(this.preferenceListener);
        View v = this.getNotationView();
        if (v != null && HINT_TARGET_DATASET_LINK.equals(v.getType()) && (o = v.getElement()) instanceof DataSet) {
            EObject targetContainer;
            EObject parent = o.eContainer();
            List dataSetHierarchy = InheritanceHelper.getDataSetHierarchy((DataSet)((DataSet)o));
            if (parent instanceof com.indy.map.Map && (targetContainer = ((IGraphicalEditPart)this.getSource()).resolveSemanticElement()) instanceof IContainer) {
                for (TargetFilter f : ((IContainer)targetContainer).getTargetFilter()) {
                    EditPart ep;
                    if (!dataSetHierarchy.contains(f.getDataSet()) || !((ep = this.findTargetFilterEditPart(f, dataSetHierarchy)) instanceof TargetFilterEditPart)) continue;
                    this.attachTargetEditPart((TargetFilterEditPart)ep);
                }
            }
        }
    }

    EditPart findTargetFilterEditPart(TargetFilter f, List<DataSet> hirarchy) {
        MapEditPart mep = (MapEditPart)((Object)this.getRoot().getChildren().get(0));
        for (Object o : mep.getChildren()) {
            NodeView view;
            if (!(o instanceof TargetFilterEditPart) || (view = (NodeView)((TargetFilterEditPart)((Object)o)).getNotationView()).getElement() != f || !hirarchy.contains(view.getSubElement())) continue;
            return (EditPart)o;
        }
        return null;
    }

    @Override
    public void attachTargetEditPart(TargetFilterEditPart ep) {
        TargetFilterFigureListener l = new TargetFilterFigureListener(ep);
        this.targetFiltersListeners.add(l);
        this.getFigure().addFigureListener((FigureListener)l);
        ep.relocateFigure((GraphicalEditPart)this);
    }

    @Override
    public void detachTargetEditPart(TargetFilterEditPart ep) {
        ArrayList<TargetFilterFigureListener> toRemove = new ArrayList<TargetFilterFigureListener>();
        for (TargetFilterFigureListener l : this.targetFiltersListeners) {
            if (l.ep != ep) continue;
            this.getFigure().removeFigureListener((FigureListener)l);
            toRemove.add(l);
        }
        this.targetFiltersListeners.removeAll(toRemove);
    }

    public void deactivate() {
        MapDiagramEditorPlugin.getInstance().getPreferenceStore().removePropertyChangeListener(this.preferenceListener);
        for (TargetFilterFigureListener l : this.targetFiltersListeners) {
            if (l.ep == null || this.getFigure() == null) continue;
            this.getFigure().removeFigureListener((FigureListener)l);
        }
        this.targetFiltersListeners.clear();
        super.deactivate();
    }

    protected void refreshRoutingStyles() {
        super.refreshRoutingStyles();
        Connection connection = this.getConnectionFigure();
        if (!(connection instanceof PolylineConnectionEx)) {
            return;
        }
        PolylineConnectionEx poly = (PolylineConnectionEx)connection;
        poly.setRoutingStyles(true, false);
    }

    public void refreshVisibility() {
        boolean showTargetLink = false;
        boolean showTargetSetLink = false;
        boolean showDataSetLink = false;
        if (MapPreferenceConstants.getBoolean("mapShowSourceSet")) {
            if (MapPreferenceConstants.getBoolean("mapShowDependencies")) {
                showTargetLink = true;
            } else {
                showTargetSetLink = true;
            }
        } else if (MapPreferenceConstants.getBoolean("mapShowDependencies")) {
            showTargetLink = true;
        } else {
            showDataSetLink = true;
        }
        if (showDataSetLink && HINT_TARGET_DATASET_LINK.equals(this.getNotationView().getType())) {
            IContainer target;
            MappingHighlightingEditPolicy policy;
            EditPart mapEditPart = null;
            if (this.getSource() != null) {
                mapEditPart = this.getSource().getParent();
            } else if (this.getTarget() != null) {
                mapEditPart = this.getTarget().getParent();
            }
            if (mapEditPart != null && (policy = (MappingHighlightingEditPolicy)mapEditPart.getEditPolicy((Object)"hightlightMappingRole")) != null && (target = policy.getSelectedTargetContainer()) != null) {
                com.indy.map.Map map = (com.indy.map.Map)target.eContainer();
                RTargetSet ts = ((RMap)map.getMapReference()).getTargetSetRef(target);
                if (this.getNotationView().getElement() instanceof DataSet && !ts.getSourceSet().getDataSet().contains((Object)this.getNotationView().getElement())) {
                    showDataSetLink = false;
                }
            }
        }
        if (HINT_TARGET_LINK.equals(this.getNotationView().getType())) {
            this.setVisibility(showTargetLink);
        } else if (HINT_TARGET_SET_LINK.equals(this.getNotationView().getType())) {
            this.setVisibility(showTargetSetLink);
        } else if (HINT_TARGET_DATASET_LINK.equals(this.getNotationView().getType())) {
            this.setVisibility(showDataSetLink);
        } else if (HINT_JOIN_LINK.equals(this.getNotationView().getType()) || HINT_JOIN_DEDUCTED_LINK.equals(this.getNotationView().getType())) {
            TargetFilter f = null;
            try {
                EObject o;
                if (this.getSource() instanceof TargetFilterEditPart) {
                    o = ((TargetFilterEditPart)this.getSource()).resolveSemanticElement();
                    if (o instanceof TargetFilter) {
                        f = (TargetFilter)o;
                    }
                } else if (this.getTarget() instanceof TargetFilterEditPart && (o = ((TargetFilterEditPart)this.getTarget()).resolveSemanticElement()) instanceof TargetFilter) {
                    f = (TargetFilter)o;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (f != null) {
                if (f.getDataSet() == null) {
                    this.setVisibility(true);
                } else {
                    this.setVisibility(!showDataSetLink);
                }
            }
        }
    }

    public static Color getTargetSetColor() {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)MapDiagramEditorPlugin.getInstance().getPreferenceStore(), (String)"Appearance.targetColor");
        return Activator.getDefault().getColor(rgb);
    }

    public static Color getTargetSetLighterColor() {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)MapDiagramEditorPlugin.getInstance().getPreferenceStore(), (String)"Appearance.targetColorLight");
        return Activator.getDefault().getColor(rgb);
    }

    public static Color getSourceColor() {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)MapDiagramEditorPlugin.getInstance().getPreferenceStore(), (String)"Appearance.sourceColor");
        return Activator.getDefault().getColor(rgb);
    }

    public static Color getOperatorColor() {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)MapDiagramEditorPlugin.getInstance().getPreferenceStore(), (String)"Appearance.sourceColor");
        return Activator.getDefault().getColor(rgb);
    }

    private Color getSourceLighterColor() {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)MapDiagramEditorPlugin.getInstance().getPreferenceStore(), (String)"Appearance.sourceColorLight");
        return Activator.getDefault().getColor(rgb);
    }

    private static Color getTargetColor() {
        return ColorConstants.gray;
    }

    protected void refreshBendpoints() {
        if (this.getEdge().getBendpoints() == null) {
            return;
        }
        super.refreshBendpoints();
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        return null;
    }

    public static class ExternalJoinDecoration
    extends PolylineDecoration {
        public ExternalJoinDecoration(IMapMode mapMode) {
            this.setFill(true);
            PointList pl = new PointList();
            pl.addPoint(mapMode.DPtoLP(-3), mapMode.DPtoLP(-3));
            pl.addPoint(mapMode.DPtoLP(0), mapMode.DPtoLP(0));
            pl.addPoint(mapMode.DPtoLP(-4), mapMode.DPtoLP(0));
            pl.addPoint(mapMode.DPtoLP(0), mapMode.DPtoLP(0));
            pl.addPoint(mapMode.DPtoLP(-3), mapMode.DPtoLP(3));
            pl.addPoint(mapMode.DPtoLP(0), mapMode.DPtoLP(0));
            pl.addPoint(mapMode.DPtoLP(3), mapMode.DPtoLP(-3));
            pl.addPoint(mapMode.DPtoLP(0), mapMode.DPtoLP(0));
            pl.addPoint(mapMode.DPtoLP(4), mapMode.DPtoLP(0));
            pl.addPoint(mapMode.DPtoLP(0), mapMode.DPtoLP(0));
            pl.addPoint(mapMode.DPtoLP(3), mapMode.DPtoLP(3));
            pl.addPoint(mapMode.DPtoLP(0), mapMode.DPtoLP(0));
            pl.addPoint(mapMode.DPtoLP(0), mapMode.DPtoLP(-4));
            pl.addPoint(mapMode.DPtoLP(0), mapMode.DPtoLP(0));
            pl.addPoint(mapMode.DPtoLP(0), mapMode.DPtoLP(4));
            pl.addPoint(mapMode.DPtoLP(0), mapMode.DPtoLP(0));
            this.setTemplate(pl);
            this.setScale(mapMode.DPtoLP(1), mapMode.DPtoLP(1));
        }
    }

    public class LinkFigure
    extends BlendableLinkFigure {
        public void setVisible(boolean visible) {
            super.setVisible(visible);
        }

        @Override
        public void paint(Graphics graphics) {
            Point p;
            if (this.getTargetDecoration() instanceof JoinLeftDecoration && (p = ((JoinLeftDecoration)this.getTargetDecoration()).getNewContainerAnchorLocation()) != null) {
                this.getPoints().setPoint(p, this.getPoints().size() - 1);
            }
            super.paint(graphics);
        }

        private void refreshDataSetLinkColoring() {
            if (LinkEditPart.HINT_TARGET_DATASET_LINK.equals(LinkEditPart.this.getNotationView().getType())) {
                this.setForegroundColor(LinkEditPart.getTargetSetColor());
                try {
                    EObject datastore;
                    SetDescriptor sd;
                    SetEditPolicy p;
                    if (LinkEditPart.this.getNotationView().getElement() != null && LinkEditPart.this.getSource() != null && (p = (SetEditPolicy)LinkEditPart.this.getSource().getEditPolicy((Object)"targetRole")) != null && (sd = p.getActiveSetDescriptor()) != null && (datastore = ((View)LinkEditPart.this.getSource().getModel()).getElement()) instanceof IContainer && ((IContainer)datastore).getSetDescriptor().size() > 1) {
                        Map involvedDataSet = ((IContainer)datastore).getInvolvedDataSetBySetDescriptor();
                        EObject dataset = LinkEditPart.this.getNotationView().getElement();
                        Color color = null;
                        color = involvedDataSet.get(sd) != null && ((Set)involvedDataSet.get(sd)).contains(dataset) ? LinkEditPart.getTargetSetColor() : LinkEditPart.getTargetSetLighterColor();
                        this.setForegroundColor(color);
                    }
                }
                catch (Exception ex) {
                    MapDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "com.indy.gmf.map.diagram", Messages.LinkEditPart_6, (Throwable)ex));
                }
            }
        }

        public LinkFigure() {
            if (LinkEditPart.HINT_JOIN_LINK.equals(LinkEditPart.this.getNotationView().getType()) || LinkEditPart.HINT_JOIN_DEDUCTED_LINK.equals(LinkEditPart.this.getNotationView().getType())) {
                this.setForegroundColor(LinkEditPart.getSourceColor());
                if (LinkEditPart.this.getSource() instanceof TargetFilterEditPart || LinkEditPart.this.getTarget() instanceof TargetFilterEditPart) {
                    this.setForegroundColor(LinkEditPart.getTargetSetColor());
                }
                this.setLineWidth(2);
            } else if (LinkEditPart.HINT_TARGET_LINK.equals(LinkEditPart.this.getNotationView().getType())) {
                this.setForegroundColor(LinkEditPart.getTargetColor());
                this.setLineWidth(2);
            } else if (LinkEditPart.HINT_TARGET_SET_LINK.equals(LinkEditPart.this.getNotationView().getType())) {
                if (LinkEditPart.this.getNotationView().getElement() != null && LinkEditPart.this.getSource() != null) {
                    SetEditPolicy p = (SetEditPolicy)LinkEditPart.this.getSource().getEditPolicy((Object)"targetRole");
                    if (p != null) {
                        if (p.getActiveSetDescriptor() == LinkEditPart.this.getNotationView().getElement()) {
                            this.setForegroundColor(LinkEditPart.getTargetSetColor());
                        } else {
                            this.setForegroundColor(LinkEditPart.getTargetSetLighterColor());
                        }
                    }
                } else {
                    this.setForegroundColor(LinkEditPart.getTargetSetColor());
                }
                this.setLineWidth(2);
            } else if (LinkEditPart.HINT_TARGET_DATASET_LINK.equals(LinkEditPart.this.getNotationView().getType())) {
                this.refreshDataSetLinkColoring();
                this.setLineWidth(2);
            } else if (LinkEditPart.HINT_OPERATOR_LINK.equals(LinkEditPart.this.getNotationView().getType())) {
                this.setForegroundColor(LinkEditPart.getOperatorColor());
                this.setLineStyle(3);
                this.setLineWidth(2);
            }
        }

        public void setForegroundColor(Color fg) {
            super.setForegroundColor(fg);
        }

        public void refreshTargetDecoration() {
            if (LinkEditPart.HINT_JOIN_LINK.equals(LinkEditPart.this.getNotationView().getType()) || LinkEditPart.HINT_JOIN_DEDUCTED_LINK.equals(LinkEditPart.this.getNotationView().getType())) {
                EObject obj;
                EObject sf = ((ShapeNodeEditPart)LinkEditPart.this.getSource()).resolveSemanticElement();
                if (sf instanceof Join && ((Join)sf).isInheritance()) {
                    this.setLineStyle(3);
                    this.setForegroundColor(LinkEditPart.getTargetSetColor());
                } else {
                    if (LinkEditPart.this.getSource() instanceof TargetFilterEditPart || LinkEditPart.this.getTarget() instanceof TargetFilterEditPart) {
                        this.setForegroundColor(LinkEditPart.getTargetSetColor());
                    } else {
                        this.setForegroundColor(LinkEditPart.HINT_JOIN_LINK.equals(LinkEditPart.this.getNotationView().getType()) ? LinkEditPart.getSourceColor() : LinkEditPart.this.getSourceLighterColor());
                    }
                    this.setLineStyle(1);
                }
                this.setTargetDecoration(null);
                this.setSourceDecoration(null);
                if (LinkEditPart.this.getTarget() instanceof org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart && (obj = ((org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)LinkEditPart.this.getTarget()).resolveSemanticElement()) instanceof IContainer) {
                    IContainer s = (IContainer)obj;
                    if (sf instanceof Join) {
                        EObject conn;
                        Join join = (Join)sf;
                        if (join.getLeft() == s && (join.getJoinType() == JoinType.FULL_JOIN || join.getJoinType() == JoinType.LEFT_JOIN) || join.getRight() == s && (join.getJoinType() == JoinType.FULL_JOIN || join.getJoinType() == JoinType.RIGHT_JOIN)) {
                            this.setSourceDecoration((RotatableDecoration)new ExternalJoinDecoration(LinkEditPart.this.getMapMode()));
                        } else if (join.getJoinType() == JoinType.CROSS_JOIN) {
                            this.setForegroundColor(DiagramColorConstants.diagramGray);
                        }
                        if (this.getSourceDecoration() == null && join.getLocation() == JoinLocation.SRC && (conn = s.getAPI().getMdEvaluator().evaluateConnection(s, IMetaDataInformationsProvider.EvaluationLocation.ON_REF)) instanceof MdNode && join.getJoinType() == JoinType.INNER_JOIN && join.getLeft() == s) {
                            try {
                                if (((MdNode)conn).evaluateXpathExpressionBooleanCached(new String[]{"INTERNAL_SHOW_LEFT_INNER_JOIN_DECORATION"})) {
                                    RItem i;
                                    JoinLeftDecoration d = new JoinLeftDecoration(((org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)LinkEditPart.this.getTarget()).getFigure());
                                    d.setScale(9.0, 5.0);
                                    if (join.getRight() instanceof IReferencable && (i = (RItem)((IReferencable)join.getRight()).getMapReference()).getProblem(RProblem.ERROR_JOIN_LOADSET_NO_DIRECT_PATH) != null) {
                                        RGB rgb = new RGB(189, 32, 35);
                                        d.setForegroundColor(Activator.getDefault().getColor(rgb));
                                    }
                                    this.setTargetDecoration(d);
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                }
            } else if (LinkEditPart.HINT_TARGET_LINK.equals(LinkEditPart.this.getNotationView().getType()) || LinkEditPart.HINT_TARGET_DATASET_LINK.equals(LinkEditPart.this.getNotationView().getType()) || LinkEditPart.HINT_TARGET_SET_LINK.equals(LinkEditPart.this.getNotationView().getType())) {
                this.setSourceDecoration((RotatableDecoration)new PolygonDecoration());
                ((PolygonDecoration)this.getSourceDecoration()).setLineWidth(2);
            }
        }
    }

    private class TargetFilterFigureListener
    implements FigureListener {
        TargetFilterEditPart ep;

        TargetFilterFigureListener(TargetFilterEditPart ep) {
            this.ep = ep;
        }

        public void figureMoved(IFigure source) {
            if (source == LinkEditPart.this.getFigure() && this.ep != null) {
                this.ep.relocateFigure((GraphicalEditPart)LinkEditPart.this);
            }
        }
    }
}

