/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.policies;

import com.indy.gmf.map.diagram.custom.edit.parts.ContainerEditPart;
import com.indy.gmf.map.diagram.custom.edit.policies.AbstractPolygonDecorationEditPolicy;
import com.indy.gmf.map.diagram.custom.figures.BlendableRectangleFigure;
import com.indy.map.DataSet;
import com.indy.map.IContainer;
import com.indy.map.IReferencable;
import com.indy.map.Join;
import com.indy.map.Map;
import com.indy.map.MapPackage;
import com.indy.map.diagram.edit.parts.FilterEditPart;
import com.indy.map.diagram.edit.parts.JoinEditPart;
import com.indy.map.ref.RContainer;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RSourceSet;
import com.indy.map.ref.RTargetSet;
import com.indy.map.ref.RefPackage;
import com.indy.ui.custom.out.Activator;
import com.indy.ui.custom.out.services.IDropValidationService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;

@Deprecated
public abstract class ContainerFeedbackEditPolicy
extends AbstractPolygonDecorationEditPolicy {
    public static final String SELECTION_FEEDBACK_ROLE = "selectionFeedback.role";
    static final RGB colorSrc = new RGB(89, 171, 245);
    static final RGB colorTrg = new RGB(255, 145, 71);
    private IContainer selectedContainer;
    private List<EObject> markedContainer = new ArrayList<EObject>();
    private EditPartListener selectionListener = new EditPartListener.Stub(){

        public void selectedStateChanged(EditPart part) {
            EObject obj;
            if (part.getSelected() == 2 && (obj = ((IGraphicalEditPart)part).resolveSemanticElement()) instanceof IContainer) {
                ContainerFeedbackEditPolicy.this.selectedContainer = (IContainer)obj;
                ContainerFeedbackEditPolicy.this.refresh();
            }
        }

        public void childAdded(EditPart child, int index) {
            child.addEditPartListener((EditPartListener)this);
        }

        public void removingChild(EditPart child, int index) {
            child.removeEditPartListener((EditPartListener)this);
        }
    };
    private Adapter sourceSetListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (msg.getFeature() == RefPackage.eINSTANCE.getRSourceSet_DataSet()) {
                ContainerFeedbackEditPolicy.this.refresh();
            } else if (msg.getFeature() == RefPackage.eINSTANCE.getRMap_SourceSetRef()) {
                if (msg.getEventType() == 3) {
                    ((EObject)msg.getNewValue()).eAdapters().add((Object)ContainerFeedbackEditPolicy.this.sourceSetListener);
                } else if (msg.getEventType() == 4) {
                    ((EObject)msg.getOldValue()).eAdapters().remove((Object)ContainerFeedbackEditPolicy.this.sourceSetListener);
                }
                ContainerFeedbackEditPolicy.this.refresh();
            }
        }
    };

    private List<Point> getAllPoints(List containers) {
        ArrayList<Point> l = new ArrayList<Point>();
        for (Object ep : ((IGraphicalEditPart)this.getHost()).getChildren()) {
            IGraphicalEditPart child;
            if (!(ep instanceof ContainerEditPart) && !(ep instanceof JoinEditPart) && !(ep instanceof FilterEditPart) || !containers.contains((child = (IGraphicalEditPart)ep).resolveSemanticElement())) continue;
            Rectangle bounds = child.getFigure().getBounds().getCopy();
            child.getFigure().translateToAbsolute((Translatable)bounds);
            bounds.expand(15, 15);
            l.add(new Point(bounds.x, bounds.y));
            l.add(new Point(bounds.x + bounds.width, bounds.y));
            l.add(new Point(bounds.x + bounds.width, bounds.y + bounds.height));
            l.add(new Point(bounds.x, bounds.y + bounds.height));
        }
        this.markedContainer.addAll(containers);
        return l;
    }

    private List<Point> getAllPoints(RSourceSet sourceSet) {
        ArrayList<Object> containers = new ArrayList<Object>();
        for (DataSet ds : sourceSet.getDataSet()) {
            for (IContainer c : ds.getContainer()) {
                if (containers.contains(c)) continue;
                containers.add(c);
            }
        }
        Map m = (Map)((RMap)sourceSet.eContainer()).getDataModel();
        for (Join j : m.getJoin()) {
            if (!containers.containsAll(j.getInvolvedContainers())) continue;
            containers.add(j);
        }
        for (Join j : m.getFilter()) {
            if (!containers.containsAll(j.getInvolvedContainers())) continue;
            containers.add(j);
        }
        List<Point> l = this.getAllPoints(containers);
        return l;
    }

    @Override
    public void refresh() {
        PointList pl;
        this.clearFigures();
        this.markedContainer.clear();
        Map map = (Map)((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
        if (this.selectedContainer == null) {
            return;
        }
        RSourceSet ss = ((RMap)map.getMapReference()).getInputSourceSet(this.selectedContainer);
        if (ss != null && (pl = this.normalizePoints(this.getAllPoints(ss))) != null) {
            IFigure polygon = this.createPolygon(pl);
            polygon.setForegroundColor(Activator.getDefault().getColor(colorSrc));
            polygon.setBackgroundColor(Activator.getDefault().getColor(colorSrc));
            this.addPolygon(polygon);
            this.getLayer("customSetLayer").add(polygon);
        }
        List l = this.selectedContainer.getUsageContainers();
        ArrayList drawned = new ArrayList();
        for (IContainer c : l) {
            RTargetSet ts = ((RMap)map.getMapReference()).getTargetSetRef(c);
            if (drawned.contains(c)) continue;
            List t = ts.getContainerModel();
            drawned.addAll(t);
            PointList pl2 = this.normalizePoints(this.getAllPoints(t));
            if (pl2 == null) continue;
            IFigure polygon = this.createPolygon(pl2);
            this.addPolygon(polygon);
            polygon.setForegroundColor(Activator.getDefault().getColor(colorTrg));
            polygon.setBackgroundColor(Activator.getDefault().getColor(colorTrg));
            this.getLayer("customSetLayer").add(polygon);
        }
        IDropValidationService service = (IDropValidationService)PlatformUI.getWorkbench().getService(IDropValidationService.class);
        for (IContainer c : map.getContainer()) {
            boolean visible = c == this.selectedContainer || this.markedContainer.contains(c) || service.validate((EObject)this.selectedContainer.getLogicalField().get(0), (EObject)c.getLogicalField().get(0), true) == IDropValidationService.DropResult.NONE;
            this.alphaBlend(c, visible);
        }
    }

    private void alphaBlend(IContainer c, boolean visible) {
        IGraphicalEditPart gep = (IGraphicalEditPart)((IGraphicalEditPart)this.getHost()).findEditPart((EditPart)this.getHost().getRoot(), (EObject)c);
        if (gep != null) {
            ((BlendableRectangleFigure)gep.getFigure().getChildren().get(0)).setAlphaBlended(!visible);
        }
    }

    private PointList normalizePoints(List<Point> l) {
        List<Point> pointList = this.quickHull(l);
        if (!pointList.isEmpty()) {
            PointList pl = new PointList();
            for (Point pt : pointList) {
                pl.addPoint(pt);
            }
            final Point ref = pl.getBounds().getCenter();
            Collections.sort(pointList, new Comparator<Point>(){

                @Override
                public int compare(Point o1, Point o2) {
                    double aTanB;
                    double aTanA = Math.atan2(o1.y - ref.y, o1.x - ref.x);
                    if (aTanA < (aTanB = Math.atan2(o2.y - ref.y, o2.x - ref.x))) {
                        return -1;
                    }
                    if (aTanB < aTanA) {
                        return 1;
                    }
                    return 0;
                }
            });
            pl = new PointList();
            for (Point pt : pointList) {
                this.getLayer("customSetLayer").translateToRelative((Translatable)pt);
                pl.addPoint(pt);
            }
            pl = PointListUtilities.calcSmoothPolyline((PointList)pl, (int)32, (int)16);
            return pl;
        }
        return null;
    }

    @Override
    public void activate() {
        Map map = (Map)((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
        for (Object c : map.getContainer()) {
            this.alphaBlend((IContainer)c, false);
        }
        this.getHost().addEditPartListener(this.selectionListener);
        for (Object c : this.getHost().getChildren()) {
            if (!(c instanceof IGraphicalEditPart)) continue;
            ((EditPart)c).addEditPartListener(this.selectionListener);
        }
        super.activate();
    }

    @Override
    public void deactivate() {
        Map map = (Map)((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
        for (Object c : map.getContainer()) {
            this.alphaBlend((IContainer)c, true);
        }
        this.getHost().removeEditPartListener(this.selectionListener);
        for (Object c : this.getHost().getChildren()) {
            if (!(c instanceof IGraphicalEditPart)) continue;
            ((EditPart)c).removeEditPartListener(this.selectionListener);
        }
        super.deactivate();
    }

    @Override
    protected IFigure createPolygon(PointList points) {
        Polygon polygon = new Polygon();
        polygon.setPoints(points);
        polygon.setAlpha(55);
        polygon.setFill(true);
        polygon.setLineWidth(2);
        return polygon;
    }

    @Override
    protected Adapter createSemanticAdapter() {
        AdapterImpl adapter = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (msg.getFeature() == MapPackage.eINSTANCE.getQuery_Dataset() || msg.getFeature() == MapPackage.eINSTANCE.getDatastore_Dataset()) {
                    ContainerFeedbackEditPolicy.this.refresh();
                }
            }
        };
        return adapter;
    }

    @Override
    protected void registerSemanticAdapter(EObject obj) {
        super.registerSemanticAdapter(obj);
        if (obj instanceof IContainer) {
            ((RContainer)((IReferencable)obj).getMapReference()).eAdapters().add((Object)this.sourceSetListener);
            ((RMap)((Map)obj.eContainer()).getMapReference()).eAdapters().add((Object)this.sourceSetListener);
        }
    }

    @Override
    protected void unregisterSemanticAdapter(EObject obj) {
        super.unregisterSemanticAdapter(obj);
        if (obj instanceof IContainer) {
            ((RContainer)((IReferencable)obj).getMapReference()).eAdapters().remove((Object)this.sourceSetListener);
            ((RMap)((Map)obj.eContainer()).getMapReference()).eAdapters().remove((Object)this.sourceSetListener);
        }
    }
}

