/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.policies;

import com.indy.map.DataSet;
import com.indy.map.IContainer;
import com.indy.map.diagram.edit.parts.DatastoreEditPart;
import com.indy.map.diagram.edit.parts.OutlinerEditPart;
import com.indy.map.diagram.edit.parts.QueryEditPart;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import com.indy.map.diagram.part.MapVisualIDRegistry;
import com.indy.map.util.InheritanceHelper;
import com.indy.ui.custom.out.Activator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ContainerSelectionEditPolicy
extends SelectionEditPolicy
implements ISelectionChangedListener {
    public static final Font REGULAR_FONT = new Font((Device)Display.getDefault(), "Arial", 9, 0);
    public static final Font BOLD_FONT = new Font((Device)Display.getDefault(), "Arial", 9, 1);
    public static final String ROLE_HEADER_COLORING = "containerHeaderColorRole";
    private IGraphicalEditPart currentPrimarySelected;
    private boolean enabled = false;

    public void setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            this.enabled = enabled;
            this.hideSelection();
            this.showSelection();
        }
    }

    protected void hideSelection() {
        if (!this.enabled) {
            return;
        }
        for (DataSet ds : this.getSourceDataSets()) {
            for (IContainer c : ds.getContainer()) {
                IGraphicalEditPart gep = (IGraphicalEditPart)((DiagramEditPart)this.getHost().getRoot().getContents()).findEditPart((EditPart)this.getHost().getRoot(), (EObject)c);
                if (gep == null) continue;
                this.colorTitle(gep, ColorConstants.black.getRGB(), ColorConstants.white.getRGB(), false, false);
            }
        }
        for (IContainer c : this.getTargetContainer()) {
            IGraphicalEditPart gep = (IGraphicalEditPart)((DiagramEditPart)this.getHost().getRoot().getContents()).findEditPart((EditPart)this.getHost().getRoot(), (EObject)c);
            if (gep == null) continue;
            this.colorTitle(gep, ColorConstants.black.getRGB(), ColorConstants.white.getRGB(), false, false);
        }
    }

    private List<IContainer> getTargetContainer() {
        IContainer container = this.getContainer();
        if (container == null) {
            return Collections.EMPTY_LIST;
        }
        return container.getUsageContainers();
    }

    private List<DataSet> getSourceDataSets() {
        IContainer container = this.getContainer();
        if (container == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DataSet> l = new ArrayList<DataSet>();
        for (IContainer c : container.getSrcContainers()) {
            if (l.contains(c.getDataset())) continue;
            for (DataSet ds : InheritanceHelper.getDataSetHierarchy((DataSet)c.getDataset())) {
                if (l.contains(ds)) continue;
                l.add(ds);
            }
        }
        return l;
    }

    protected void showSelection() {
        if (!this.enabled) {
            return;
        }
        for (DataSet ds : this.getSourceDataSets()) {
            for (IContainer c : ds.getContainer()) {
                IGraphicalEditPart gep = (IGraphicalEditPart)((DiagramEditPart)this.getHost().getRoot().getContents()).findEditPart((EditPart)this.getHost().getRoot(), (EObject)c);
                if (gep == null) continue;
                RGB color = PreferenceConverter.getColor((IPreferenceStore)MapDiagramEditorPlugin.getInstance().getPreferenceStore(), (String)"Appearance.sourceColor");
                this.colorTitle(gep, ColorConstants.white.getRGB(), color, true, true);
            }
        }
        for (IContainer c : this.getTargetContainer()) {
            IGraphicalEditPart gep = (IGraphicalEditPart)((DiagramEditPart)this.getHost().getRoot().getContents()).findEditPart((EditPart)this.getHost().getRoot(), (EObject)c);
            if (gep == null) continue;
            RGB color = PreferenceConverter.getColor((IPreferenceStore)MapDiagramEditorPlugin.getInstance().getPreferenceStore(), (String)"Appearance.targetColor");
            this.colorTitle(gep, ColorConstants.white.getRGB(), color, true, true);
        }
    }

    private void colorTitle(IGraphicalEditPart gep, RGB foreGround, RGB backGround, boolean opaque, boolean bold) {
        IGraphicalEditPart titleGep = null;
        if (gep instanceof DatastoreEditPart) {
            titleGep = gep.getChildBySemanticHint(MapVisualIDRegistry.getType(5005));
        } else if (gep instanceof QueryEditPart) {
            titleGep = gep.getChildBySemanticHint(MapVisualIDRegistry.getType(5001));
        } else if (gep instanceof OutlinerEditPart) {
            titleGep = gep.getChildBySemanticHint(MapVisualIDRegistry.getType(5090));
        }
        if (titleGep != null) {
            titleGep.getFigure().setBackgroundColor(Activator.getDefault().getColor(backGround));
            titleGep.getFigure().setForegroundColor(Activator.getDefault().getColor(foreGround));
            titleGep.getFigure().setOpaque(opaque);
            if (bold) {
                titleGep.getFigure().setFont(BOLD_FONT);
            } else {
                titleGep.getFigure().setFont(REGULAR_FONT);
            }
        }
    }

    private IContainer getContainer() {
        if (this.currentPrimarySelected == null) {
            return null;
        }
        EObject o = this.currentPrimarySelected.resolveSemanticElement();
        if (o instanceof IContainer) {
            return (IContainer)o;
        }
        return null;
    }

    protected void addSelectionListener() {
        this.getHost().getRoot().getViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected void removeSelectionListener() {
        this.getHost().getRoot().getViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void deactivate() {
        this.hideSelection();
        this.setEnabled(false);
        this.currentPrimarySelected = null;
        super.deactivate();
    }

    public void activate() {
        this.setEnabled(true);
        super.activate();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection ss = (IStructuredSelection)event.getSelection();
        if (ss.isEmpty()) {
            if (this.currentPrimarySelected != null) {
                this.hideSelection();
                this.currentPrimarySelected = null;
            }
        } else {
            IGraphicalEditPart crGep = null;
            for (Object o : ss.toList()) {
                IGraphicalEditPart c = this.getContainerEp((IGraphicalEditPart)o);
                if (c == null) {
                    this.hideSelection();
                    this.currentPrimarySelected = null;
                    continue;
                }
                if (crGep == null) {
                    crGep = c;
                    continue;
                }
                if (crGep == c) continue;
                this.hideSelection();
                this.currentPrimarySelected = null;
            }
            if (crGep != null && crGep != this.currentPrimarySelected) {
                this.hideSelection();
                this.currentPrimarySelected = crGep;
                this.showSelection();
            }
        }
    }

    private IGraphicalEditPart getContainerEp(IGraphicalEditPart o) {
        if (o == null || !(o instanceof IGraphicalEditPart)) {
            return null;
        }
        if (o instanceof DatastoreEditPart || o instanceof QueryEditPart) {
            return o;
        }
        if (!(o.getParent() instanceof IGraphicalEditPart)) {
            return null;
        }
        return this.getContainerEp((IGraphicalEditPart)o.getParent());
    }
}

