/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.policies;

import com.indy.gmf.map.diagram.custom.edit.parts.ClauseEditPart;
import com.indy.gmf.map.diagram.custom.edit.parts.ContainerEditPart;
import com.indy.gmf.map.diagram.custom.edit.parts.DatastoreViewEditPart;
import com.indy.gmf.map.diagram.custom.figures.IBlendableFigure;
import com.indy.map.Datastore;
import com.indy.map.Field;
import com.indy.map.diagram.edit.parts.DatastoreEditPart;
import com.indy.map.diagram.edit.parts.VariableEditPart;
import com.indy.map.diagram.notation.mappingNotation.NodeView;
import com.indy.map.ref.RField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

public class DatastoreViewConnectionEditPolicy
extends GraphicalEditPolicy {
    public static final int CIRCLE_CONNECTION_DECORATION_RADIUS = 3;
    public static final String ROLE_DATASTORE_VIEW = "com.indy.gmf.map.diagram.custom.edit.policies.ROLE_DATASTORE_VIEW";
    private List<IFigure> figures = new ArrayList<IFigure>();
    private static final String HINT_FIELD_COMPARTMENT = "7004";
    private static final String HINT_FIELD = "3008";
    private static final String HINT_DATASTORE = "2004";
    private EditPartListener epListener = new EditPartListener.Stub(){

        public void childAdded(EditPart child, int index) {
            if (child instanceof DatastoreViewEditPart) {
                DatastoreViewConnectionEditPolicy.this.hideFigures();
                DatastoreViewConnectionEditPolicy.this.computeFigures();
                DatastoreViewConnectionEditPolicy.this.showFigures();
            }
        }

        public void removingChild(EditPart child, int index) {
            if (child instanceof DatastoreViewEditPart) {
                DatastoreViewConnectionEditPolicy.this.hideFigures();
                DatastoreViewConnectionEditPolicy.this.computeFigures();
                DatastoreViewConnectionEditPolicy.this.showFigures();
            }
        }
    };
    public static final Color myGray = new Color(null, 160, 160, 160);

    private Diagram getDiagram() {
        return ((View)this.getHost().getModel()).getDiagram();
    }

    private View findFieldFrom(Datastore s, Field f) {
        for (Object o : this.getDiagram().getChildren()) {
            if (!(o instanceof View) || o instanceof NodeView || ((View)o).getElement() != s) continue;
            for (Object _c : ((View)o).getChildren()) {
                if (!(_c instanceof View) || !HINT_FIELD_COMPARTMENT.equals(((View)_c).getType())) continue;
                for (Object _f : ((View)_c).getChildren()) {
                    if (!(_f instanceof View) || ((View)_f).getElement() != f) continue;
                    return (View)_f;
                }
            }
        }
        return null;
    }

    private View findFieldFromDatastoreView(Field f) {
        block0: for (Object o : this.getDiagram().getChildren()) {
            if (!(o instanceof NodeView) || ((NodeView)o).getElement() != f.eContainer() || ((NodeView)o).getSubElement() == f) continue;
            for (Object _c : ((View)o).getChildren()) {
                if (!(_c instanceof View) || !HINT_FIELD_COMPARTMENT.equals(((View)_c).getType())) continue;
                for (Object _f : ((View)_c).getChildren()) {
                    if (!(_f instanceof View) || ((View)_f).getElement() != f) continue;
                    return (View)_f;
                }
                continue block0;
            }
        }
        return null;
    }

    private View findDatastoreView(Field f) {
        for (Object o : this.getDiagram().getChildren()) {
            if (!(o instanceof NodeView) || ((NodeView)o).getSubElement() != f) continue;
            return (View)o;
        }
        return null;
    }

    private GraphicalEditPart findEditPart(View srcView) {
        View containerView = null;
        containerView = srcView.getType().equals(HINT_FIELD) ? (View)srcView.eContainer().eContainer() : srcView;
        for (Object o : this.getHost().getChildren()) {
            if (!(o instanceof DatastoreEditPart) || ((EditPart)o).getModel() != containerView) continue;
            if (srcView == containerView) {
                return (GraphicalEditPart)o;
            }
            IGraphicalEditPart container = ((IGraphicalEditPart)o).getChildBySemanticHint(HINT_FIELD_COMPARTMENT);
            for (Object c : container.getChildren()) {
                if (((EditPart)c).getModel() != srcView) continue;
                return (GraphicalEditPart)c;
            }
        }
        return null;
    }

    private void computeFigures() {
        this.figures.clear();
        Tree root = new Tree(this.getDiagram().getElement());
        for (Object o : this.getDiagram().getChildren()) {
            if (!(o instanceof View) || !HINT_DATASTORE.equals(((View)o).getType())) continue;
            View datastoreView = (View)o;
            HashMap<String, Tree> idMap = new HashMap<String, Tree>();
            for (Field f : ((Datastore)datastoreView.getElement()).getSubsetRootField()) {
                idMap.put(((RField)f.getMapReference()).getFullName(), new Tree((EObject)f));
            }
            if (idMap.isEmpty()) continue;
            Tree datastoreRoot = new Tree(datastoreView.getElement());
            root.children.add(datastoreRoot);
            for (String key : idMap.keySet()) {
                Tree value = (Tree)idMap.get(key);
                Tree parent = null;
                if (value.semantic instanceof Field) {
                    EObject cur = value.semantic;
                    while (cur != null && parent == null) {
                        parent = (cur = ((Field)cur).getParent()) == null ? null : (Tree)idMap.get(((RField)((Field)cur).getMapReference()).getFullName());
                    }
                }
                if (parent == null) {
                    parent = datastoreRoot;
                }
                parent.children.add(value);
            }
        }
        this.figures.addAll(root.createFigures());
    }

    protected IMapMode getMapMode() {
        RootEditPart root = this.getHost().getRoot();
        if (root instanceof DiagramRootEditPart) {
            DiagramRootEditPart dgrmRoot = (DiagramRootEditPart)root;
            return dgrmRoot.getMapMode();
        }
        return MapModeUtil.getMapMode();
    }

    public void activate() {
        super.activate();
        this.getHost().addEditPartListener(this.epListener);
        this.computeFigures();
        this.showFigures();
    }

    public void deactivate() {
        this.getHost().removeEditPartListener(this.epListener);
        this.hideFigures();
        super.deactivate();
    }

    private void hideFigures() {
        for (IFigure f : this.figures) {
            if (f.getParent() == null) continue;
            ((IBlendableFigure)((PolylineConnection)f).getSourceAnchor().getOwner()).setAlphaBlended(false);
            this.getLayer("Connection Layer").remove(f);
        }
    }

    private void showFigures() {
        for (IFigure f : this.figures) {
            ((IBlendableFigure)((PolylineConnection)f).getSourceAnchor().getOwner()).setAlphaBlended(true);
            this.getLayer("Connection Layer").add(f);
        }
    }

    public Command getCommand(Request request) {
        boolean cfr_ignored_0 = request instanceof CreateViewRequest;
        return super.getCommand(request);
    }

    private class CustomAcnhor
    extends ChopboxAnchor {
        private GraphicalEditPart containerEp;

        CustomAcnhor(GraphicalEditPart owner) {
            super(owner.getFigure());
            GraphicalEditPart ep = owner;
            while (!(ep instanceof ContainerEditPart || ep instanceof ClauseEditPart || ep instanceof VariableEditPart)) {
                ep = (GraphicalEditPart)ep.getParent();
            }
            this.containerEp = ep;
        }

        public Point getLocation(Point reference) {
            Point pt = super.getLocation(reference);
            this.getOwner().translateToAbsolute((Translatable)pt);
            Rectangle r = this.containerEp.getFigure().getBounds().getCopy();
            this.containerEp.getFigure().translateToAbsolute((Translatable)r);
            Point center = this.getReferencePoint().getCopy();
            pt.x = reference.x >= pt.x ? r.x + r.width : r.x;
            pt.y = center.y;
            if (pt.y < r.y) {
                pt.y = r.y;
            } else if (pt.y > r.y + r.height) {
                pt.y = r.y + r.height;
            }
            pt.x = r.x + r.width;
            return pt;
        }

        public boolean containerFigureContains(Point pt) {
            Point p = pt.getCopy();
            this.containerEp.getFigure().translateToRelative((Translatable)p);
            return this.containerEp.getFigure().getBounds().contains(p);
        }
    }

    private class RefreshCommand
    extends Command {
        private RefreshCommand() {
        }

        private void refresh() {
            DatastoreViewConnectionEditPolicy.this.hideFigures();
            DatastoreViewConnectionEditPolicy.this.computeFigures();
            DatastoreViewConnectionEditPolicy.this.showFigures();
        }

        public boolean canExecute() {
            return true;
        }

        public boolean canUndo() {
            return true;
        }

        public void execute() {
            this.refresh();
        }

        public void undo() {
            this.refresh();
        }

        public void redo() {
            this.refresh();
        }
    }

    private class Tree {
        List<Tree> children = new ArrayList<Tree>();
        EObject semantic;

        Tree(EObject semantic) {
            this.semantic = semantic;
        }

        public List<IFigure> createFigures() {
            ArrayList<IFigure> l = new ArrayList<IFigure>();
            for (Tree c : this.children) {
                if (this.semantic instanceof Datastore || this.semantic instanceof Field) {
                    GraphicalEditPart ep;
                    PolylineConnectionEx poly = new PolylineConnectionEx(){

                        protected void outlineShape(Graphics g) {
                            super.outlineShape(g);
                        }

                        public Rectangle getBounds() {
                            Rectangle r = super.getBounds();
                            return r;
                        }
                    };
                    poly.setLineWidth(1);
                    poly.setForegroundColor(myGray);
                    poly.setLineStyle(1);
                    poly.setAntialias(1);
                    poly.setRoutingStyles(false, true);
                    poly.setSmoothness(0);
                    poly.setJumpLinks(false);
                    PolygonDecoration dec = new PolygonDecoration();
                    dec.setFill(true);
                    dec.setBackgroundColor(ColorConstants.white);
                    poly.setTargetDecoration((RotatableDecoration)dec);
                    View srcView = null;
                    srcView = this.semantic instanceof Datastore ? DatastoreViewConnectionEditPolicy.this.findFieldFrom((Datastore)this.semantic, (Field)c.semantic) : DatastoreViewConnectionEditPolicy.this.findFieldFromDatastoreView((Field)c.semantic);
                    View dstView = DatastoreViewConnectionEditPolicy.this.findDatastoreView((Field)c.semantic);
                    boolean fullyDefined = true;
                    if (srcView != null) {
                        ep = DatastoreViewConnectionEditPolicy.this.findEditPart(srcView);
                        if (ep != null) {
                            poly.setSourceAnchor((ConnectionAnchor)new CustomAcnhor(ep));
                        } else {
                            fullyDefined = false;
                        }
                    }
                    if (dstView != null) {
                        ep = DatastoreViewConnectionEditPolicy.this.findEditPart(dstView);
                        if (ep != null) {
                            poly.setTargetAnchor((ConnectionAnchor)new ChopboxAnchor(ep.getFigure()));
                        } else {
                            fullyDefined = false;
                        }
                    }
                    if (fullyDefined) {
                        l.add((IFigure)poly);
                    }
                }
                l.addAll(c.createFigures());
            }
            return l;
        }
    }
}

