/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.policies;

import com.indy.gmf.map.diagram.custom.edit.policies.MapDragDropEditPolicy;
import com.indy.gmf.map.diagram.custom.preferences.stage.StagePreferenceManager;
import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.gmf.map.edit.provider.custom.MapIconAPI;
import com.indy.map.Datastore;
import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.Map;
import com.indy.map.MapPackage;
import com.indy.map.Template;
import com.indy.map.diagram.edit.commands.QueryFieldCreateCommand;
import com.indy.map.diagram.providers.MapElementTypes;
import com.indy.map.util.TemplateCapabilityHelper;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.registry.LevelCodeInfo;
import com.semarchy.xdi.designer.core.services.registry.StagingAreaDescriptor;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.PopupMenuCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.menus.PopupMenu;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;

class DropFieldOnMapPopupCommand
extends PopupMenuCommand {
    Logger logger = LogManager.getLogger(DropFieldOnMapPopupCommand.class);
    ImageRegistry imgRegistry = new ImageRegistry();
    Point location;
    List<ILogicalField> dropedField;
    TransactionalEditingDomain domain;
    MapDragDropEditPolicy editPolicy;
    private Command createCommand;

    DropFieldOnMapPopupCommand(MapDragDropEditPolicy editPolicy, TransactionalEditingDomain domain, Point location, List<ILogicalField> dropedField) {
        super("", Display.getCurrent().getActiveShell());
        this.editPolicy = editPolicy;
        this.location = location;
        this.dropedField = dropedField;
        this.domain = domain;
        final ArrayList<String> menuContent = new ArrayList<String>();
        menuContent.add(Messages.MapDragDropEditPolicy_1);
        try {
            Template integrationTpl = ((Map)((IGraphicalEditPart)this.editPolicy.getHost()).resolveSemanticElement()).getIntegrationTemplate((IContainer)dropedField.get(0).eContainer());
            if (TemplateCapabilityHelper.supportCapability((Template)integrationTpl, (String)"template-feature-support", (String)"targetFilter", (boolean)false)) {
                menuContent.add(Messages.MapDragDropEditPolicy_15);
            }
        }
        catch (Exception integrationTpl) {
            // empty catch block
        }
        ArrayList<List<Object>> subMenuContent = new ArrayList<List<Object>>();
        ArrayList<StagingAreaDescriptor> currentDesc = new ArrayList<StagingAreaDescriptor>(StagePreferenceManager.INSTANCE.getPreferredStageArea());
        try {
            currentDesc.sort((o1, o2) -> o1.getLabel().toLowerCase().compareTo(o2.getLabel().toLowerCase()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        subMenuContent.add(currentDesc);
        subMenuContent.add(Collections.singletonList(Messages.MapDragDropEditPolicy_2));
        PopupMenuWithSeparator subMenu = new PopupMenuWithSeparator(subMenuContent, (ILabelProvider)new PopupLabelProvider());
        menuContent.add((String)new PopupMenu.CascadingMenu((Object)Messages.MapDragDropEditPolicy_3, (PopupMenu)subMenu));
        menuContent.add((String)new PopupMenu.CascadingMenu((Object)Messages.DropStageAreaOnMapPopupCommand_menuCreateDeserializer, (PopupMenu)subMenu));
        try {
            if (dropedField.size() == 1 && MapDragDropEditPolicy.supportDatastoreView() && this.editPolicy.canHaveChildren(dropedField.get(0)) && !((Field)dropedField.get(0)).getChildren().isEmpty()) {
                menuContent.add(Messages.MapDragDropEditPolicy_14);
            }
        }
        catch (Exception ex) {
            this.logger.error("unexected", (Throwable)ex);
        }
        this.setPopupMenu(new PopupMenu(menuContent, (ILabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element == menuContent.get(0)) {
                    return MapIconAPI.getImage((String)"full/obj22x22/Filtre22x22SimpleBleu.gif");
                }
                if (element.equals(Messages.MapDragDropEditPolicy_15)) {
                    return MapIconAPI.getImage((String)"full/obj16x16/TargetFiltre16x16.png");
                }
                return super.getImage(element);
            }
        }));
    }

    private Command createStageCommand(EObject mdNode) {
        CreateViewAndElementRequest.ViewAndElementDescriptor viewDescriptor = new CreateViewAndElementRequest.ViewAndElementDescriptor(new CreateElementRequestAdapter(new CreateElementRequest(MapElementTypes.Query_2001)), Node.class, ((IHintedType)MapElementTypes.Query_2001).getSemanticHint(), this.editPolicy.getDiagramPreferencesHint());
        final CreateViewAndElementRequest createRequest = new CreateViewAndElementRequest(viewDescriptor);
        createRequest.setLocation(this.location);
        createRequest.getExtendedData().put("ref", mdNode);
        CompoundCommand cc = new CompoundCommand();
        cc.add(this.editPolicy.getHost().getCommand((Request)createRequest));
        AbstractTransactionalCommand createCmd = new AbstractTransactionalCommand(this.domain, Messages.MapDragDropEditPolicy_4, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                EObject stage = (EObject)createRequest.getViewAndElementDescriptor().getElementAdapter().getAdapter(EObject.class);
                CompositeCommand cc = new CompositeCommand(Messages.MapDragDropEditPolicy_5);
                for (ILogicalField f : DropFieldOnMapPopupCommand.this.dropedField) {
                    CreateElementRequest req = new CreateElementRequest(DropFieldOnMapPopupCommand.this.domain, stage, MapElementTypes.QueryField_3002);
                    req.setParameter("request.queryFieldName", (Object)f.getLabel());
                    req.setParameter("request.expression", (Object)f.getFullPath());
                    cc.add((IUndoableOperation)new QueryFieldCreateCommand(req));
                }
                ICommandProxy p = new ICommandProxy((ICommand)cc);
                if (p.canExecute()) {
                    p.execute();
                    return p.getICommand().getCommandResult();
                }
                return CommandResult.newCancelledCommandResult();
            }
        };
        cc.add((Command)new ICommandProxy((ICommand)createCmd));
        return cc;
    }

    private Command createSerdeCommand(EObject mdNode, EClass serdeEClass) {
        CreateViewAndElementRequest.ViewAndElementDescriptor viewDescriptor = new CreateViewAndElementRequest.ViewAndElementDescriptor(new CreateElementRequestAdapter(new CreateElementRequest(MapElementTypes.Outliner_2009)), Node.class, ((IHintedType)MapElementTypes.Outliner_2009).getSemanticHint(), this.editPolicy.getDiagramPreferencesHint());
        CreateViewAndElementRequest createRequest = new CreateViewAndElementRequest(viewDescriptor);
        createRequest.setLocation(this.location);
        createRequest.getExtendedData().put("ref", mdNode);
        createRequest.getExtendedData().put("srcField", this.dropedField.get(0));
        createRequest.getExtendedData().put("com.indy.map.diagram.edit.commands.OutlinerCreateCommand.eClass", serdeEClass);
        CompoundCommand cc = new CompoundCommand();
        cc.add(this.editPolicy.getHost().getCommand((Request)createRequest));
        return cc;
    }

    public void dispose() {
        this.dropedField = null;
        this.domain = null;
        this.imgRegistry.dispose();
        super.dispose();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CommandResult cmdResult = super.doExecuteWithResult(progressMonitor, info);
        if (!cmdResult.getStatus().isOK()) {
            return cmdResult;
        }
        Command cmd = null;
        Object type = cmdResult.getReturnValue();
        if (type instanceof List) {
            Object toCreate = ((List)type).get(0);
            Object o = ((List)type).get(1);
            EObject mdNode = null;
            if (o instanceof StagingAreaDescriptor) {
                mdNode = this.domain.getResourceSet().getEObject(((StagingAreaDescriptor)o).getStagingAreaModelURI(), true);
            } else {
                StagingAreaDescriptor desc = StagePreferenceManager.INSTANCE.openStageCandidatePopup(this.editPolicy.getHost().getViewer().getControl().getShell(), new org.eclipse.swt.graphics.Point(this.location.x, this.location.y), true);
                if (desc != null) {
                    mdNode = this.domain.getResourceSet().getEObject(desc.getStagingAreaModelURI(), true);
                }
            }
            if (mdNode != null) {
                if (toCreate.equals(Messages.MapDragDropEditPolicy_3)) {
                    cmd = this.createStageCommand(mdNode);
                } else if (toCreate.equals(Messages.DropStageAreaOnMapPopupCommand_menuCreateDeserializer)) {
                    cmd = this.createSerdeCommand(mdNode, MapPackage.eINSTANCE.getOutliner());
                } else if (toCreate.equals(Messages.DropStageAreaOnMapPopupCommand_menuCreateSerializer)) {
                    cmd = this.createSerdeCommand(mdNode, MapPackage.eINSTANCE.getInliner());
                }
            }
        } else if (Messages.MapDragDropEditPolicy_14.equals(type)) {
            CompoundCommand cc = new CompoundCommand();
            cc.add((Command)new ICommandProxy((ICommand)new AbstractTransactionalCommand(TransactionUtil.getEditingDomain((EObject)((EObject)this.dropedField.get(0))), "", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    Datastore ds = (Datastore)DropFieldOnMapPopupCommand.this.dropedField.get(0).eContainer();
                    ds.getSubsetRootField().add((Object)((Field)DropFieldOnMapPopupCommand.this.dropedField.get(0)));
                    return CommandResult.newOKCommandResult();
                }
            }));
            String hint = "datastore.view";
            IAdaptable elementAdapter = new IAdaptable(){

                public Object getAdapter(Class adapter) {
                    if (adapter == EObject.class) {
                        return DropFieldOnMapPopupCommand.this.dropedField.get(0);
                    }
                    return null;
                }
            };
            CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor(elementAdapter, Node.class, hint, -1, false, this.editPolicy.getDiagramPreferencesHint());
            CreateViewRequest req = new CreateViewRequest(descriptor);
            req.setLocation(this.location);
            cc.add(this.editPolicy.getHost().getCommand((Request)req));
            cmd = cc;
        } else if (Messages.MapDragDropEditPolicy_15.equals(type)) {
            IElementType elementType = ElementTypeRegistry.getInstance().getType("com.indy.gmf.map.diagram.TargetFilter");
            IContainer container = (IContainer)this.dropedField.get(0).eContainer();
            CreateElementRequest req = new CreateElementRequest(elementType);
            req.setParameter("srcField", (Object)this.dropedField.get(0));
            req.setContainer((EObject)container);
            CreateElementCommand cc = new CreateElementCommand(req);
            cmd = new ICommandProxy((ICommand)cc);
        } else {
            CreateViewAndElementRequest.ViewAndElementDescriptor viewDescriptor = new CreateViewAndElementRequest.ViewAndElementDescriptor(new CreateElementRequestAdapter(new CreateElementRequest(MapElementTypes.Filter_2002)), Node.class, ((IHintedType)MapElementTypes.Filter_2002).getSemanticHint(), this.editPolicy.getDiagramPreferencesHint());
            CreateViewAndElementRequest createRequest = new CreateViewAndElementRequest(viewDescriptor);
            createRequest.setLocation(this.location);
            createRequest.getExtendedData().put("srcField", this.dropedField.get(0));
            cmd = this.editPolicy.getHost().getCommand((Request)createRequest);
        }
        if (cmd != null && cmd.canExecute()) {
            cmd.execute();
            this.createCommand = cmd;
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.createCommand != null) {
            this.createCommand.undo();
        }
        return super.doUndoWithResult(progressMonitor, info);
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.createCommand != null) {
            this.createCommand.redo();
        }
        return super.doRedoWithResult(progressMonitor, info);
    }

    private class PopupLabelProvider
    extends LabelProvider {
        private PopupLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof StagingAreaDescriptor) {
                StagingAreaDescriptor stagingAreaDesc = (StagingAreaDescriptor)element;
                return stagingAreaDesc.getLabel();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            LevelCodeInfo i;
            if (element instanceof StagingAreaDescriptor && (i = this.findLevelIcon(((StagingAreaDescriptor)element).getLvlDefType())) != null) {
                Image img = DropFieldOnMapPopupCommand.this.imgRegistry.get(i.getLevelCode());
                if (img == null) {
                    try {
                        DropFieldOnMapPopupCommand.this.imgRegistry.put(i.getLevelCode(), ImageDescriptor.createFromURL((URL)new URL(i.getImageURI().toString())));
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                    img = DropFieldOnMapPopupCommand.this.imgRegistry.get(i.getLevelCode());
                }
                return img;
            }
            return super.getImage(element);
        }

        private LevelCodeInfo findLevelIcon(String lvlDefType) {
            IRegistryService.IRegistry reg = ((IRegistryService)E4InjectorHelper.getService(IRegistryService.class)).getRegistry(LevelCodeInfo.class);
            List l = reg.find((IRegistryService.IRegistryMatcher)new LevelCodeInfo.LevelCodeMatcher(lvlDefType));
            if (l == null || l.isEmpty()) {
                return null;
            }
            LevelCodeInfo candidate = null;
            for (LevelCodeInfo i : l) {
                if (i.getImageURI() == null) continue;
                if (candidate == null) {
                    candidate = i;
                    continue;
                }
                if (!candidate.getImageURI().toString().endsWith("default_icon.gif")) continue;
                candidate = i;
            }
            return candidate;
        }
    }

    private class PopupMenuWithSeparator
    extends PopupMenu {
        List<List<Object>> allContent;

        public PopupMenuWithSeparator(List<List<Object>> aContent, ILabelProvider aLabelProvider) {
            super(Collections.emptyList(), aLabelProvider);
            this.allContent = aContent;
        }

        protected void createMenuItems(Menu parentMenu, PopupMenu rootMenu, List resultThusFar) {
            int i = 0;
            while (i < this.allContent.size()) {
                if (!this.allContent.get(i).isEmpty()) {
                    this.setContent(this.allContent.get(i));
                    super.createMenuItems(parentMenu, rootMenu, resultThusFar);
                }
                ++i;
            }
        }
    }
}

