/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.policies;

import com.indy.gmf.map.diagram.custom.edit.parts.LogicalFieldEditPart;
import com.indy.gmf.map.diagram.custom.edit.parts.util.ActiveSetDescriptorHelper;
import com.indy.gmf.map.diagram.custom.edit.policies.AbstractFieldDndEditPolicy;
import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.DataSet;
import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.MapLocation;
import com.indy.map.SetDescriptor;
import com.indy.map.compute.validator.DataSetInheritanceValidator;
import com.indy.map.compute.validator.DataSetOperatorValidator;
import com.indy.ui.custom.out.services.IDropValidationService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.ui.dialogs.PopupDialog;
import org.eclipse.gmf.runtime.diagram.ui.commands.PopupMenuCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.menus.PopupMenu;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

class PromptFieldDropCommand
extends PopupMenuCommand {
    DropObjectsRequest req;
    private final AbstractFieldDndEditPolicy policy;
    private Command createCommand;

    public PromptFieldDropCommand(boolean filterNux, final AbstractFieldDndEditPolicy policy, DropObjectsRequest req, final List<AbstractFieldDndEditPolicy.CmdKind> cmdKind) {
        super(Messages.AbstractFieldDndEditPolicy_7, Display.getCurrent().getActiveShell());
        this.policy = policy;
        boolean automatedTests = AbstractFieldDndEditPolicy.isAutomatedTest();
        if (!automatedTests && filterNux) {
            automatedTests = !Platform.getOS().equals("win32");
        }
        this.req = req;
        if (!automatedTests) {
            this.setPopupMenu(new PopupMenu(cmdKind, (ILabelProvider)new LabelProvider(){

                public Image getImage(Object element) {
                    return ((AbstractFieldDndEditPolicy.CmdKind)((Object)element)).getImage();
                }

                public String getText(Object element) {
                    return ((AbstractFieldDndEditPolicy.CmdKind)((Object)element)).getLabel();
                }
            }){

                public boolean show(Control parent) {
                    Menu menu = new Menu(parent);
                    this.createMenuItems(menu, this, new ArrayList());
                    menu.setVisible(true);
                    Display display = menu.getDisplay();
                    while (display.readAndDispatch()) {
                    }
                    menu.dispose();
                    return this.getResult() != null;
                }

                protected void createMenuItems(Menu parentMenu, PopupMenu rootMenu, List resultThusFar) {
                    DataSet filteredDataSet;
                    DataSet filterDataSet;
                    boolean canCreateOperation;
                    Field f;
                    super.createMenuItems(parentMenu, rootMenu, resultThusFar);
                    ILogicalField srcObject = (ILogicalField)PromptFieldDropCommand.this.req.getObjects().get(0);
                    ILogicalField trgObject = (ILogicalField)((IGraphicalEditPart)policy.getHost()).resolveSemanticElement();
                    if (!PromptFieldDropCommand.this.checkMappingAllowedOnTrgLocation(srcObject, trgObject) && DataSetInheritanceValidator.INSTANCE.canCreateLink((EObject)((IContainer)srcObject.eContainer()).getDataset(), (EObject)((IContainer)trgObject.eContainer()).getDataset(), true).isError()) {
                        parentMenu.getItem(1).setEnabled(false);
                    }
                    if (trgObject instanceof Field && !policy.fieldCanBeTarget(f = (Field)trgObject)) {
                        parentMenu.getItem(1).setEnabled(false);
                    }
                    boolean bl = canCreateOperation = !DataSetOperatorValidator.INSTANCE.canCreateLink(filterDataSet = ((IContainer)trgObject.eContainer()).getDataset(), filteredDataSet = ((IContainer)srcObject.eContainer()).getDataset()).isError();
                    if (!canCreateOperation) {
                        parentMenu.getItem(2).setEnabled(false);
                    }
                    IDropValidationService s = (IDropValidationService)PlatformUI.getWorkbench().getService(IDropValidationService.class);
                    IDropValidationService.DropResult res = s.validate((EObject)srcObject, (EObject)trgObject, true);
                    MenuItem[] menuItemArray = parentMenu.getItems();
                    int n = menuItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem it = menuItemArray[n2];
                        if (it.getText().equals(AbstractFieldDndEditPolicy.CmdKind.JOIN.getLabel()) && !res.canDrop()) {
                            it.setEnabled(false);
                        }
                        if ((it.getText().equals(AbstractFieldDndEditPolicy.CmdKind.MAP.getLabel()) || it.getText().equals(AbstractFieldDndEditPolicy.CmdKind.MAP_AUTO.getLabel())) && !res.canMap()) {
                            it.setEnabled(false);
                        }
                        if (it.getText().equals(AbstractFieldDndEditPolicy.CmdKind.OPERATOR.getLabel()) && !canCreateOperation) {
                            it.setEnabled(false);
                        }
                        ++n2;
                    }
                }
            });
        } else {
            this.setPopupDialog(new PopupDialog(policy.getHost().getViewer().getControl().getShell(), cmdKind, (ILabelProvider)new LabelProvider()){

                protected void setShellStyle(int newShellStyle) {
                    newShellStyle &= 0xFFFFF79F;
                    newShellStyle &= 0xFFFFFBFF;
                    super.setShellStyle(newShellStyle &= 0xFFFFFFEF);
                }

                protected Rectangle getConstrainedShellBounds(Rectangle preferredSize) {
                    Rectangle r = super.getConstrainedShellBounds(preferredSize);
                    Point p = policy.getHost().getViewer().getControl().toDisplay(PromptFieldDropCommand.this.req.getLocation().x, PromptFieldDropCommand.this.req.getLocation().y);
                    r.x = p.x;
                    r.y = p.y;
                    return r;
                }

                protected void configureShell(Shell shell) {
                    super.configureShell(shell);
                    shell.setData("qa", (Object)"dndPopup");
                    shell.setLocation(PromptFieldDropCommand.this.req.getLocation().x, PromptFieldDropCommand.this.req.getLocation().y);
                }

                protected Control createContents(Composite parent) {
                    Composite c = new Composite(parent, 0);
                    c.setLayout((Layout)new GridLayout());
                    c.setLayoutData((Object)new GridData(1808));
                    for (final AbstractFieldDndEditPolicy.CmdKind kind : cmdKind) {
                        Button b = new Button(c, 8);
                        b.setText(kind.getLabel());
                        b.setLayoutData((Object)new GridData(4, 1, true, false));
                        b.setImage(kind.getImage());
                        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                this.setResult(Collections.singletonList(kind));
                                this.close();
                            }
                        });
                    }
                    return c;
                }
            });
        }
    }

    private boolean checkMappingAllowedOnTrgLocation(ILogicalField srcObject, ILogicalField trgObject) {
        boolean sameDataSet = ((IContainer)srcObject.eContainer()).getDataset() == ((IContainer)trgObject.eContainer()).getDataset();
        SetDescriptor trgCurrentSetDesc = ActiveSetDescriptorHelper.getActiveSetDescriptor((LogicalFieldEditPart)this.policy.getHost());
        Expression trgActiveExpression = trgObject.getExpression(trgCurrentSetDesc);
        return sameDataSet && trgActiveExpression != null && trgActiveExpression.getLocation() == MapLocation.TRG;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CommandResult cmdResult = super.doExecuteWithResult(progressMonitor, info);
        if (!cmdResult.getStatus().isOK()) {
            return cmdResult;
        }
        UnexecutableCommand cmd = null;
        AbstractFieldDndEditPolicy.CmdKind kind = (AbstractFieldDndEditPolicy.CmdKind)((Object)cmdResult.getReturnValue());
        this.req.getExtendedData().put("dropRequest.commandKind", kind);
        switch (kind) {
            case JOIN: {
                cmd = this.policy.createJoinCommand((ILogicalField)this.req.getObjects().get(0));
                break;
            }
            case MAP: 
            case MAP_AUTO: {
                cmd = this.policy.createMappingCommand(this.req);
                break;
            }
            case OPERATOR: {
                cmd = this.policy.createOperatorCommand(this.req);
                break;
            }
            default: {
                cmd = UnexecutableCommand.INSTANCE;
            }
        }
        Assert.isTrue((cmd != null && cmd.canExecute() ? 1 : 0) != 0);
        cmd.execute();
        this.createCommand = cmd;
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.createCommand != null) {
            this.createCommand.undo();
        }
        return super.doUndoWithResult(progressMonitor, info);
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.createCommand != null) {
            this.createCommand.redo();
        }
        return super.doRedoWithResult(progressMonitor, info);
    }
}

