/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.policies;

import com.indy.gmf.map.diagram.custom.edit.parts.ContainerEditPart;
import com.indy.gmf.map.diagram.custom.edit.policies.AbstractPolygonDecorationEditPolicy;
import com.indy.map.IContainer;
import com.indy.map.IReferencable;
import com.indy.map.Map;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import com.indy.map.ref.RContainer;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RTargetSet;
import com.indy.map.ref.RefPackage;
import com.indy.ui.custom.out.Activator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;

@Deprecated
public abstract class TargetSetDecorationEditPolicy
extends AbstractPolygonDecorationEditPolicy {
    public static final String TARGETSET_FEEDBACK_ROLE = "targetSet.role";
    private Adapter targetSetListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (msg.getFeature() == RefPackage.eINSTANCE.getRTargetSet_Container() || msg.getFeature() == RefPackage.eINSTANCE.getRSourceSet_TargetSet() || msg.getFeature() == RefPackage.eINSTANCE.getRMap_TargetSetRef()) {
                TargetSetDecorationEditPolicy.this.refresh();
            }
        }
    };

    private List<Point> getAllPoints(RTargetSet targetSet) {
        ArrayList<IContainer> containers = new ArrayList<IContainer>();
        for (RContainer refC : targetSet.getContainer()) {
            if (containers.contains((IContainer)refC.getDataModel())) continue;
            containers.add((IContainer)refC.getDataModel());
        }
        ArrayList<Point> l = new ArrayList<Point>();
        for (Object ep : ((IGraphicalEditPart)this.getHost()).getChildren()) {
            IGraphicalEditPart child;
            if (!(ep instanceof ContainerEditPart) || !containers.contains((child = (IGraphicalEditPart)ep).resolveSemanticElement())) continue;
            Rectangle bounds = child.getFigure().getBounds().getCopy();
            child.getFigure().translateToAbsolute((Translatable)bounds);
            bounds.expand(10, 10);
            l.add(new Point(bounds.x, bounds.y));
            l.add(new Point(bounds.x + bounds.width, bounds.y));
            l.add(new Point(bounds.x + bounds.width, bounds.y + bounds.height));
            l.add(new Point(bounds.x, bounds.y + bounds.height));
        }
        return l;
    }

    @Override
    public void refresh() {
        this.clearFigures();
        Map map = (Map)((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
        for (RTargetSet ds : ((RMap)map.getMapReference()).getTargetSetRef()) {
            List<Point> pointList = this.quickHull(this.getAllPoints(ds));
            if (pointList.isEmpty()) continue;
            PointList pl = new PointList();
            for (Point pt : pointList) {
                pl.addPoint(pt);
            }
            final Point ref = pl.getBounds().getCenter();
            Collections.sort(pointList, new Comparator<Point>(){

                @Override
                public int compare(Point o1, Point o2) {
                    double aTanB;
                    double aTanA = Math.atan2(o1.y - ref.y, o1.x - ref.x);
                    if (aTanA < (aTanB = Math.atan2(o2.y - ref.y, o2.x - ref.x))) {
                        return -1;
                    }
                    if (aTanB < aTanA) {
                        return 1;
                    }
                    return 0;
                }
            });
            pl = new PointList();
            for (Point pt : pointList) {
                this.getLayer("customSetLayer").translateToRelative((Translatable)pt);
                pl.addPoint(pt);
            }
            pl = PointListUtilities.calcSmoothPolyline((PointList)pl, (int)32, (int)16);
            IFigure polygon = this.createPolygon(pl);
            this.addPolygon(polygon);
            this.getLayer("customSetLayer").add(polygon);
        }
    }

    @Override
    protected IFigure createPolygon(PointList points) {
        Polygon polygon = new Polygon();
        polygon.setPoints(points);
        RGB color = PreferenceConverter.getColor((IPreferenceStore)MapDiagramEditorPlugin.getInstance().getPreferenceStore(), (String)"Appearance.targetColor");
        polygon.setBackgroundColor(Activator.getDefault().getColor(color));
        polygon.setForegroundColor(polygon.getBackgroundColor());
        polygon.setFill(true);
        polygon.setAlpha(55);
        return polygon;
    }

    @Override
    protected Adapter createSemanticAdapter() {
        AdapterImpl adapter = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
            }
        };
        return adapter;
    }

    @Override
    protected void registerSemanticAdapter(EObject obj) {
        super.registerSemanticAdapter(obj);
        if (obj instanceof IContainer) {
            ((RContainer)((IReferencable)obj).getMapReference()).eAdapters().add((Object)this.targetSetListener);
            ((RContainer)((IReferencable)obj).getMapReference()).eContainer().eAdapters().add((Object)this.targetSetListener);
        }
    }

    @Override
    protected void unregisterSemanticAdapter(EObject obj) {
        super.unregisterSemanticAdapter(obj);
        if (obj instanceof IContainer) {
            ((RContainer)((IReferencable)obj).getMapReference()).eContainer().eAdapters().remove((Object)this.targetSetListener);
            ((RContainer)((IReferencable)obj).getMapReference()).eAdapters().remove((Object)this.targetSetListener);
        }
    }
}

