/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.policies;

import com.indy.gmf.map.diagram.custom.edit.parts.ClauseEditPart;
import com.indy.gmf.map.diagram.custom.edit.parts.ContainerEditPart;
import com.indy.gmf.map.diagram.custom.edit.parts.LogicalFieldEditPart;
import com.indy.gmf.map.diagram.custom.preferences.MapPreferenceConstants;
import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.ILogicalField;
import com.indy.map.IReferencable;
import com.indy.map.Map;
import com.indy.map.MapModelItem;
import com.indy.map.compute.graph.Graph;
import com.indy.map.compute.graph.Vertice;
import com.indy.map.diagram.edit.parts.ComputedFieldEditPart;
import com.indy.map.diagram.edit.parts.FieldEditPart;
import com.indy.map.diagram.edit.parts.InputParameterEditPart;
import com.indy.map.diagram.edit.parts.VariableEditPart;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import com.indy.map.ref.RClause;
import com.indy.map.ref.RComputedField;
import com.indy.map.ref.RExpression;
import com.indy.map.ref.RItem;
import com.indy.map.ref.RLogicalField;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RUsage;
import com.indy.map.ref.RefPackage;
import com.indy.ui.custom.out.Activator;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transform;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class UsageConnectionEditPolicy
extends GraphicalEditPolicy
implements ISelectionChangedListener,
IPropertyChangeListener {
    public static final int CIRCLE_CONNECTION_DECORATION_RADIUS = 3;
    public static final String USAGE_DATA_ROLE = "com.indy.gmf.map.diagram.custom.edit.policies.USAGE_DATA_ROLE";
    private List<IFigure> figures = new ArrayList<IFigure>();
    private List<WeakReference<MapModelItem>> currentSelectedRef = new ArrayList<WeakReference<MapModelItem>>();
    private List<WeakReference<IGraphicalEditPart>> currentDescendant = new ArrayList<WeakReference<IGraphicalEditPart>>();
    private List<WeakReference<IGraphicalEditPart>> currentAscendant = new ArrayList<WeakReference<IGraphicalEditPart>>();
    private EContentAdapter refAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            boolean refresh = false;
            if (notification.getFeature() == RefPackage.eINSTANCE.getRUsage_SourceRef() || notification.getFeature() == RefPackage.eINSTANCE.getRSourceItem_Usage()) {
                refresh = true;
            }
            if (refresh) {
                UsageConnectionEditPolicy.this.hideFigures();
                UsageConnectionEditPolicy.this.computeUsageGraph();
                UsageConnectionEditPolicy.this.showFigures();
            }
        }
    };
    private static final Color decorationColor = new Color(null, 0, 80, 124);
    public static final Color myGray = new Color(null, 160, 160, 160);

    private void computeUsageGraph() {
        this.currentDescendant.clear();
        this.currentAscendant.clear();
        this.currentSelectedRef.clear();
        this.figures.clear();
        if (!this.isEnabled()) {
            return;
        }
        ArrayList<IGraphicalEditPart[]> edges = new ArrayList<IGraphicalEditPart[]>();
        Graph graph = new Graph();
        for (Object o : this.getHost().getViewer().getSelectedEditParts()) {
            if (!(o instanceof LogicalFieldEditPart) && !(o instanceof InputParameterEditPart) && !(o instanceof VariableEditPart) && !(o instanceof ComputedFieldEditPart)) continue;
            graph.createVertice(o);
            this.buildGraphBranchAsc(graph, (IGraphicalEditPart)o, edges, 0);
            this.buildGraphBranchDesc(graph, (IGraphicalEditPart)o, edges, 0);
            MapModelItem model = (MapModelItem)((IGraphicalEditPart)o).resolveSemanticElement();
            this.currentSelectedRef.add(new WeakReference<MapModelItem>(model));
        }
        for (IGraphicalEditPart[] e : edges) {
            if (e[0] instanceof LogicalFieldEditPart && e[1] instanceof LogicalFieldEditPart && e[0].getParent().getParent() == e[1].getParent().getParent()) continue;
            PolylineConnectionEx poly = new PolylineConnectionEx();
            poly.setLineWidth(1);
            poly.setForegroundColor(myGray);
            poly.setLineStyle(6);
            poly.setLineDash(new int[]{3, 2});
            poly.setAntialias(1);
            poly.setRoutingStyles(false, true);
            poly.setSmoothness(32);
            poly.setJumpLinks(false);
            poly.setTargetDecoration((RotatableDecoration)new CircleDecoration((IFigure)poly));
            poly.setSourceAnchor((ConnectionAnchor)new CustomAcnhor((GraphicalEditPart)e[0]));
            poly.setTargetAnchor((ConnectionAnchor)new CustomAcnhor((GraphicalEditPart)e[1]));
            if (!e[0].getFigure().isVisible()) {
                PolygonDecoration dec = new PolygonDecoration(){

                    public void setRotation(double angle) {
                    }
                };
                PointList pl = new PointList();
                pl.addPoint(-1, 0);
                pl.addPoint(1, 0);
                pl.addPoint(0, 1);
                pl.addPoint(-1, 0);
                dec.setScale(7.0, 7.0);
                dec.setTemplate(pl);
                dec.setForegroundColor(decorationColor);
                poly.setSourceDecoration((RotatableDecoration)dec);
            }
            this.figures.add((IFigure)poly);
        }
    }

    protected IMapMode getMapMode() {
        RootEditPart root = this.getHost().getRoot();
        if (root instanceof DiagramRootEditPart) {
            DiagramRootEditPart dgrmRoot = (DiagramRootEditPart)root;
            return dgrmRoot.getMapMode();
        }
        return MapModeUtil.getMapMode();
    }

    private void buildGraphBranchDesc(Graph graph, IGraphicalEditPart o, List<IGraphicalEditPart[]> edges, int recursionLvl) {
        RItem refItem;
        if (o == null) {
            return;
        }
        Vertice start = graph.getVertice((Object)o);
        EObject eObject = o.resolveSemanticElement();
        if (eObject instanceof IReferencable && (refItem = (RItem)((IReferencable)eObject).getMapReference()) instanceof RSourceItem) {
            for (RUsage usage : ((RSourceItem)refItem).getUsage()) {
                Vertice target;
                EditPart ep;
                MapModelItem it;
                if (usage instanceof RExpression || usage instanceof RComputedField) {
                    it = usage.getDataModel();
                    if (it instanceof Expression && it.eContainer() instanceof ILogicalField) {
                        it = (MapModelItem)it.eContainer();
                    }
                    if ((ep = o.findEditPart((EditPart)o.getRoot(), (EObject)it)) == null && it instanceof ILogicalField) {
                        it = (MapModelItem)it.eContainer();
                        ep = o.findEditPart((EditPart)o.getRoot(), (EObject)it);
                        if (ep == null) continue;
                    }
                    target = null;
                    target = graph.getVertice((Object)ep);
                    if (target == null) {
                        target = graph.createVertice((Object)ep);
                    }
                    graph.createEdge(start, target);
                    boolean edgeExists = false;
                    for (IGraphicalEditPart[] e : edges) {
                        if (e[0] != ep || e[1] != o) continue;
                        edgeExists = true;
                        break;
                    }
                    if (edgeExists) continue;
                    if (o != null && ep != null) {
                        edges.add(new IGraphicalEditPart[]{o, (IGraphicalEditPart)ep});
                    }
                    if (recursionLvl > 0) {
                        this.currentDescendant.add(new WeakReference<IGraphicalEditPart>((IGraphicalEditPart)ep));
                    }
                    if (!(usage.eContainer() instanceof RSourceItem) && !(usage instanceof RSourceItem)) continue;
                    this.buildGraphBranchDesc(graph, (IGraphicalEditPart)ep, edges, recursionLvl + 1);
                    continue;
                }
                if (!(usage instanceof RClause)) continue;
                it = usage.getDataModel();
                if (it instanceof Expression) {
                    it = (MapModelItem)it.eContainer();
                }
                if ((ep = o.findEditPart((EditPart)o.getRoot(), (EObject)it)) == null && it instanceof ILogicalField) {
                    it = (MapModelItem)it.eContainer();
                    ep = o.findEditPart((EditPart)o.getRoot(), (EObject)it);
                    if (ep == null) continue;
                }
                target = null;
                target = graph.getVertice((Object)ep);
                if (target == null) {
                    target = graph.createVertice((Object)ep);
                }
                graph.createEdge(start, target);
                if (o == null || ep == null) continue;
                edges.add(new IGraphicalEditPart[]{o, (IGraphicalEditPart)ep});
            }
        }
    }

    private void buildGraphBranchAsc4Src(Vertice start, RSourceItem src, Graph graph, IGraphicalEditPart o, List<IGraphicalEditPart[]> edges, int recursionLvl) {
        if (o == null) {
            return;
        }
        MapModelItem it = src.getDataModel();
        EditPart ep = o.findEditPart((EditPart)o.getRoot(), (EObject)it);
        if (ep == null && it instanceof ILogicalField) {
            it = (MapModelItem)it.eContainer();
            ep = o.findEditPart((EditPart)o.getRoot(), (EObject)it);
            if (ep == null) {
                return;
            }
        }
        Vertice source = null;
        source = graph.getVertice((Object)ep);
        if (source == null) {
            source = graph.createVertice((Object)ep);
        }
        graph.createEdge(source, start);
        boolean edgeExists = false;
        for (IGraphicalEditPart[] e : edges) {
            if (e[0] != ep || e[1] != o) continue;
            edgeExists = true;
            break;
        }
        if (!edgeExists) {
            if (o != null && ep != null) {
                edges.add(new IGraphicalEditPart[]{(IGraphicalEditPart)ep, o});
            }
            if (ep != null) {
                this.buildGraphBranchAsc(graph, (IGraphicalEditPart)ep, edges, recursionLvl + 1);
                if (recursionLvl > 0) {
                    this.currentAscendant.add(new WeakReference<IGraphicalEditPart>((IGraphicalEditPart)ep));
                }
            }
        }
    }

    private void buildGraphBranchAsc(Graph graph, IGraphicalEditPart o, List<IGraphicalEditPart[]> edges, int recursionLvl) {
        RItem _refItem;
        if (o == null) {
            return;
        }
        Vertice start = graph.getVertice((Object)o);
        EObject eObject = o.resolveSemanticElement();
        if (eObject instanceof IReferencable && (_refItem = (RItem)((IReferencable)eObject).getMapReference()) instanceof RLogicalField) {
            for (RExpression refItem : ((RLogicalField)_refItem).getExpressionRef()) {
                if (!(refItem instanceof RUsage)) continue;
                for (RSourceItem src : refItem.getSourceRef()) {
                    this.buildGraphBranchAsc4Src(start, src, graph, o, edges, recursionLvl);
                }
            }
            if (_refItem instanceof RUsage) {
                for (RSourceItem src : ((RUsage)_refItem).getSourceRef()) {
                    this.buildGraphBranchAsc4Src(start, src, graph, o, edges, recursionLvl);
                }
            }
        }
    }

    public void activate() {
        super.activate();
        MapDiagramEditorPlugin.getInstance().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.getHost().getViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        try {
            Map it = (Map)((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
            ((RMap)it.getMapReference()).eAdapters().add((Object)this.refAdapter);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deactivate() {
        MapDiagramEditorPlugin.getInstance().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        try {
            Map it = (Map)((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
            if (it != null) {
                ((RMap)it.getMapReference()).eAdapters().remove((Object)this.refAdapter);
            }
        }
        catch (Exception it) {
            // empty catch block
        }
        for (IFigure f : this.figures) {
            if (f.getParent() == null) continue;
            this.getLayer("Connection Layer").remove(f);
        }
        this.getHost().getViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        super.deactivate();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.refresh();
    }

    public void refresh() {
        this.hideFigures();
        this.computeUsageGraph();
        this.showFigures();
    }

    private void hideFigures() {
        RGB color = PreferenceConverter.getColor((IPreferenceStore)MapDiagramEditorPlugin.getInstance().getPreferenceStore(), (String)"Appearance.targetColorLight");
        for (WeakReference<IGraphicalEditPart> ref : this.currentDescendant) {
            IGraphicalEditPart gep = (IGraphicalEditPart)ref.get();
            if (gep == null || gep.getFigure().getBackgroundColor() == null || !gep.getFigure().getBackgroundColor().getRGB().equals((Object)color)) continue;
            gep.getFigure().setBackgroundColor(ColorConstants.white);
            gep.getFigure().setForegroundColor(ColorConstants.black);
            gep.getFigure().setOpaque(true);
        }
        RGB color2 = PreferenceConverter.getColor((IPreferenceStore)MapDiagramEditorPlugin.getInstance().getPreferenceStore(), (String)"Appearance.sourceColorLight");
        for (WeakReference<IGraphicalEditPart> ref : this.currentAscendant) {
            IGraphicalEditPart gep = (IGraphicalEditPart)ref.get();
            if (gep == null || gep.getFigure().getBackgroundColor() == null || !gep.getFigure().getBackgroundColor().getRGB().equals((Object)color2)) continue;
            gep.getFigure().setBackgroundColor(ColorConstants.white);
            gep.getFigure().setForegroundColor(ColorConstants.black);
            gep.getFigure().setOpaque(true);
        }
        for (IFigure f : this.figures) {
            if (f.getParent() == null) continue;
            this.getLayer("Connection Layer").remove(f);
        }
    }

    protected boolean isEnabled() {
        return MapPreferenceConstants.getBoolean("mapShowUsageConnection");
    }

    private void showFigures() {
        for (IFigure f : this.figures) {
            this.getLayer("Connection Layer").add(f);
        }
        RGB color = PreferenceConverter.getColor((IPreferenceStore)MapDiagramEditorPlugin.getInstance().getPreferenceStore(), (String)"Appearance.targetColorLight");
        for (WeakReference<IGraphicalEditPart> r : this.currentDescendant) {
            IGraphicalEditPart gep = (IGraphicalEditPart)r.get();
            if (gep instanceof ContainerEditPart) continue;
            gep.getFigure().setBackgroundColor(Activator.getDefault().getColor(color));
            gep.getFigure().setForegroundColor(ColorConstants.white);
            gep.getFigure().setOpaque(true);
        }
        RGB color2 = PreferenceConverter.getColor((IPreferenceStore)MapDiagramEditorPlugin.getInstance().getPreferenceStore(), (String)"Appearance.sourceColorLight");
        for (WeakReference<IGraphicalEditPart> r : this.currentAscendant) {
            IGraphicalEditPart gep = (IGraphicalEditPart)r.get();
            if (gep instanceof ContainerEditPart) continue;
            gep.getFigure().setBackgroundColor(Activator.getDefault().getColor(color2));
            gep.getFigure().setForegroundColor(ColorConstants.white);
            gep.getFigure().setOpaque(true);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("mapShowUsageConnection")) {
            this.hideFigures();
            this.computeUsageGraph();
            this.showFigures();
        }
    }

    private static class CircleDecoration
    extends Ellipse
    implements RotatableDecoration {
        private Transform transform = new Transform();
        private IFigure figure;

        public CircleDecoration(IFigure figure) {
            this.figure = figure;
        }

        public void setReferencePoint(Point p) {
            Point _pt = ((Connection)this.figure).getPoints().getPoint(((Connection)this.figure).getPoints().size() - 1);
            Point pt = Point.SINGLETON;
            pt.setLocation(_pt);
            pt.negate().translate(this.getLocation());
            this.transform.setRotation(Math.atan2(pt.y, pt.x));
            Point pp = this.transform.getTransformed(new Point(-3, -3));
            Rectangle r = new Rectangle(pp.x, pp.y, 6, 6);
            this.setBounds(r);
        }

        public void setLocation(Point p) {
            Point pt = ((Connection)this.figure).getPoints().getPoint(((Connection)this.figure).getPoints().size() - 1);
            super.setLocation(new Point(pt.x, pt.y));
            this.transform.setTranslation((double)pt.x, (double)pt.y);
        }
    }

    private class CustomAcnhor
    extends ChopboxAnchor {
        private GraphicalEditPart containerEp;
        private GraphicalEditPart fieldParentVisible;

        CustomAcnhor(GraphicalEditPart owner) {
            super(owner.getFigure());
            GraphicalEditPart ep = owner;
            while (!(ep instanceof ContainerEditPart || ep instanceof ClauseEditPart || ep instanceof VariableEditPart || ep instanceof InputParameterEditPart)) {
                ep = (GraphicalEditPart)ep.getParent();
            }
            this.containerEp = ep;
            if (owner instanceof FieldEditPart && !((FieldEditPart)owner).getFigure().isVisible()) {
                Field f = (Field)((FieldEditPart)owner).resolveSemanticElement();
                f = f.getParent();
                ep = null;
                while (f != null) {
                    ep = (GraphicalEditPart)((FieldEditPart)owner).findEditPart(owner.getParent(), (EObject)f);
                    if (ep == null || ep.getFigure().isVisible()) break;
                    f = f.getParent();
                }
                if (ep != null) {
                    this.fieldParentVisible = ep;
                }
            }
        }

        public IFigure getOwner() {
            if (!super.getOwner().isVisible() && this.fieldParentVisible != null) {
                return this.fieldParentVisible.getFigure();
            }
            return super.getOwner();
        }

        public Point getLocation(Point reference) {
            Point pt = super.getLocation(reference);
            this.getOwner().translateToAbsolute((Translatable)pt);
            Rectangle r = this.containerEp.getFigure().getBounds().getCopy();
            this.containerEp.getFigure().translateToAbsolute((Translatable)r);
            Point center = this.getReferencePoint().getCopy();
            pt.x = reference.x >= center.x ? r.x + r.width : r.x;
            pt.y = center.y;
            if (pt.y < r.y) {
                pt.y = r.y;
            } else if (pt.y > r.y + r.height) {
                pt.y = r.y + r.height;
            }
            return pt;
        }
    }
}

