/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.filters;

import com.indy.map.Datastore;
import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.Inliner;
import com.indy.map.MapPackage;
import com.indy.map.Outliner;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EStructuralFeature;

public class FieldSelectorAdapter {
    private IContainer container;
    private boolean selectorEnabled;
    private boolean isSynchronized;
    private boolean hierarchical;
    private EStructuralFeature fieldsFeature;
    private EStructuralFeature synchronizedFeature;
    private EStructuralFeature fieldSelectorEnabledFeature;

    public static FieldSelectorAdapter create(IContainer c) {
        Assert.isTrue((c instanceof Datastore || c instanceof Outliner ? 1 : 0) != 0, (String)"Can only be used on Datastore or Outliner");
        if (c instanceof Datastore) {
            return new FieldSelectorAdapter(c, ((Datastore)c).isFieldSelectorEnabled(), ((Datastore)c).isSynchronized(), ((Datastore)c).isHierarchical(), (EStructuralFeature)MapPackage.eINSTANCE.getDatastore_Field(), (EStructuralFeature)MapPackage.eINSTANCE.getDatastore_Synchronized(), (EStructuralFeature)MapPackage.eINSTANCE.getDatastore_FieldSelectorEnabled());
        }
        if (c instanceof Outliner) {
            return new FieldSelectorAdapter(c, ((Outliner)c).isFieldSelectorEnabled(), ((Outliner)c).isSynchronized(), true, (EStructuralFeature)MapPackage.eINSTANCE.getOutliner_OutputField(), (EStructuralFeature)MapPackage.eINSTANCE.getOutliner_Synchronized(), (EStructuralFeature)MapPackage.eINSTANCE.getOutliner_FieldSelectorEnabled());
        }
        if (c instanceof Inliner) {
            Inliner inliner = (Inliner)c;
            return new FieldSelectorAdapter(c, inliner.isFieldSelectorEnabled(), inliner.isSynchronized(), true, (EStructuralFeature)MapPackage.eINSTANCE.getInliner_InputField(), (EStructuralFeature)MapPackage.eINSTANCE.getInliner_Synchronized(), (EStructuralFeature)MapPackage.eINSTANCE.getInliner_FieldSelectorEnabled());
        }
        return null;
    }

    FieldSelectorAdapter(IContainer container, boolean selectorEnabled, boolean isSynchronized, boolean hierarchical, EStructuralFeature fieldsFeature, EStructuralFeature synchronizedFeature, EStructuralFeature fieldSelectorEnabledFeature) {
        this.container = container;
        this.selectorEnabled = selectorEnabled;
        this.isSynchronized = isSynchronized;
        this.hierarchical = hierarchical;
        this.fieldsFeature = fieldsFeature;
        this.synchronizedFeature = synchronizedFeature;
        this.fieldSelectorEnabledFeature = fieldSelectorEnabledFeature;
    }

    boolean isFieldSelectorEnabled() {
        return this.selectorEnabled;
    }

    boolean isSynchronized() {
        return this.isSynchronized;
    }

    List<Field> getFields() {
        return (List)this.container.eGet(this.fieldsFeature);
    }

    boolean isHierarchical() {
        return this.hierarchical;
    }

    EStructuralFeature getFieldsFeature() {
        return this.fieldsFeature;
    }

    EStructuralFeature getSynchronizedFeature() {
        return this.synchronizedFeature;
    }

    EStructuralFeature getFieldSelectorEnabledFeature() {
        return this.fieldSelectorEnabledFeature;
    }

    IContainer getIContainer() {
        return this.container;
    }
}

