/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.providers;

import com.indy.gmf.map.diagram.custom.edit.parts.ContainerEditPart;
import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.IContainer;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.AbstractDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.CreateDecoratorsOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class MappingDecoratorProvider
extends AbstractProvider
implements IDecoratorProvider {
    protected ResourceManager getResourceManager(IGraphicalEditPart gep) {
        EditPartViewer viewer = gep.getViewer();
        if (viewer instanceof DiagramGraphicalViewer) {
            return ((DiagramGraphicalViewer)viewer).getResourceManager();
        }
        return JFaceResources.getResources();
    }

    protected Font getFont(IGraphicalEditPart gep, FontData fontData) {
        try {
            Font newFont = (Font)this.getResourceManager(gep).get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData)fontData));
            if (newFont == null) {
                newFont = this.getResourceManager(gep).createFont(FontDescriptor.createFrom((FontData)fontData));
            }
            return newFont;
        }
        catch (DeviceResourceException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"setFont", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"setFont", (Throwable)e);
            return null;
        }
    }

    public boolean provides(IOperation operation) {
        if (!(operation instanceof CreateDecoratorsOperation)) {
            return false;
        }
        IDecoratorTarget decoratorTarget = ((CreateDecoratorsOperation)operation).getDecoratorTarget();
        return decoratorTarget.getAdapter(View.class) != null;
    }

    public void createDecorators(IDecoratorTarget decoratorTarget) {
        EditPart ep = (EditPart)decoratorTarget.getAdapter(EditPart.class);
        if (ep != null && ep instanceof ContainerEditPart) {
            decoratorTarget.installDecorator((Object)"mappingOrder", (IDecorator)new ContainerOrderDecorator(decoratorTarget));
        }
    }

    public class ContainerOrderDecorator
    extends AbstractDecorator {
        public static final String MAPPING_ORDER_DECORATION = "mappingOrder";

        public ContainerOrderDecorator(IDecoratorTarget decoratorTarget) {
            super(decoratorTarget);
        }

        public void activate() {
            this.refresh();
        }

        public void refresh() {
            try {
                this.removeDecoration();
                ContainerEditPart editPart = (ContainerEditPart)this.getDecoratorTarget().getAdapter(EditPart.class);
                if (editPart == null || !editPart.isActive() || editPart.getModel() == null) {
                    return;
                }
                EObject o = editPart.resolveSemanticElement();
                if (!(o instanceof IContainer)) {
                    return;
                }
                IContainer c = (IContainer)o;
                if (c == null) {
                    return;
                }
                int i = c.getPriorityOrder();
                if (i <= 0) {
                    return;
                }
                IGraphicalEditPart gep = editPart.getChildBySemanticHint("5005");
                if (gep == null) {
                    editPart.getChildBySemanticHint("5001");
                }
                if (gep == null) {
                    editPart.getChildBySemanticHint("5090");
                }
                Figure figure = new Figure();
                figure.setSize(new Dimension(16, 16));
                figure.setLayoutManager((LayoutManager)new StackLayout());
                Label label = new Label();
                label.setText("" + ((IContainer)editPart.resolveSemanticElement()).getPriorityOrder());
                figure.add((IFigure)label);
                label.setForegroundColor(ColorConstants.black);
                this.setDecoration(this.getDecoratorTarget().addShapeDecoration((IFigure)figure, IDecoratorTarget.Direction.NORTH_WEST, 0, false));
            }
            catch (Exception ex) {
                MapDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(2, "com.indy.gmf.map.diagram", Messages.MappingDecoratorProvider_4, (Throwable)ex));
            }
        }
    }
}

