/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.services;

import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.Clause;
import com.indy.map.DataSet;
import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.IMetaData;
import com.indy.map.ISerde;
import com.indy.map.Inliner;
import com.indy.map.Join;
import com.indy.map.JoinLocation;
import com.indy.map.Map;
import com.indy.map.Operator;
import com.indy.map.Outliner;
import com.indy.map.QueryField;
import com.indy.map.SerdeField;
import com.indy.map.Variable;
import com.indy.map.compute.validator.DataSetInheritanceValidator;
import com.indy.map.compute.validator.ILinkValidator;
import com.indy.map.compute.validator.JoinValidator;
import com.indy.map.compute.validator.MappingValidator;
import com.indy.map.util.InheritanceHelper;
import com.indy.ui.custom.out.Util;
import com.indy.ui.custom.out.services.IDropValidationService;
import com.stambia.md.MdNode;
import com.stambia.tech.MappingType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.ui.util.StatusLineUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class MapDropValidationService
implements IDropValidationService {
    private boolean isSerdeFieldMappable(ISerde owner, ILogicalField field) {
        if (field instanceof SerdeField) {
            return true;
        }
        if (owner instanceof Outliner) {
            Outliner outliner = (Outliner)owner;
            return outliner.getInputField() == field;
        }
        if (owner instanceof Inliner) {
            Inliner inliner = (Inliner)owner;
            return inliner.getInputField().contains((Object)field);
        }
        return false;
    }

    protected boolean fieldCanBeTarget(ILogicalField f) {
        MdNode containerMdNode;
        MdNode mdNode;
        EObject eObject = f.eContainer();
        if (eObject instanceof ISerde) {
            ISerde serde = (ISerde)eObject;
            return this.isSerdeFieldMappable(serde, f);
        }
        EObject ref = ((IMetaData)f).getRef();
        if (ref instanceof MdNode && (mdNode = (MdNode)ref).getLevel() != null && (mdNode.getMappingType().contains(MappingType.MAPPING) || mdNode.getMappingType().contains(MappingType.TARGET_MAPPING)) && (ref = ((IMetaData)f.eContainer()).getRef()) instanceof MdNode && (containerMdNode = (MdNode)ref).getLevel() != null) {
            return ((MdNode)ref).getMappingType().contains(MappingType.TARGET);
        }
        return true;
    }

    private IDropValidationService.DropResult createDropResult(boolean canJoin, boolean canMap, boolean updateStatusLine, String errorMessage) {
        if (!canJoin && !canMap) {
            if (updateStatusLine) {
                StatusLineUtil.outputErrorMessage((IWorkbenchPart)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor(), (String)errorMessage);
            }
            return IDropValidationService.DropResult.NONE;
        }
        if (updateStatusLine) {
            StatusLineUtil.outputErrorMessage((IWorkbenchPart)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor(), (String)"");
        }
        if (canJoin && canMap) {
            return IDropValidationService.DropResult.MAP_JOIN_ALLOWED;
        }
        if (canJoin) {
            return IDropValidationService.DropResult.JOIN_ALLOWED;
        }
        return IDropValidationService.DropResult.MAP_ALLOWED;
    }

    private IDropValidationService.DropResult validateDropOnExpression(boolean updateStatusLine, Expression expression, EObject draggedObject) {
        ILinkValidator.ValidationStatus status = null;
        StringBuilder errorMessage = new StringBuilder();
        boolean canJoin = false;
        boolean canMap = false;
        if (!this.fieldCanBeTarget((ILogicalField)expression.eContainer())) {
            canMap = false;
            errorMessage.append(Messages.MapDropValidationService_5);
        } else {
            IContainer targetContainer = (IContainer)expression.eContainer().eContainer();
            IContainer srcContainer = (IContainer)draggedObject.eContainer();
            status = JoinValidator.INSTANCE.canCreateLink((EObject)srcContainer, (EObject)targetContainer);
            if (status != ILinkValidator.ValidationStatus.createOkStatus() && targetContainer.getDataset() != srcContainer.getDataset() && (targetContainer.getDataset().getParent().contains((Object)srcContainer.getDataset()) || targetContainer.getDataset().getChild().contains((Object)srcContainer.getDataset())) && ((Map)targetContainer.eContainer()).hasJoin(targetContainer, srcContainer) && Util.currentKeyPressed != 262144) {
                status = ILinkValidator.ValidationStatus.createOkStatus();
            }
            if (status == ILinkValidator.ValidationStatus.createOkStatus() && Util.currentKeyPressed == 65536) {
                status = DataSetInheritanceValidator.INSTANCE.canCreateLink((EObject)targetContainer.getDataset(), (EObject)srcContainer.getDataset(), Util.currentKeyPressed == 65536);
            }
            boolean bl = canJoin = !status.isError();
            if (!canJoin) {
                errorMessage.append(status.getMessage());
                errorMessage.append(".");
            }
            boolean bl2 = canMap = !(status = MappingValidator.INSTANCE.canCreateLink((EObject)srcContainer, (EObject)targetContainer)).isError();
            if (!canMap) {
                errorMessage.append(status.getMessage());
                errorMessage.append(".");
            }
        }
        return this.createDropResult(canJoin, canMap, updateStatusLine, errorMessage.toString());
    }

    private IDropValidationService.DropResult validateDropOnLogicalField(boolean updateStatusLine, ILogicalField targetObject, EObject draggedObject) {
        ILinkValidator.ValidationStatus status = null;
        StringBuilder errorMessage = new StringBuilder();
        boolean canJoin = false;
        boolean canMap = false;
        IContainer targetContainer = (IContainer)targetObject.eContainer();
        if (draggedObject instanceof ILogicalField) {
            IContainer srcContainer = (IContainer)draggedObject.eContainer();
            status = JoinValidator.INSTANCE.canCreateLink((EObject)srcContainer, (EObject)targetContainer);
            if (status != ILinkValidator.ValidationStatus.createOkStatus() && targetContainer.getDataset() != srcContainer.getDataset() && (targetContainer.getDataset().getParent().contains((Object)srcContainer.getDataset()) || targetContainer.getDataset().getChild().contains((Object)srcContainer.getDataset())) && ((Map)targetContainer.eContainer()).hasJoin(targetContainer, srcContainer) && Util.currentKeyPressed != 262144) {
                status = ILinkValidator.ValidationStatus.createOkStatus();
            }
            if (status == ILinkValidator.ValidationStatus.createOkStatus() && Util.currentKeyPressed == 65536) {
                status = DataSetInheritanceValidator.INSTANCE.canCreateLink((EObject)targetContainer.getDataset(), (EObject)srcContainer.getDataset(), Util.currentKeyPressed == 65536);
            }
            if (!status.isError() && targetContainer instanceof ISerde && !(targetObject instanceof SerdeField) && (targetContainer instanceof Outliner && targetObject instanceof Field || targetContainer instanceof Inliner && targetObject instanceof QueryField)) {
                status = ILinkValidator.ValidationStatus.createErrorStatus((String)"Serde ouputs cannot be joined");
            }
            boolean bl = canJoin = !status.isError();
            if (!canJoin) {
                errorMessage.append(status.getMessage());
                errorMessage.append(".");
            }
            if (this.fieldCanBeTarget(targetObject)) {
                status = MappingValidator.INSTANCE.canCreateLink((EObject)srcContainer, (EObject)targetContainer);
                boolean bl2 = canMap = !status.isError();
                if (!canMap) {
                    errorMessage.append(status.getMessage());
                    errorMessage.append(".");
                }
            } else {
                canMap = false;
                errorMessage.append(Messages.MapDropValidationService_12);
            }
        }
        return this.createDropResult(canJoin, canMap, updateStatusLine, errorMessage.toString());
    }

    private IDropValidationService.DropResult validateDropOnClause(boolean updateStatusLine, Clause clause, EObject draggedObject) {
        StringBuilder errorMessage = new StringBuilder();
        ILinkValidator.ValidationStatus status = null;
        boolean canJoin = false;
        boolean canMap = false;
        if (draggedObject instanceof ILogicalField) {
            if (clause instanceof Join) {
                for (IContainer c : clause.getInvolvedContainers()) {
                    status = JoinValidator.INSTANCE.canCreateLink(draggedObject.eContainer(), (EObject)c);
                    if (status.isError()) break;
                }
                if (status != ILinkValidator.ValidationStatus.createOkStatus()) {
                    IContainer srcContainer = (IContainer)draggedObject.eContainer();
                    for (IContainer c : clause.getInvolvedContainers()) {
                        if (c.getDataset() == srcContainer.getDataset() || !c.getDataset().getParent().contains((Object)srcContainer.getDataset())) continue;
                        status = ILinkValidator.ValidationStatus.createOkStatus();
                    }
                }
            } else {
                if (clause instanceof Operator) {
                    if (!InheritanceHelper.getDataSetHierarchy((DataSet)((Operator)clause).getFilteredDataSet()).contains(((IContainer)draggedObject.eContainer()).getDataset()) && !InheritanceHelper.getDataSetHierarchy((DataSet)((Operator)clause).getFilteringDataSet()).contains(((IContainer)draggedObject.eContainer()).getDataset())) {
                        status = ILinkValidator.ValidationStatus.createErrorStatus((String)Messages.MapDropValidationService_0);
                    }
                } else if (!clause.getInvolvedContainers().isEmpty() && ((IContainer)clause.getInvolvedContainers().get(0)).getDataset() != ((IContainer)draggedObject.eContainer()).getDataset()) {
                    status = ILinkValidator.ValidationStatus.createErrorStatus((String)Messages.MapDropValidationService_1);
                }
                if (status == null) {
                    status = ILinkValidator.ValidationStatus.createOkStatus();
                }
            }
            if (status == ILinkValidator.ValidationStatus.createOkStatus() && !((ILogicalField)draggedObject).isStageable() && clause.getLocation() != JoinLocation.SRC) {
                status = ILinkValidator.ValidationStatus.createErrorStatus((String)NLS.bind((String)Messages.MapDropValidationService_2, (Object)((ILogicalField)draggedObject).getLabel()));
            }
            canJoin = status == null || !status.isError();
        } else if (draggedObject instanceof Variable) {
            status = ILinkValidator.ValidationStatus.createOkStatus();
            boolean bl = canJoin = !status.isError();
        }
        if (!canJoin) {
            errorMessage.append(status.getMessage());
            errorMessage.append(".");
        }
        return this.createDropResult(canJoin, canMap, updateStatusLine, errorMessage.toString());
    }

    private IDropValidationService.DropResult validateDropOnContainer(boolean updateStatusLine, IContainer targetContainer, IContainer srcContainer) {
        ILinkValidator.ValidationStatus status = null;
        StringBuilder errorMessage = new StringBuilder();
        boolean canJoin = false;
        boolean canMap = false;
        status = JoinValidator.INSTANCE.canCreateLink((EObject)srcContainer, (EObject)targetContainer);
        if (status != ILinkValidator.ValidationStatus.createOkStatus() && targetContainer.getDataset() != srcContainer.getDataset() && (targetContainer.getDataset().getParent().contains((Object)srcContainer.getDataset()) || targetContainer.getDataset().getChild().contains((Object)srcContainer.getDataset())) && ((Map)targetContainer.eContainer()).hasJoin(targetContainer, srcContainer) && Util.currentKeyPressed != 262144) {
            status = ILinkValidator.ValidationStatus.createOkStatus();
        }
        if (status == ILinkValidator.ValidationStatus.createOkStatus() && Util.currentKeyPressed == 65536) {
            status = DataSetInheritanceValidator.INSTANCE.canCreateLink((EObject)targetContainer.getDataset(), (EObject)srcContainer.getDataset(), true);
        }
        boolean bl = canJoin = !status.isError();
        if (!canJoin) {
            errorMessage.append(status.getMessage());
            errorMessage.append(".");
        }
        boolean bl2 = canMap = !(status = MappingValidator.INSTANCE.canCreateLink((EObject)srcContainer, (EObject)targetContainer)).isError();
        if (!canMap) {
            errorMessage.append(status.getMessage());
            errorMessage.append(".");
        }
        return this.createDropResult(canJoin, canMap, updateStatusLine, errorMessage.toString());
    }

    public IDropValidationService.DropResult validate(EObject draggedObject, EObject targetObject, boolean updateStatusLine) {
        if (targetObject instanceof Clause) {
            return this.validateDropOnClause(updateStatusLine, (Clause)targetObject, draggedObject);
        }
        if (targetObject instanceof Expression) {
            return this.validateDropOnExpression(updateStatusLine, (Expression)targetObject, draggedObject);
        }
        if (targetObject instanceof ILogicalField) {
            return this.validateDropOnLogicalField(updateStatusLine, (ILogicalField)targetObject, draggedObject);
        }
        if (targetObject instanceof IContainer && draggedObject instanceof IContainer) {
            return this.validateDropOnContainer(updateStatusLine, (IContainer)targetObject, (IContainer)draggedObject);
        }
        if (updateStatusLine) {
            StatusLineUtil.outputErrorMessage((IWorkbenchPart)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor(), (String)"");
        }
        return IDropValidationService.DropResult.NONE;
    }
}

