/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.tooltip;

import com.indy.gmf.map.diagram.custom.MapDiagramUtil;
import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.ref.RProblem;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.GroupBoxBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.internal.mapmode.IdentityMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public abstract class TooltipFigure
extends Figure
implements IMapMode {
    static final Font FFIGUREACTIONCODENAMEFIGURE_FONT = new Font((Device)Display.getCurrent(), "Arial", 9, 0);
    private static IdentityMapMode mapMode = new IdentityMapMode();
    private ScrollPane scrollPane;
    private IFigure problemsPane;
    private WrappingLabel contentPane;

    public TooltipFigure() {
        this.setLayoutManager((LayoutManager)new StackLayout());
        this.createScrollContent();
    }

    public void setProblems(List<RProblem> problems) {
        Iterator it = this.problemsPane.getChildren().iterator();
        while (it.hasNext()) {
            IFigure child = (IFigure)it.next();
            it.remove();
        }
        for (RProblem p : problems) {
            WrappingLabel l = new WrappingLabel(p.getErrorMessage());
            l.setFont(FFIGUREACTIONCODENAMEFIGURE_FONT);
            l.setTextWrap(true);
            l.setIconAlignment(8);
            this.problemsPane.add((IFigure)l);
            switch (p.getProblemType()) {
                case ERROR: {
                    l.setIcon(MapDiagramUtil.errorIcon, 0);
                    break;
                }
                case WARNING: {
                    l.setIcon(MapDiagramUtil.warningIcon, 0);
                    break;
                }
                case INFO: {
                    l.setIcon(MapDiagramUtil.infoIcon, 0);
                }
            }
        }
        if (problems.isEmpty()) {
            this.problemsPane.setVisible(false);
            this.problemsPane.setBorder(null);
        } else {
            this.problemsPane.setBorder((Border)new GroupBoxBorder(Messages.TooltipFigure_3));
            this.problemsPane.setVisible(true);
        }
    }

    public void setText(String text) {
        this.contentPane.setText(text);
    }

    private void createScrollContent() {
        Figure content = new Figure();
        ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout(false);
        layout.setIgnoreInvisibleChildren(true);
        layout.setStretchMajorAxis(false);
        layout.setStretchMinorAxis(false);
        content.setLayoutManager((LayoutManager)new FlowLayout(true));
        this.setMaximumSize(new Dimension(200, 150));
        this.problemsPane = new Figure();
        layout = new ConstrainedToolbarLayout(false);
        this.problemsPane.setLayoutManager((LayoutManager)layout);
        layout.setStretchMajorAxis(false);
        layout.setStretchMinorAxis(false);
        content.add(this.problemsPane);
        this.contentPane = new WrappingLabel();
        this.contentPane.setTextWrap(true);
        content.add((IFigure)this.contentPane);
        this.scrollPane = new ScrollPane();
        this.scrollPane.getViewport().setContentsTracksHeight(true);
        this.scrollPane.getViewport().setContentsTracksWidth(true);
        this.scrollPane.setContents((IFigure)content);
        this.add((IFigure)this.scrollPane);
    }

    public int LPtoDP(int logicalUnit) {
        return mapMode.LPtoDP(logicalUnit);
    }

    public int DPtoLP(int deviceUnit) {
        return mapMode.DPtoLP(deviceUnit);
    }

    public Translatable LPtoDP(Translatable t) {
        return mapMode.LPtoDP(t);
    }

    public Translatable DPtoLP(Translatable t) {
        return mapMode.DPtoLP(t);
    }
}

