/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.properties;

import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.ItemProperty;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import com.indy.ui.custom.out.common.properties.ControlFactory;
import com.indy.ui.custom.out.common.properties.UIControl;
import com.indy.ui.custom.out.common.properties.UIControlDescriptor;
import com.stambia.md.Element;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ItemPropertiesUI {
    private ControlFactory controlFactory;
    private TabbedPropertySheetWidgetFactory widgetFactory;

    public ItemPropertiesUI(TabbedPropertySheetWidgetFactory widgetFactory) {
        Assert.isNotNull((Object)widgetFactory);
        this.widgetFactory = widgetFactory;
        this.controlFactory = new ControlFactory(this.widgetFactory);
    }

    protected TabbedPropertySheetWidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    public void disposePropertiesUI(Composite propertiesComposite) {
        Control[] controlArray = propertiesComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
    }

    private Object _getValue4Control(ItemProperty p, Object value, UIControl control) {
        if (control.getMainControl() instanceof Text) {
            if (value == null) {
                return "";
            }
            if (value instanceof List) {
                Object txt = "";
                int i = 0;
                while (i < ((List)value).size()) {
                    Object _o;
                    if (i > 0) {
                        txt = (String)txt + ", ";
                    }
                    if ((_o = ((List)value).get(i)) instanceof Element) {
                        txt = (String)txt + ((Element)_o).getName();
                    } else if (_o != null) {
                        txt = (String)txt + _o.toString();
                    }
                    ++i;
                }
                return txt;
            }
            return value.toString();
        }
        if (control.getMainControl() instanceof Button) {
            if (value == null) {
                return false;
            }
            String _value = value.toString();
            if (_value.equals("true")) {
                return true;
            }
            return false;
        }
        if (control.getMainControl() instanceof CCombo) {
            if (p.getDescriptor() != null && p.getDescriptor().getValueProvider() != null) {
                control.getViewer().setInput((Object)p);
                control.setValue(value);
            } else if (value == null) {
                ((CCombo)control.getMainControl()).setText("");
            } else {
                ((CCombo)control.getMainControl()).setText(value.toString());
            }
        }
        return null;
    }

    public void createPropertiesUI(Composite propertiesComposite, List<ItemProperty> properties, boolean isReadOnly) {
        for (ItemProperty prop : properties) {
            Object val;
            Object ctrlVal;
            final UIControlDescriptor desc = (UIControlDescriptor)Platform.getAdapterManager().getAdapter((Object)prop, UIControlDescriptor.class);
            if (desc == null) continue;
            UIControl ctr = this.controlFactory.createControl(propertiesComposite, desc);
            ctr.hookListeners();
            ctr.setEnabled(!isReadOnly && desc.isEditable(), true);
            if (desc.getValueProvider() != null && (ctrlVal = this._getValue4Control(prop, val = desc.getValueProvider().getValueFromObject(), ctr)) != null) {
                ctr.setValue(ctrlVal);
            }
            final ItemProperty p = prop;
            final ToolTip toolTip = new ToolTip(ctr.getLabelControl(), 2, false){

                protected Composite createToolTipContentArea(Event event, Composite parent) {
                    Composite composite = new Composite(parent, 0);
                    composite.setBackground(parent.getDisplay().getSystemColor(29));
                    CLabel l = new CLabel(composite, 0);
                    l.setBackground(parent.getDisplay().getSystemColor(29));
                    IItemLabelProvider labelProvider = (IItemLabelProvider)MapDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory().adapt((Notifier)p.getTriggerRef(), IItemLabelProvider.class);
                    l.setText(Messages.ItemPropertiesUI_5 + labelProvider.getText((Object)p.getTriggerRef()));
                    l.setImage(ExtendedImageRegistry.getInstance().getImage(labelProvider.getImage((Object)p.getTriggerRef())));
                    GridLayoutFactory.fillDefaults().margins(2, 2).generateLayout(composite);
                    if (desc.getControlTooltype() != null) {
                        Label txt = new Label(composite, 64);
                        txt.setText(desc.getControlTooltype());
                        txt.setBackground(parent.getDisplay().getSystemColor(29));
                    }
                    return composite;
                }
            };
            ctr.getLabelControl().setToolTipText(null);
            toolTip.setHideOnMouseDown(true);
            toolTip.setHideDelay(3000);
            ctr.getLabelControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    toolTip.hide();
                    toolTip.deactivate();
                }
            });
        }
        propertiesComposite.layout();
    }
}

