/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.properties;

import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.gmf.map.diagram.properties.ClausePropertySection;
import com.indy.map.Clause;
import com.indy.map.DataSet;
import com.indy.map.IContainer;
import com.indy.map.Join;
import com.indy.map.JoinLocation;
import com.indy.map.JoinType;
import com.indy.map.Map;
import com.indy.map.MapPackage;
import com.indy.ui.custom.out.fixes.MacOsTextHelper;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class JoinPropertySection
extends ClausePropertySection {
    private static final String orderLabel = Messages.JoinPropertySection_0;
    private ComboViewer leftCv;
    private ComboViewer rightCv;
    private Group expressionGroup;
    private Button innerButton;
    private Button crossButton;
    private Button fullButton;
    private Button rightButton;
    private Button leftButton;
    private Group orderGroup;
    private Text orderText;
    ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    AdapterFactoryLabelProvider aflp = new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory);
    IStructuredContentProvider scp = new IStructuredContentProvider(){

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map) {
                return ((Map)inputElement).getContainer().toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    };
    private Button swap;

    @Override
    protected void initializeControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(1808);
        parent.setLayoutData((Object)gridData);
        Composite topComposite = this.getWidgetFactory().createComposite(parent);
        gridData = new GridData(1808);
        topComposite.setLayoutData((Object)gridData);
        topComposite.setLayout((Layout)new GridLayout(4, false));
        MacOsTextHelper.handle((Composite)topComposite, (Composite)parent.getParent());
        this.enableButton = this.getWidgetFactory().createButton(topComposite, enableLabel, 32);
        this.connectCheckBox(this.enableButton, (EStructuralFeature)MapPackage.eINSTANCE.getClause_Enable());
        this.createTypeGroup(topComposite);
        this.createLocationGroup(topComposite, 1);
        this.createLeftRightComposite(topComposite);
        this.createDescriptionGroup(topComposite, 4);
    }

    private void createOrderGroup(Composite composite) {
        GridData gridData = new GridData();
        this.orderGroup = this.getWidgetFactory().createGroup(composite, orderLabel);
        GridLayout gridLayout = new GridLayout(3, false);
        this.orderGroup.setLayoutData((Object)gridData);
        this.orderGroup.setLayout((Layout)gridLayout);
        this.orderText = this.getWidgetFactory().createText((Composite)this.orderGroup, "");
        this.connectBigInteger(this.orderText, (EStructuralFeature)MapPackage.eINSTANCE.getJoin_Order());
        this.orderText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.matches("[0-9]*");
            }
        });
        gridData.widthHint = 0;
    }

    private void createLeftRightComposite(Composite composite) {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        GridData gridData = new GridData(770);
        Composite leftRightComposite = this.getWidgetFactory().createComposite(composite);
        gridData.horizontalSpan = 3;
        leftRightComposite.setLayout((Layout)new GridLayout(3, false));
        leftRightComposite.setLayoutData((Object)gridData);
        Group leftGroup = this.getWidgetFactory().createGroup(leftRightComposite, leftPartLabel);
        gridData = new GridData(4, 1, true, false);
        leftGroup.setLayoutData((Object)gridData);
        leftGroup.setLayout((Layout)new GridLayout(3, false));
        this.swap = this.getWidgetFactory().createButton(leftRightComposite, "<->", 8);
        this.swap.setLayoutData((Object)new GridData(2, 2, false, true));
        this.swap.setToolTipText(Messages.JoinPropertySection_4);
        this.swap.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EObject eObject = JoinPropertySection.this.getEObject();
                if (eObject instanceof Join) {
                    TransactionalEditingDomain ed = TransactionUtil.getEditingDomain((EObject)JoinPropertySection.this.getEObject());
                    IContainer left = ((Join)eObject).getLeft();
                    IContainer right = ((Join)eObject).getRight();
                    SetCommand outerCmd = null;
                    if ((((Join)eObject).getJoinType() == JoinType.LEFT_JOIN || ((Join)eObject).getJoinType() == JoinType.RIGHT_JOIN) && MessageDialog.openQuestion((Shell)JoinPropertySection.this.swap.getShell(), (String)Messages.JoinPropertySection_1, (String)Messages.JoinPropertySection_2)) {
                        outerCmd = ((Join)eObject).getJoinType() == JoinType.LEFT_JOIN ? new SetCommand((EditingDomain)ed, JoinPropertySection.this.getEObject(), (EStructuralFeature)MapPackage.eINSTANCE.getJoin_JoinType(), (Object)JoinType.RIGHT_JOIN) : new SetCommand((EditingDomain)ed, JoinPropertySection.this.getEObject(), (EStructuralFeature)MapPackage.eINSTANCE.getJoin_JoinType(), (Object)JoinType.LEFT_JOIN);
                    }
                    if (left != null && right != null) {
                        CompoundCommand cc = new CompoundCommand();
                        cc.append((Command)new SetCommand((EditingDomain)ed, JoinPropertySection.this.getEObject(), (EStructuralFeature)MapPackage.eINSTANCE.getJoin_Right(), (Object)left));
                        cc.append((Command)new SetCommand((EditingDomain)ed, JoinPropertySection.this.getEObject(), (EStructuralFeature)MapPackage.eINSTANCE.getJoin_Left(), (Object)right));
                        if (outerCmd != null) {
                            cc.append((Command)outerCmd);
                        }
                        ed.getCommandStack().execute((Command)cc);
                        JoinPropertySection.this.refresh();
                    }
                }
            }
        });
        gridData = new GridData(768);
        this.leftCv = new ComboViewer(this.getWidgetFactory().createCCombo((Composite)leftGroup));
        this.leftCv.setLabelProvider((IBaseLabelProvider)this.aflp);
        this.leftCv.setContentProvider((IContentProvider)this.scp);
        gridData.widthHint = 0;
        this.leftCv.getCCombo().setLayoutData((Object)gridData);
        this.leftCv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)JoinPropertySection.this.leftCv.getSelection();
                IContainer source = (IContainer)sel.getFirstElement();
                if (source != ((Join)JoinPropertySection.this.getEObject()).getLeft() && source != null) {
                    TransactionalEditingDomain ed = TransactionUtil.getEditingDomain((EObject)JoinPropertySection.this.getEObject());
                    SetCommand sc = new SetCommand((EditingDomain)ed, JoinPropertySection.this.getEObject(), (EStructuralFeature)MapPackage.eINSTANCE.getJoin_Left(), (Object)source);
                    ed.getCommandStack().execute((Command)sc);
                }
            }
        });
        this.leftButton = this.getWidgetFactory().createButton((Composite)leftGroup, "", 16);
        this.connectRadioButton(this.leftButton, (EStructuralFeature)MapPackage.eINSTANCE.getJoin_JoinType(), JoinType.LEFT_JOIN);
        Group rightGroup = this.getWidgetFactory().createGroup(leftRightComposite, rightPartLabel);
        gridData = new GridData(4, 1, true, false);
        gridData.verticalSpan = 2;
        rightGroup.setLayoutData((Object)gridData);
        rightGroup.setLayout((Layout)new GridLayout(2, false));
        this.rightButton = this.getWidgetFactory().createButton((Composite)rightGroup, "", 16);
        this.connectRadioButton(this.rightButton, (EStructuralFeature)MapPackage.eINSTANCE.getJoin_JoinType(), JoinType.RIGHT_JOIN);
        gridData = new GridData(768);
        gridData.widthHint = 0;
        this.rightCv = new ComboViewer(this.getWidgetFactory().createCCombo((Composite)rightGroup));
        this.rightCv.setLabelProvider((IBaseLabelProvider)this.aflp);
        this.rightCv.setContentProvider((IContentProvider)this.scp);
        this.rightCv.getCCombo().setLayoutData((Object)gridData);
        this.rightCv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)JoinPropertySection.this.rightCv.getSelection();
                IContainer source = (IContainer)sel.getFirstElement();
                if (source != ((Join)JoinPropertySection.this.getEObject()).getRight() && source != null) {
                    TransactionalEditingDomain ed = TransactionUtil.getEditingDomain((EObject)JoinPropertySection.this.getEObject());
                    SetCommand sc = new SetCommand((EditingDomain)ed, JoinPropertySection.this.getEObject(), (EStructuralFeature)MapPackage.eINSTANCE.getJoin_Right(), (Object)source);
                    ed.getCommandStack().execute((Command)sc);
                }
            }
        });
    }

    protected void refreshRadioButton(JoinType type) {
        this.fullButton.setSelection(false);
        this.crossButton.setSelection(false);
        this.innerButton.setSelection(false);
        this.leftButton.setSelection(false);
        this.rightButton.setSelection(false);
        switch (type.getValue()) {
            case 3: {
                this.crossButton.setSelection(true);
                break;
            }
            case 4: {
                this.fullButton.setSelection(true);
                break;
            }
            case 0: {
                this.innerButton.setSelection(true);
                break;
            }
            case 1: {
                this.leftButton.setSelection(true);
                break;
            }
            case 2: {
                this.rightButton.setSelection(true);
            }
        }
    }

    private void createTypeGroup(Composite composite) {
        GridData gridData = new GridData(802);
        this.expressionGroup = this.getWidgetFactory().createGroup(composite, joinTypeLabel);
        GridLayout gridLayout = new GridLayout(3, false);
        this.expressionGroup.setLayoutData((Object)gridData);
        this.expressionGroup.setLayout((Layout)gridLayout);
        this.innerButton = this.getWidgetFactory().createButton((Composite)this.expressionGroup, Messages.JoinPropertySection_7, 16);
        this.connectRadioButton(this.innerButton, (EStructuralFeature)MapPackage.eINSTANCE.getJoin_JoinType(), JoinType.INNER_JOIN);
        this.crossButton = this.getWidgetFactory().createButton((Composite)this.expressionGroup, Messages.JoinPropertySection_8, 16);
        this.connectRadioButton(this.crossButton, (EStructuralFeature)MapPackage.eINSTANCE.getJoin_JoinType(), JoinType.CROSS_JOIN);
        this.fullButton = this.getWidgetFactory().createButton((Composite)this.expressionGroup, Messages.JoinPropertySection_9, 16);
        this.connectRadioButton(this.fullButton, (EStructuralFeature)MapPackage.eINSTANCE.getJoin_JoinType(), JoinType.FULL_JOIN);
    }

    public void refresh() {
        super.refresh();
        if (!this.isDisposed()) {
            this.executeAsReadAction(new Runnable(){

                @Override
                public void run() {
                    EObject eObject = JoinPropertySection.this.getEObject();
                    JoinPropertySection.this.swap.setEnabled(false);
                    if (eObject instanceof Join) {
                        Clause expression = (Clause)eObject;
                        boolean isReadOnly = JoinPropertySection.this.isReadOnly();
                        JoinPropertySection.this.enableButton.setSelection(expression.isEnable());
                        JoinPropertySection.this.enableButton.setEnabled(!isReadOnly);
                        DataSet ds = null;
                        boolean isInheritJoin = false;
                        for (IContainer c : expression.getInvolvedContainers()) {
                            if (ds == null) {
                                ds = c.getDataset();
                                continue;
                            }
                            if (ds == c.getDataset()) continue;
                            isInheritJoin = true;
                            break;
                        }
                        JoinPropertySection.this.swap.setEnabled(((Join)expression).getLeft() != null && ((Join)expression).getRight() != null);
                        JoinPropertySection.this.sourceB.setEnabled(!isInheritJoin);
                        JoinPropertySection.this.workB.setEnabled(!isInheritJoin);
                        if (expression.getLocation().equals((Object)JoinLocation.SRC)) {
                            JoinPropertySection.this.sourceB.setSelection(true);
                            JoinPropertySection.this.workB.setSelection(false);
                        } else if (expression.getLocation() == JoinLocation.WRK) {
                            JoinPropertySection.this.sourceB.setSelection(false);
                            JoinPropertySection.this.workB.setSelection(true);
                        }
                        JoinPropertySection.this.descriptionText.setText(expression.getDescription() != null ? expression.getDescription() : "");
                        Join join = (Join)JoinPropertySection.this.getEObject();
                        JoinPropertySection.this.leftCv.setInput((Object)((Map)join.eContainer()));
                        if (join.getLeft() != null) {
                            JoinPropertySection.this.leftCv.setSelection((ISelection)new StructuredSelection((Object)join.getLeft()));
                        }
                        JoinPropertySection.this.rightCv.setInput((Object)((Map)join.eContainer()));
                        if (join.getRight() != null) {
                            JoinPropertySection.this.rightCv.setSelection((ISelection)new StructuredSelection((Object)join.getRight()));
                        }
                        JoinPropertySection.this.refreshRadioButton(join.getJoinType());
                    }
                }
            });
        }
    }
}

